/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.maven.cli.BatchModeMavenTransferListener;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.cli.ConsoleMavenTransferListener;
import org.apache.maven.cli.ExecutionEventLogger;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.cli.MavenExecutionRequestBuilder;
import org.apache.maven.cli.MavenExecutionRequestsBuilderException;
import org.apache.maven.cli.PrintStreamLogger;
import org.apache.maven.cli.QuietMavenTransferListener;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.lifecycle.internal.LifecycleWeaveBuilder;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.impl.internal.EnhancedLocalRepositoryManager;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

@Component(role=MavenExecutionRequestBuilder.class)
public class DefaultMavenExecutionRequestBuilder
implements MavenExecutionRequestBuilder,
Initializable {
    @Requirement
    private SettingsBuilder settingsBuilder;
    @Requirement
    private MavenExecutionRequestPopulator executionRequestPopulator;
    @Requirement
    private Logger plexusLogger;
    @Requirement
    private ModelProcessor modelProcessor;
    @Requirement
    private PlexusContainer plexusContainer;
    private DefaultSecDispatcher dispatcher;
    static final String DEFAULT_BUILD_TIMESTAMP_FORMAT = "yyyyMMdd-HHmm";

    public void initialize() throws InitializationException {
        try {
            this.dispatcher = (DefaultSecDispatcher)this.plexusContainer.lookup(SecDispatcher.class, "maven");
        }
        catch (ComponentLookupException e) {
            throw new InitializationException(e.getMessage(), (Throwable)e);
        }
    }

    public MavenExecutionRequest getMavenExecutionRequest(String[] args, PrintStream printStream) throws MavenExecutionRequestPopulationException, SettingsBuildingException, MavenExecutionRequestsBuilderException {
        try {
            CliRequest cliRequest = new CliRequest(args, null);
            this.initialize(cliRequest, printStream);
            this.cli(cliRequest);
            this.logging(cliRequest);
            this.commands(cliRequest);
            this.properties(cliRequest);
            this.settings(cliRequest);
            this.populateRequest(cliRequest);
            this.encryption(cliRequest);
            MavenExecutionRequest request = this.executionRequestPopulator.populateDefaults(cliRequest.request);
            if (request.getProjectBuildingRequest().getRepositorySession() == null) {
                MavenRepositorySystemSession session = new MavenRepositorySystemSession();
                if (session.getLocalRepositoryManager() == null) {
                    session.setLocalRepositoryManager((LocalRepositoryManager)new EnhancedLocalRepositoryManager(request.getLocalRepositoryPath()));
                }
                request.getProjectBuildingRequest().setRepositorySession((RepositorySystemSession)session);
            }
            return request;
        }
        catch (Exception e) {
            throw new MavenExecutionRequestsBuilderException(e.getMessage(), (Throwable)e);
        }
    }

    static File resolveFile(File file, String workingDirectory) {
        if (file == null) {
            return null;
        }
        if (file.isAbsolute()) {
            return file;
        }
        if (file.getPath().startsWith(File.separator)) {
            return file.getAbsoluteFile();
        }
        return new File(workingDirectory, file.getPath()).getAbsoluteFile();
    }

    private void initialize(CliRequest cliRequest, PrintStream printStream) {
        String mavenHome;
        if (cliRequest.stdout == null) {
            cliRequest.stdout = System.out;
        }
        if (cliRequest.stderr == null) {
            cliRequest.stderr = System.err;
        }
        if (cliRequest.logger == null) {
            cliRequest.logger = new PrintStreamLogger(cliRequest.stdout);
        } else {
            cliRequest.logger.setStream(cliRequest.stdout);
        }
        if (cliRequest.workingDirectory == null) {
            cliRequest.workingDirectory = System.getProperty("user.dir");
        }
        if ((mavenHome = System.getProperty("maven.home")) != null) {
            System.setProperty("maven.home", new File(mavenHome).getAbsolutePath());
        }
    }

    private void cli(CliRequest cliRequest) throws Exception {
        CLIManager cliManager = new CLIManager();
        try {
            cliRequest.commandLine = cliManager.parse(cliRequest.args);
        }
        catch (ParseException e) {
            cliRequest.stderr.println("Unable to parse command line options: " + e.getMessage());
            cliManager.displayHelp(cliRequest.stdout);
            throw e;
        }
        if (cliRequest.commandLine.hasOption('h')) {
            cliManager.displayHelp(cliRequest.stdout);
            throw new MavenCli.ExitException(0);
        }
        if (cliRequest.commandLine.hasOption('v')) {
            CLIReportingUtils.showVersion((PrintStream)cliRequest.stdout);
            throw new MavenCli.ExitException(0);
        }
    }

    private void logging(CliRequest cliRequest) {
        cliRequest.debug = cliRequest.commandLine.hasOption('X');
        cliRequest.quiet = !cliRequest.debug && cliRequest.commandLine.hasOption('q');
        boolean bl = cliRequest.showErrors = cliRequest.debug || cliRequest.commandLine.hasOption('e');
        if (cliRequest.debug) {
            cliRequest.request.setLoggingLevel(0);
        } else if (cliRequest.quiet) {
            cliRequest.request.setLoggingLevel(3);
        } else {
            cliRequest.request.setLoggingLevel(1);
        }
        this.plexusLogger.setThreshold(cliRequest.request.getLoggingLevel());
        if (cliRequest.commandLine.hasOption("l")) {
            File logFile = new File(cliRequest.commandLine.getOptionValue("l"));
            logFile = DefaultMavenExecutionRequestBuilder.resolveFile(logFile, cliRequest.workingDirectory);
            try {
                cliRequest.fileStream = new PrintStream(logFile);
                cliRequest.logger.setStream(cliRequest.fileStream);
            }
            catch (FileNotFoundException e) {
                cliRequest.stderr.println(e);
                cliRequest.logger.setStream(cliRequest.stdout);
            }
        } else {
            cliRequest.logger.setStream(cliRequest.stdout);
        }
        cliRequest.request.setExecutionListener((ExecutionListener)new ExecutionEventLogger((Logger)cliRequest.logger));
    }

    private void commands(CliRequest cliRequest) {
        if (cliRequest.debug || cliRequest.commandLine.hasOption('V')) {
            CLIReportingUtils.showVersion((PrintStream)cliRequest.stdout);
        }
        if (cliRequest.showErrors) {
            cliRequest.logger.info("Error stacktraces are turned on.");
        }
        if ("warn".equals(cliRequest.request.getGlobalChecksumPolicy())) {
            cliRequest.logger.info("Disabling strict checksum verification on all artifact downloads.");
        } else if ("fail".equals(cliRequest.request.getGlobalChecksumPolicy())) {
            cliRequest.logger.info("Enabling strict checksum verification on all artifact downloads.");
        }
    }

    private void properties(CliRequest cliRequest) {
        DefaultMavenExecutionRequestBuilder.populateProperties(cliRequest.commandLine, cliRequest.systemProperties, cliRequest.userProperties);
    }

    static void populateProperties(CommandLine commandLine, Properties systemProperties, Properties userProperties) {
        String[] defStrs;
        EnvironmentUtils.addEnvVars((Properties)systemProperties);
        if (commandLine.hasOption('D') && (defStrs = commandLine.getOptionValues('D')) != null) {
            for (int i = 0; i < defStrs.length; ++i) {
                DefaultMavenExecutionRequestBuilder.setCliProperty(defStrs[i], userProperties);
            }
        }
        systemProperties.putAll((Map<?, ?>)System.getProperties());
        systemProperties.put("maven.build.timestamp", new SimpleDateFormat(DEFAULT_BUILD_TIMESTAMP_FORMAT).format(new Date()));
    }

    private static void setCliProperty(String property, Properties properties) {
        String value;
        String name;
        int i = property.indexOf("=");
        if (i <= 0) {
            name = property.trim();
            value = "true";
        } else {
            name = property.substring(0, i).trim();
            value = property.substring(i + 1);
        }
        properties.setProperty(name, value);
        System.setProperty(name, value);
    }

    private void settings(CliRequest cliRequest) throws Exception {
        File globalSettingsFile;
        File userSettingsFile;
        if (cliRequest.commandLine.hasOption('s')) {
            userSettingsFile = new File(cliRequest.commandLine.getOptionValue('s'));
            if (!(userSettingsFile = DefaultMavenExecutionRequestBuilder.resolveFile(userSettingsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified user settings file does not exist: " + userSettingsFile);
            }
        } else {
            userSettingsFile = MavenCli.DEFAULT_USER_SETTINGS_FILE;
        }
        cliRequest.logger.debug("Reading user settings from " + userSettingsFile);
        if (cliRequest.commandLine.hasOption("gs")) {
            globalSettingsFile = new File(cliRequest.commandLine.getOptionValue("gs"));
            if (!(globalSettingsFile = DefaultMavenExecutionRequestBuilder.resolveFile(globalSettingsFile, cliRequest.workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified global settings file does not exist: " + globalSettingsFile);
            }
        } else {
            globalSettingsFile = MavenCli.DEFAULT_GLOBAL_SETTINGS_FILE;
        }
        cliRequest.logger.debug("Reading global settings from " + globalSettingsFile);
        cliRequest.request.setGlobalSettingsFile(globalSettingsFile);
        cliRequest.request.setUserSettingsFile(userSettingsFile);
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        settingsRequest.setGlobalSettingsFile(globalSettingsFile);
        settingsRequest.setUserSettingsFile(userSettingsFile);
        settingsRequest.setSystemProperties(cliRequest.systemProperties);
        settingsRequest.setUserProperties(cliRequest.userProperties);
        SettingsBuildingResult settingsResult = this.settingsBuilder.build((SettingsBuildingRequest)settingsRequest);
        this.executionRequestPopulator.populateFromSettings(cliRequest.request, settingsResult.getEffectiveSettings());
        if (!settingsResult.getProblems().isEmpty() && cliRequest.logger.isWarnEnabled()) {
            cliRequest.logger.warn("");
            cliRequest.logger.warn("Some problems were encountered while building the effective settings");
            for (SettingsProblem problem : settingsResult.getProblems()) {
                cliRequest.logger.warn(problem.getMessage() + " @ " + problem.getLocation());
            }
            cliRequest.logger.warn("");
        }
    }

    private MavenExecutionRequest populateRequest(CliRequest cliRequest) {
        String threadConfiguration;
        File pom;
        File userToolchainsFile;
        String[] profileOptionValues;
        String[] deprecatedOptions;
        MavenExecutionRequest request = cliRequest.request;
        CommandLine commandLine = cliRequest.commandLine;
        String workingDirectory = cliRequest.workingDirectory;
        boolean debug = cliRequest.debug;
        boolean quiet = cliRequest.quiet;
        boolean showErrors = cliRequest.showErrors;
        for (String deprecatedOption : deprecatedOptions = new String[]{"up", "npu", "cpu", "npr"}) {
            if (!commandLine.hasOption(deprecatedOption)) continue;
            cliRequest.stdout.println("[WARNING] Command line option -" + deprecatedOption + " is deprecated and will be removed in future Maven versions.");
        }
        if (commandLine.hasOption('B')) {
            request.setInteractiveMode(false);
        }
        boolean noSnapshotUpdates = false;
        if (commandLine.hasOption("nsu")) {
            noSnapshotUpdates = true;
        }
        List goals = commandLine.getArgList();
        boolean recursive = true;
        String reactorFailureBehaviour = "FAIL_FAST";
        if (commandLine.hasOption('N')) {
            recursive = false;
        }
        if (commandLine.hasOption("ff")) {
            reactorFailureBehaviour = "FAIL_FAST";
        } else if (commandLine.hasOption("fae")) {
            reactorFailureBehaviour = "FAIL_AT_END";
        } else if (commandLine.hasOption("fn")) {
            reactorFailureBehaviour = "FAIL_NEVER";
        }
        if (commandLine.hasOption('o')) {
            request.setOffline(true);
        }
        boolean updateSnapshots = false;
        if (commandLine.hasOption('U')) {
            updateSnapshots = true;
        }
        String globalChecksumPolicy = null;
        if (commandLine.hasOption('C')) {
            globalChecksumPolicy = "fail";
        } else if (commandLine.hasOption('c')) {
            globalChecksumPolicy = "warn";
        }
        File baseDirectory = new File(workingDirectory, "").getAbsoluteFile();
        ArrayList<String> activeProfiles = new ArrayList<String>();
        ArrayList<String> inactiveProfiles = new ArrayList<String>();
        if (commandLine.hasOption('P') && (profileOptionValues = commandLine.getOptionValues('P')) != null) {
            for (int i = 0; i < profileOptionValues.length; ++i) {
                StringTokenizer profileTokens = new StringTokenizer(profileOptionValues[i], ",");
                while (profileTokens.hasMoreTokens()) {
                    String profileAction = profileTokens.nextToken().trim();
                    if (profileAction.startsWith("-") || profileAction.startsWith("!")) {
                        inactiveProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    if (profileAction.startsWith("+")) {
                        activeProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    activeProfiles.add(profileAction);
                }
            }
        }
        Object transferListener = quiet ? new QuietMavenTransferListener() : (request.isInteractiveMode() ? new ConsoleMavenTransferListener(cliRequest.stdout) : new BatchModeMavenTransferListener(cliRequest.stdout));
        String alternatePomFile = null;
        if (commandLine.hasOption('f')) {
            alternatePomFile = commandLine.getOptionValue('f');
        }
        int loggingLevel = debug ? 0 : (quiet ? 3 : 1);
        if (commandLine.hasOption('t')) {
            userToolchainsFile = new File(commandLine.getOptionValue('t'));
            userToolchainsFile = DefaultMavenExecutionRequestBuilder.resolveFile(userToolchainsFile, workingDirectory);
        } else {
            userToolchainsFile = MavenCli.DEFAULT_USER_TOOLCHAINS_FILE;
        }
        request.setBaseDirectory(baseDirectory).setGoals(goals).setSystemProperties(cliRequest.systemProperties).setUserProperties(cliRequest.userProperties).setReactorFailureBehavior(reactorFailureBehaviour).setRecursive(recursive).setShowErrors(showErrors).addActiveProfiles(activeProfiles).addInactiveProfiles(inactiveProfiles).setLoggingLevel(loggingLevel).setTransferListener((TransferListener)transferListener).setUpdateSnapshots(updateSnapshots).setNoSnapshotUpdates(noSnapshotUpdates).setGlobalChecksumPolicy(globalChecksumPolicy).setUserToolchainsFile(userToolchainsFile);
        if (alternatePomFile != null) {
            pom = DefaultMavenExecutionRequestBuilder.resolveFile(new File(alternatePomFile), workingDirectory);
            request.setPom(pom);
        } else {
            pom = this.modelProcessor.locatePom(baseDirectory);
            if (pom.isFile()) {
                request.setPom(pom);
            }
        }
        if (request.getPom() != null && request.getPom().getParentFile() != null) {
            request.setBaseDirectory(request.getPom().getParentFile());
        }
        if (commandLine.hasOption("rf")) {
            request.setResumeFrom(commandLine.getOptionValue("rf"));
        }
        if (commandLine.hasOption("pl")) {
            String projectList = commandLine.getOptionValue("pl");
            String[] projects = StringUtils.split((String)projectList, (String)",");
            request.setSelectedProjects(Arrays.asList(projects));
        }
        if (commandLine.hasOption("am") && !commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-upstream");
        } else if (!commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-downstream");
        } else if (commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-both");
        }
        String localRepoProperty = request.getUserProperties().getProperty("maven.repo.local");
        if (localRepoProperty == null) {
            localRepoProperty = request.getSystemProperties().getProperty("maven.repo.local");
        }
        if (localRepoProperty != null) {
            request.setLocalRepositoryPath(localRepoProperty);
        }
        String string = threadConfiguration = commandLine.hasOption("T") ? commandLine.getOptionValue("T") : request.getSystemProperties().getProperty("maven.threads.experimental");
        if (threadConfiguration != null) {
            request.setPerCoreThreadCount(threadConfiguration.contains("C"));
            if (threadConfiguration.contains("W")) {
                LifecycleWeaveBuilder.setWeaveMode((Properties)request.getUserProperties());
            }
            request.setThreadCount(threadConfiguration.replace("C", "").replace("W", "").replace("auto", ""));
        }
        return request;
    }

    private void encryption(CliRequest cliRequest) throws Exception {
        if (cliRequest.commandLine.hasOption("emp")) {
            String passwd = cliRequest.commandLine.getOptionValue("emp");
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            cliRequest.stdout.println(cipher.encryptAndDecorate(passwd, "settings.security"));
            throw new MavenCli.ExitException(0);
        }
        if (cliRequest.commandLine.hasOption("ep")) {
            String passwd = cliRequest.commandLine.getOptionValue("ep");
            String configurationFile = this.dispatcher.getConfigurationFile();
            if (configurationFile.startsWith("~")) {
                configurationFile = System.getProperty("user.home") + configurationFile.substring(1);
            }
            String file = System.getProperty("settings.security", configurationFile);
            String master = null;
            SettingsSecurity sec = SecUtil.read((String)file, (boolean)true);
            if (sec != null) {
                master = sec.getMaster();
            }
            if (master == null) {
                throw new IllegalStateException("Master password is not set in the setting security file: " + file);
            }
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            String masterPasswd = cipher.decryptDecorated(master, "settings.security");
            cliRequest.stdout.println(cipher.encryptAndDecorate(passwd, masterPasswd));
            throw new MavenCli.ExitException(0);
        }
    }

    static class CliRequest {
        String[] args;
        CommandLine commandLine;
        PrintStream stdout;
        PrintStream stderr;
        ClassWorld classWorld;
        String workingDirectory;
        boolean debug;
        boolean quiet;
        boolean showErrors = true;
        PrintStream fileStream;
        Properties userProperties = new Properties();
        Properties systemProperties = new Properties();
        MavenExecutionRequest request;
        PrintStreamLogger logger;

        CliRequest(String[] args, ClassWorld classWorld) {
            this.args = args;
            this.classWorld = classWorld;
            this.request = new DefaultMavenExecutionRequest();
        }
    }
}

