/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Asynchronous;
import hudson.remoting.AtmostOneThreadExecutor;
import hudson.remoting.Channel;
import hudson.remoting.DaemonThreadFactory;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.IReadResolve;
import hudson.remoting.NamingThreadFactory;
import hudson.remoting.RemotingSystemException;
import hudson.remoting.Request;
import hudson.remoting.UnexportCommand;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import org.jenkinsci.remoting.RoleChecker;

final class RemoteInvocationHandler
implements InvocationHandler,
Serializable {
    private static final Logger logger = Logger.getLogger(RemoteInvocationHandler.class.getName());
    private static final Unexporter UNEXPORTER = new Unexporter();
    private final int oid;
    @CheckForNull
    private transient Channel.Ref channel;
    private final boolean userProxy;
    private final boolean autoUnexportByCaller;
    private boolean goingHome;
    private final Throwable origin;
    private static final long serialVersionUID = 1L;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    RemoteInvocationHandler(Channel channel, int id, boolean userProxy, boolean autoUnexportByCaller, Class proxyType) {
        this.channel = channel == null ? null : channel.ref();
        this.oid = id;
        this.userProxy = userProxy;
        this.origin = new Exception("Proxy " + this.toString() + " was created for " + proxyType);
        this.autoUnexportByCaller = autoUnexportByCaller;
    }

    public static <T> T wrap(Channel channel, int id, Class<T> type, boolean userProxy, boolean autoUnexportByCaller) {
        ClassLoader cl = type.getClassLoader();
        if (cl == null || cl == ClassLoader.getSystemClassLoader()) {
            cl = IReadResolve.class.getClassLoader();
        }
        RemoteInvocationHandler handler = new RemoteInvocationHandler(channel, id, userProxy, autoUnexportByCaller, type);
        if (channel != null && !autoUnexportByCaller) {
            RemoteInvocationHandler.UNEXPORTER.watch(handler);
        }
        return type.cast(Proxy.newProxyInstance(cl, new Class[]{type, IReadResolve.class}, (InvocationHandler)handler));
    }

    static void notifyChannelTermination(Channel channel) {
        RemoteInvocationHandler.UNEXPORTER.onChannelTermination(channel);
    }

    static Class getProxyClass(Class type) {
        return Proxy.getProxyClass(type.getClassLoader(), type, IReadResolve.class);
    }

    @CheckForNull
    private Channel channel() {
        return this.channel == null ? null : this.channel.channel();
    }

    @CheckForNull
    private Channel channelOrFail() throws IOException {
        Channel channel = this.channel();
        if (channel == null) {
            throw new IOException("Backing channel is disconnected.");
        }
        return channel;
    }

    public static int unwrap(Object proxy, Channel src) {
        RemoteInvocationHandler rih;
        InvocationHandler h = Proxy.getInvocationHandler(proxy);
        if (h instanceof RemoteInvocationHandler && (rih = (RemoteInvocationHandler)h).channel() == src) {
            return rih.oid;
        }
        return -1;
    }

    public static Channel unwrap(Object proxy) {
        InvocationHandler h = Proxy.getInvocationHandler(proxy);
        if (h instanceof RemoteInvocationHandler) {
            RemoteInvocationHandler rih = (RemoteInvocationHandler)h;
            return rih.channel();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> dc;
        if (method.getDeclaringClass() == IReadResolve.class) {
            if (!this.goingHome) return proxy;
            return Channel.current().getExportedObject(this.oid);
        }
        if (this.channel == null) {
            throw new IllegalStateException("proxy is not connected to a channel");
        }
        if (args == null) {
            args = EMPTY_ARRAY;
        }
        if ((dc = method.getDeclaringClass()) == Object.class) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        boolean async = method.isAnnotationPresent(Asynchronous.class);
        RPCRequest req = new RPCRequest(this.oid, method, args, this.userProxy ? dc.getClassLoader() : null);
        try {
            if (this.userProxy) {
                if (!async) return this.channelOrFail().call(req);
                this.channelOrFail().callAsync(req);
                return null;
            } else {
                if (!async) return req.call(this.channelOrFail());
                req.callAsync(this.channelOrFail());
            }
            return null;
        }
        catch (Throwable e) {
            for (Class<?> exc : method.getExceptionTypes()) {
                if (!exc.isInstance(e)) continue;
                throw e;
            }
            if (!(e instanceof RuntimeException) && !(e instanceof Error)) throw new RemotingSystemException(e);
            throw e;
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.goingHome) {
            this.channel = null;
        } else {
            Channel channel = Channel.current();
            Channel.Ref ref = this.channel = channel == null ? null : channel.ref();
            if (channel != null && !this.autoUnexportByCaller) {
                RemoteInvocationHandler.UNEXPORTER.watch(this);
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.goingHome = this.channel != null;
        oos.defaultWriteObject();
    }

    public boolean equals(Object o) {
        if (o != null && Proxy.isProxyClass(o.getClass())) {
            o = Proxy.getInvocationHandler(o);
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteInvocationHandler that = (RemoteInvocationHandler)o;
        return this.oid == that.oid && this.channel == that.channel;
    }

    public int hashCode() {
        return this.oid;
    }

    static final class RPCRequest
    extends Request<Serializable, Throwable>
    implements DelegatingCallable<Serializable, Throwable> {
        private final int oid;
        private final String methodName;
        private final String[] types;
        private final Object[] arguments;
        private transient ClassLoader classLoader;
        private static final long serialVersionUID = 1L;

        public RPCRequest(int oid, Method m, Object[] arguments) {
            this(oid, m, arguments, null);
        }

        public RPCRequest(int oid, Method m, Object[] arguments, ClassLoader cl) {
            this.oid = oid;
            this.arguments = arguments;
            this.methodName = m.getName();
            this.classLoader = cl;
            this.types = new String[arguments.length];
            Class<?>[] params = m.getParameterTypes();
            for (int i = 0; i < arguments.length; ++i) {
                this.types[i] = params[i].getName();
            }
            assert (this.types.length == arguments.length);
        }

        @Override
        public Serializable call() throws Throwable {
            return this.perform(Channel.current());
        }

        @Override
        public void checkRoles(RoleChecker checker) throws SecurityException {
        }

        @Override
        public ClassLoader getClassLoader() {
            if (this.classLoader != null) {
                return this.classLoader;
            }
            return this.getClass().getClassLoader();
        }

        @Override
        protected Serializable perform(Channel channel) throws Throwable {
            Object o = channel.getExportedObject(this.oid);
            Object[] clazz = channel.getExportedTypes(this.oid);
            try {
                Object r;
                Method m = this.choose((Class[])clazz);
                if (m == null) {
                    throw new IllegalStateException("Unable to call " + this.methodName + ". No matching method found in " + Arrays.toString(clazz) + " for " + o);
                }
                m.setAccessible(true);
                try {
                    r = m.invoke(o, this.arguments);
                }
                catch (IllegalArgumentException x) {
                    throw new RemotingSystemException("failed to invoke " + m + " on " + o + Arrays.toString(this.arguments), x);
                }
                if (r == null || r instanceof Serializable) {
                    return (Serializable)r;
                }
                throw new RemotingSystemException(new ClassCastException(r.getClass() + " is returned from " + m + " on " + o.getClass() + " but it's not serializable"));
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private Method choose(Class[] interfaces) {
            for (Class clazz : interfaces) {
                block1: for (Method m : clazz.getMethods()) {
                    Class<?>[] paramTypes;
                    if (!m.getName().equals(this.methodName) || (paramTypes = m.getParameterTypes()).length != this.arguments.length) continue;
                    for (int i = 0; i < this.types.length; ++i) {
                        if (!this.types[i].equals(paramTypes[i].getName())) continue block1;
                    }
                    return m;
                }
            }
            return null;
        }

        Object[] getArguments() {
            return this.arguments;
        }

        public String toString() {
            return "RPCRequest(" + this.oid + "," + this.methodName + ")";
        }
    }

    private static class Unexporter
    implements Runnable {
        private final ExecutorService svc = new AtmostOneThreadExecutor(new NamingThreadFactory(new DaemonThreadFactory(), RemoteInvocationHandler.class.getSimpleName()));
        private final AtomicBoolean inQueue = new AtomicBoolean(false);
        private final AtomicBoolean isAlive = new AtomicBoolean(false);
        private final ReferenceQueue<? super RemoteInvocationHandler> queue = new ReferenceQueue();
        private final ConcurrentMap<Channel.Ref, List<PhantomReferenceImpl>> referenceLists = new ConcurrentHashMap<Channel.Ref, List<PhantomReferenceImpl>>();

        private Unexporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.isAlive.compareAndSet(false, true)) {
                this.inQueue.set(false);
                return;
            }
            this.inQueue.set(false);
            try {
                long nextSweep = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(200L);
                while (!this.referenceLists.isEmpty()) {
                    block18: {
                        try {
                            Reference<? super RemoteInvocationHandler> ref = this.queue.remove(100L);
                            if (!(ref instanceof PhantomReferenceImpl)) break block18;
                            PhantomReferenceImpl r = (PhantomReferenceImpl)ref;
                            Channel.Ref channelRef = r.channel;
                            try {
                                r.cleanup();
                            }
                            catch (IOException e) {
                                logger.log(Level.WARNING, String.format("Couldn't clean up oid=%d from %s", r.oid, r.origin), e);
                            }
                            catch (Error e) {
                                logger.log(Level.SEVERE, String.format("Couldn't clean up oid=%d from %s", r.oid, r.origin), e);
                                throw e;
                            }
                            catch (Throwable e) {
                                logger.log(Level.WARNING, String.format("Couldn't clean up oid=%d from %s", r.oid, r.origin), e);
                            }
                            finally {
                                List referenceList;
                                if (channelRef != null && (referenceList = (List)this.referenceLists.get(channelRef)) != null) {
                                    referenceList.remove(r);
                                    if (channelRef.channel() == null) {
                                        this.cleanList(referenceList);
                                    }
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            logger.log(Level.FINE, "Interrupted", e);
                        }
                    }
                    if (System.nanoTime() <= nextSweep) continue;
                    nextSweep = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(200L);
                    Iterator iterator = this.referenceLists.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        Channel.Ref r = (Channel.Ref)entry.getKey();
                        if (r != null && r.channel() != null) continue;
                        iterator.remove();
                        this.cleanList((List)entry.getValue());
                    }
                }
            }
            finally {
                this.isAlive.set(false);
            }
        }

        private void cleanList(@CheckForNull List<PhantomReferenceImpl> referenceList) {
            if (referenceList == null) {
                return;
            }
            for (PhantomReferenceImpl phantom : referenceList) {
                phantom.clear();
            }
            referenceList.clear();
        }

        private void watch(RemoteInvocationHandler handler) {
            List referenceList;
            Channel.Ref ref = handler.channel;
            if (ref == null || ref.channel() == null) {
                return;
            }
            while (null == (referenceList = (List)this.referenceLists.get(ref))) {
                this.referenceLists.putIfAbsent(ref, Collections.synchronizedList(new ArrayList()));
            }
            referenceList.add(new PhantomReferenceImpl(handler, this.queue));
            if (this.isAlive.get()) {
                return;
            }
            if (this.inQueue.compareAndSet(false, true)) {
                try {
                    this.svc.submit(UNEXPORTER);
                }
                catch (RejectedExecutionException e) {
                    // empty catch block
                }
            }
        }

        private void onChannelTermination(Channel channel) {
            this.cleanList((List)this.referenceLists.remove(channel.ref()));
        }
    }

    private static class PhantomReferenceImpl
    extends PhantomReference<RemoteInvocationHandler> {
        private final int oid;
        private Throwable origin;
        private Channel.Ref channel;

        private PhantomReferenceImpl(RemoteInvocationHandler referent, ReferenceQueue<? super RemoteInvocationHandler> referenceQueue) {
            super(referent, referenceQueue);
            this.oid = referent.oid;
            this.origin = referent.origin;
            this.channel = referent.channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup() throws IOException {
            if (this.channel == null) {
                return;
            }
            Channel channel = this.channel.channel();
            if (channel != null && !channel.isClosingOrClosed()) {
                try {
                    channel.send(new UnexportCommand(this.oid, this.origin));
                }
                finally {
                    this.origin = null;
                    this.channel = null;
                }
            }
        }
    }
}

