/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.EngineListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import org.jenkinsci.remoting.engine.EngineUtil;
import org.jenkinsci.remoting.engine.JnlpProtocol;

class JnlpProtocol2
extends JnlpProtocol {
    private String cookie;
    static final String NAME = "JNLP2-connect";
    static final String SECRET_KEY = "Secret-Key";
    static final String SLAVE_NAME_KEY = "Node-Name";
    static final String COOKIE_KEY = "Cookie";

    JnlpProtocol2(String slaveName, String slaveSecret, EngineListener events) {
        super(slaveName, slaveSecret, events);
    }

    @Override
    public String getName() {
        return NAME;
    }

    String getCookie() {
        return this.cookie;
    }

    @Override
    boolean performHandshake(DataOutputStream outputStream, BufferedInputStream inputStream) throws IOException {
        this.initiateHandshake(outputStream);
        String response = EngineUtil.readLine(inputStream);
        if (!response.equals("Welcome")) {
            this.events.status("Server didn't accept the handshake: " + response);
            return false;
        }
        Properties responses = EngineUtil.readResponseHeaders(inputStream);
        this.cookie = responses.getProperty(COOKIE_KEY);
        return true;
    }

    @Override
    Channel buildChannel(Socket socket, ChannelBuilder channelBuilder, BufferedInputStream inputStream) throws IOException {
        return channelBuilder.build(inputStream, new BufferedOutputStream(socket.getOutputStream()));
    }

    private void initiateHandshake(DataOutputStream outputStream) throws IOException {
        Properties props = new Properties();
        props.put(SECRET_KEY, this.slaveSecret);
        props.put(SLAVE_NAME_KEY, this.slaveName);
        if (this.cookie != null) {
            props.put(COOKIE_KEY, this.cookie);
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        props.store(o, null);
        outputStream.writeUTF("Protocol:JNLP2-connect");
        outputStream.writeUTF(o.toString("UTF-8"));
    }
}

