/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting;

import hudson.remoting.Channel;
import java.io.IOException;
import java.lang.ref.WeakReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ChannelStateException
extends IOException {
    @Nonnull
    private final String channelName;
    @CheckForNull
    private final transient WeakReference<Channel> channelRef;

    public ChannelStateException(@CheckForNull Channel channel, @Nonnull String message) {
        super(message);
        this.channelRef = channel != null ? new WeakReference<Channel>(channel) : null;
        this.channelName = channel != null ? channel.getName() : "unknown";
    }

    public ChannelStateException(@CheckForNull Channel channel, String message, @CheckForNull Throwable cause) {
        super(message, cause);
        this.channelRef = channel != null ? new WeakReference<Channel>(channel) : null;
        this.channelName = channel != null ? channel.getName() : "unknown";
    }

    @CheckForNull
    public WeakReference<Channel> getChannelRef() {
        return this.channelRef;
    }

    @Nonnull
    public String getChannelName() {
        return this.channelName;
    }

    @CheckForNull
    public Channel getChannel() {
        return this.channelRef != null ? (Channel)this.channelRef.get() : null;
    }

    @Override
    public String getMessage() {
        Channel ch = this.getChannel();
        String infoForMessage = ch != null ? ch.toString() : this.channelName;
        return String.format("Channel \"%s\": %s", infoForMessage, super.getMessage());
    }
}

