/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.sshd;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.User;
import java.io.PrintStream;
import java.util.Locale;
import org.apache.sshd.server.Command;
import org.jenkinsci.main.modules.sshd.AsynchronousCommand;
import org.jenkinsci.main.modules.sshd.SshCommandFactory;

@Extension
public class CLICommandAdapter
extends SshCommandFactory {
    public Command create(SshCommandFactory.CommandLine commandLine) {
        String cmd = commandLine.get(0);
        final CLICommand c = CLICommand.clone((String)cmd);
        if (c == null) {
            return null;
        }
        return new AsynchronousCommand(commandLine){

            protected int run() throws Exception {
                User u = this.getCurrentUser();
                if (u != null) {
                    c.setTransportAuth(u.impersonate());
                }
                SshCommandFactory.CommandLine cmds = this.getCmdLine();
                return c.main(cmds.subList(1, cmds.size()), Locale.getDefault(), this.getInputStream(), new PrintStream(this.getOutputStream()), new PrintStream(this.getErrorStream()));
            }
        };
    }
}

