/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.sshd;

import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import java.io.IOException;
import java.security.KeyPair;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.util.ServerTcpPort;
import net.sf.json.JSONObject;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.cipher.AES128CBC;
import org.apache.sshd.common.cipher.BlowfishCBC;
import org.apache.sshd.common.cipher.TripleDESCBC;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.jenkinsci.main.modules.sshd.CommandFactoryImpl;
import org.jenkinsci.main.modules.sshd.PublicKeyAuthenticatorImpl;
import org.jenkinsci.main.modules.sshd.UserAuthNamedFactory;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class SSHD
extends GlobalConfiguration {
    private transient SshServer sshd;
    @Inject
    private transient InstanceIdentity identity;
    private volatile int port;
    private static final Logger LOGGER = Logger.getLogger(SSHD.class.getName());
    private static Logger MINA_LOGGER = Logger.getLogger("org.apache.sshd");

    public SSHD() {
        this.load();
    }

    public int getPort() {
        return this.port;
    }

    public int getActualPort() {
        if (this.port == -1) {
            return -1;
        }
        if (this.sshd != null) {
            return this.sshd.getPort();
        }
        return this.port;
    }

    public void setPort(int port) {
        if (this.port != port) {
            this.port = port;
            Jenkins.MasterComputer.threadPoolForRemoting.submit(new Runnable(){

                public void run() {
                    SSHD.this.restart();
                }
            });
            this.save();
        }
    }

    public synchronized void start() throws IOException, InterruptedException {
        if (this.port < 0) {
            return;
        }
        this.stop();
        this.sshd = SshServer.setUpDefaultServer();
        this.sshd.setUserAuthFactories(Arrays.asList(new UserAuthNamedFactory()));
        this.sshd.setCipherFactories(Arrays.asList(new AES128CBC.Factory(), new TripleDESCBC.Factory(), new BlowfishCBC.Factory()));
        this.sshd.setPort(this.port);
        this.sshd.setKeyPairProvider((KeyPairProvider)new AbstractKeyPairProvider(){

            protected KeyPair[] loadKeys() {
                return new KeyPair[]{new KeyPair(SSHD.this.identity.getPublic(), SSHD.this.identity.getPrivate())};
            }
        });
        this.sshd.setShellFactory(null);
        this.sshd.setCommandFactory((CommandFactory)new CommandFactoryImpl());
        this.sshd.setPublickeyAuthenticator((PublickeyAuthenticator)new PublicKeyAuthenticatorImpl());
        this.sshd.start();
        LOGGER.info("Started SSHD at port " + this.sshd.getPort());
    }

    public synchronized void restart() {
        try {
            if (this.sshd != null) {
                this.sshd.stop(false);
                this.sshd = null;
            }
            this.start();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to restart SSHD", e);
        }
    }

    public void stop() throws InterruptedException {
        if (this.sshd != null) {
            this.sshd.stop(true);
            this.sshd = null;
        }
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        this.setPort(new ServerTcpPort(json.getJSONObject("port")).getPort());
        return true;
    }

    public static SSHD get() {
        return (SSHD)((Object)Jenkins.getInstance().getExtensionList(GlobalConfiguration.class).get(SSHD.class));
    }

    @Initializer(after=InitMilestone.JOB_LOADED, fatal=false)
    public static void init() throws IOException, InterruptedException {
        SSHD.get().start();
    }

    static {
        if (MINA_LOGGER.getLevel() == null) {
            MINA_LOGGER.setLevel(Level.WARNING);
        }
    }
}

