/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.model.BuildableItem;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import hudson.util.XStream2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.client.Version;
import org.jfrog.build.extractor.clientConfiguration.client.ManagerBase;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.DistributionManager;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.JFrogPlatformInstance;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.jfpipelines.JFrogPipelinesHttpClient;
import org.jfrog.hudson.jfpipelines.JFrogPipelinesServer;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.ProxyUtils;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.converters.ArtifactoryBuilderConverter;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ArtifactoryBuilder
extends GlobalConfiguration {

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<GlobalConfiguration> {
        private boolean useCredentialsPlugin;
        private List<JFrogPlatformInstance> jfrogInstances;
        @Deprecated
        private List<ArtifactoryServer> artifactoryServers;
        private JFrogPipelinesServer jfrogPipelinesServer = new JFrogPipelinesServer();

        public DescriptorImpl() {
            super(ArtifactoryBuilder.class);
            this.load();
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins != null && jenkins.hasPermission(Jenkins.ADMINISTER)) {
                return PluginsUtils.fillPluginCredentials(project);
            }
            return new StandardListBoxModel();
        }

        public FormValidation doCheckInstanceId(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set server ID");
            }
            List<JFrogPlatformInstance> JFrogPlatformInstances = RepositoriesUtils.getJFrogPlatformInstances();
            if (JFrogPlatformInstances == null) {
                return FormValidation.ok();
            }
            int countServersByValueAsName = 0;
            for (JFrogPlatformInstance JFrogPlatformInstance2 : JFrogPlatformInstances) {
                if (!JFrogPlatformInstance2.getId().equals(value) || ++countServersByValueAsName <= 1) continue;
                return FormValidation.error((String)"Duplicated JFrog platform instances ID");
            }
            return FormValidation.ok();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequirePOST
        public FormValidation doTestConnection(@QueryParameter(value="platformUrl") String url, @QueryParameter(value="artifactoryUrl") String artifactoryUrl, @QueryParameter(value="distributionUrl") String distributionUrl, @QueryParameter(value="instance.timeout") String timeout, @QueryParameter(value="instance.bypassProxy") boolean bypassProxy, @QueryParameter(value="useCredentialsPlugin") boolean useCredentialsPlugin, @QueryParameter(value="credentialsId") String deployerCredentialsId, @QueryParameter(value="username") String deployerCredentialsUsername, @QueryParameter(value="password") String deployerCredentialsPassword, @QueryParameter(value="connectionRetry") int connectionRetry) {
            DistributionManager distributionManager;
            ArtifactoryManager artifactoryManager;
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.error((String)"Testing the connection requires 'Administer' permission");
            }
            if (StringUtils.isBlank((CharSequence)artifactoryUrl) && StringUtils.isBlank((CharSequence)url)) {
                return FormValidation.error((String)"Please set a valid Artifactory or platform URL");
            }
            if (connectionRetry < 0) {
                return FormValidation.error((String)"Connection Retries can not be less then 0");
            }
            if (StringUtils.isEmpty((CharSequence)deployerCredentialsId) && (StringUtils.isEmpty((CharSequence)deployerCredentialsUsername) || StringUtils.isEmpty((CharSequence)deployerCredentialsPassword))) {
                return FormValidation.error((String)"Please set a valid credentials");
            }
            String targetArtUrl = StringUtils.isBlank((CharSequence)artifactoryUrl) ? StringUtils.removeEnd((String)url, (String)"/") + "/artifactory" : artifactoryUrl;
            String targetDisUrl = StringUtils.isBlank((CharSequence)distributionUrl) && StringUtils.isNotBlank((CharSequence)url) ? StringUtils.removeEnd((String)url, (String)"/") + "/distribution" : distributionUrl;
            String accessToken = "";
            String username = "";
            String password = "";
            StringCredentials accessTokenCredentials = PluginsUtils.accessTokenCredentialsLookup(deployerCredentialsId, null);
            if (accessTokenCredentials != null) {
                accessToken = accessTokenCredentials.getSecret().getPlainText();
            } else if (useCredentialsPlugin) {
                Credentials credentials = PluginsUtils.usernamePasswordCredentialsLookup(deployerCredentialsId, null);
                username = credentials.getUsername();
                password = credentials.getPassword();
            } else {
                username = deployerCredentialsUsername;
                password = Secret.fromString((String)deployerCredentialsPassword).getPlainText();
            }
            if (StringUtils.isNotEmpty((CharSequence)username) || StringUtils.isNotEmpty((CharSequence)accessToken)) {
                artifactoryManager = new ArtifactoryManager(targetArtUrl, username, password, accessToken, (Log)new NullLog());
                distributionManager = new DistributionManager(targetDisUrl, username, password, accessToken, (Log)new NullLog());
            } else {
                artifactoryManager = new ArtifactoryManager(targetArtUrl, (Log)new NullLog());
                distributionManager = new DistributionManager(targetDisUrl, (Log)new NullLog());
            }
            try {
                Stream.of(artifactoryManager, distributionManager).forEach(manager -> {
                    if (!bypassProxy && Jenkins.get().proxy != null) {
                        manager.setProxyConfiguration(ProxyUtils.createProxyConfiguration());
                    }
                    if (StringUtils.isNotBlank((CharSequence)timeout)) {
                        manager.setConnectionTimeout(Integer.parseInt(timeout));
                    }
                });
                String outputMessage = this.createTestConnectionMessage((ManagerBase)artifactoryManager, targetArtUrl, "JFrog Artifactory");
                if (StringUtils.isNotEmpty((CharSequence)targetDisUrl)) {
                    outputMessage = outputMessage + String.format("%n%s", this.createTestConnectionMessage((ManagerBase)distributionManager, targetDisUrl, "JFrog Distribution"));
                }
                FormValidation formValidation = FormValidation.ok((String)outputMessage);
                return formValidation;
            }
            finally {
                artifactoryManager.close();
                distributionManager.close();
            }
        }

        private String createTestConnectionMessage(ManagerBase manager, String targetUrl, String serverName) {
            try {
                Version version = manager.getVersion();
                if (version.isNotFound()) {
                    return String.format("%s not found at %s", serverName, targetUrl);
                }
                return String.format("Found %s %s at %s", serverName, manager.getVersion().toString(), targetUrl);
            }
            catch (ClientProtocolException e) {
                return String.format("An error occurred while connecting to %s:%s%s", serverName, System.lineSeparator(), e.getCause().getMessage());
            }
            catch (Exception e) {
                return String.format("An error occurred while connecting to %s:%s%s", serverName, System.lineSeparator(), e.getMessage());
            }
        }

        /*
         * Loose catch block
         */
        @RequirePOST
        public FormValidation doTestJFrogPipelinesConnection(@QueryParameter(value="pipelinesIntegrationUrl") String url, @QueryParameter(value="pipelinesTimeout") String timeout, @QueryParameter(value="pipelinesBypassProxy") boolean bypassProxy, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="pipelinesConnectionRetries") int connectionRetry) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.error((String)"Testing the connection requires 'Administer' permission");
            }
            if (StringUtils.isBlank((CharSequence)url)) {
                return FormValidation.error((String)"Please set a valid JFrog Pipelines integration URL");
            }
            if (connectionRetry < 0) {
                return FormValidation.error((String)"Connection Retries can not be less then 0");
            }
            StringCredentials accessTokenCredentials = PluginsUtils.accessTokenCredentialsLookup(credentialsId, null);
            if (accessTokenCredentials == null) {
                return FormValidation.error((String)"Please set credentials with access token as 'Secret text'");
            }
            String accessToken = accessTokenCredentials.getSecret().getPlainText();
            Throwable throwable = null;
            try (JFrogPipelinesHttpClient client = new JFrogPipelinesHttpClient(url, accessToken, (Log)new NullLog());){
                Version version;
                ProxyConfiguration proxyConfiguration;
                if (!bypassProxy && (proxyConfiguration = ProxyUtils.createProxyConfiguration()) != null) {
                    client.setProxyConfiguration(proxyConfiguration);
                }
                if (StringUtils.isNotBlank((CharSequence)timeout)) {
                    client.setConnectionTimeout(Integer.parseInt(timeout));
                }
                client.setConnectionRetries(connectionRetry);
                try {
                    version = client.verifyCompatibleVersion();
                }
                catch (UnsupportedOperationException uoe) {
                    FormValidation formValidation = FormValidation.warning((String)uoe.getMessage());
                    if (client != null) {
                        if (throwable != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            client.close();
                        }
                    }
                    return formValidation;
                }
                catch (Exception e) {
                    FormValidation formValidation;
                    block30: {
                        block31: {
                            formValidation = FormValidation.error((String)e.getMessage());
                            if (client == null) break block30;
                            if (throwable == null) break block31;
                            try {
                                client.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            break block30;
                        }
                        client.close();
                    }
                    return formValidation;
                }
                FormValidation formValidation = FormValidation.ok((String)("Found JFrog Pipelines " + version.toString()));
                return formValidation;
                {
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throw throwable5;
                    }
                }
            }
        }

        public String getDisplayName() {
            return "Artifactory Plugin";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins != null && jenkins.hasPermission(Jenkins.ADMINISTER)) {
                boolean useCredentialsPlugin = BooleanUtils.isTrue((Boolean)((Boolean)o.get("useCredentialsPlugin")));
                this.configureJFrogInstances(req, o);
                this.configureJFrogPipelinesServer(o);
                if (useCredentialsPlugin && !this.useCredentialsPlugin) {
                    this.resetJobsCredentials();
                    this.resetServersCredentials();
                }
                this.useCredentialsPlugin = useCredentialsPlugin;
                this.save();
                return super.configure(req, o);
            }
            throw new Descriptor.FormException("User doesn't have permissions to save", "Server ID");
        }

        private void configureJFrogInstances(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            List<JFrogPlatformInstance> jfrogInstances = new ArrayList<JFrogPlatformInstance>();
            Object jfrogInstancesObj = o.get("jfrogInstances");
            if (!JSONNull.getInstance().equals(jfrogInstancesObj)) {
                jfrogInstances = req.bindJSONToList(JFrogPlatformInstance.class, jfrogInstancesObj);
            }
            if (!this.isJFrogInstancesIDConfigured(jfrogInstances)) {
                throw new Descriptor.FormException("Please set the Instance ID.", "InstanceID");
            }
            if (this.isInstanceDuplicated(jfrogInstances)) {
                throw new Descriptor.FormException("The JFrog instance ID you have entered is already configured", "Instance ID");
            }
            if (this.isEmptyUrls(jfrogInstances)) {
                throw new Descriptor.FormException("Please set the The JFrog Platform or Artifactory URL", "URL");
            }
            this.autoFillPlatformServers(jfrogInstances);
            this.setJfrogInstances(jfrogInstances);
        }

        private void configureJFrogPipelinesServer(JSONObject o) {
            JSONObject credentialsConfigJson = (JSONObject)o.get("credentialsConfig");
            if (credentialsConfigJson == null) {
                return;
            }
            String credentialsId = credentialsConfigJson.optString("credentialsId");
            CredentialsConfig credentialsConfig = new CredentialsConfig("", "", credentialsId);
            credentialsConfig.setIgnoreCredentialPluginDisabled(true);
            JFrogPipelinesServer jfrogPipelinesServer = new JFrogPipelinesServer(o.getString("pipelinesIntegrationUrl"), credentialsConfig, o.optInt("pipelinesTimeout"), o.getBoolean("pipelinesBypassProxy"), o.optInt("pipelinesConnectionRetries"));
            this.setJfrogPipelinesServer(jfrogPipelinesServer);
        }

        private void resetServersCredentials() {
            for (JFrogPlatformInstance server : this.jfrogInstances) {
                if (server.getResolverCredentialsConfig() != null) {
                    server.getResolverCredentialsConfig().deleteCredentials();
                }
                if (server.getDeployerCredentialsConfig() == null) continue;
                server.getDeployerCredentialsConfig().deleteCredentials();
            }
        }

        private void resetJobsCredentials() {
            List jobs = Jenkins.get().getAllItems(BuildableItemWithBuildWrappers.class);
            for (BuildableItem job : jobs) {
                DeployerOverrider deployer;
                ResolverOverrider resolver = ActionableHelper.getResolverOverrider(job);
                if (resolver != null && resolver.getResolverCredentialsConfig() != null) {
                    resolver.getResolverCredentialsConfig().deleteCredentials();
                }
                if ((deployer = ActionableHelper.getDeployerOverrider(job)) != null && deployer.getDeployerCredentialsConfig() != null) {
                    deployer.getDeployerCredentialsConfig().deleteCredentials();
                }
                if (resolver == null && deployer == null) continue;
                try {
                    job.save();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public JFrogPipelinesServer getJfrogPipelinesServer() {
            return this.jfrogPipelinesServer;
        }

        public boolean getUseCredentialsPlugin() {
            return this.useCredentialsPlugin;
        }

        public void setJfrogPipelinesServer(JFrogPipelinesServer jfrogPipelinesServer) {
            this.jfrogPipelinesServer = jfrogPipelinesServer;
        }

        public void setUseCredentialsPlugin(boolean useCredentialsPlugin) {
            this.useCredentialsPlugin = useCredentialsPlugin;
        }

        private boolean isEmptyUrls(List<JFrogPlatformInstance> jfrogInstances) {
            if (jfrogInstances == null) {
                return false;
            }
            for (JFrogPlatformInstance instance : jfrogInstances) {
                if (!StringUtils.isBlank((CharSequence)instance.getUrl()) || !StringUtils.isBlank((CharSequence)instance.getArtifactory().getArtifactoryUrl())) continue;
                return true;
            }
            return false;
        }

        public void autoFillPlatformServers(List<JFrogPlatformInstance> newJFrogInstances) {
            if (newJFrogInstances == null) {
                return;
            }
            for (JFrogPlatformInstance newInstance : newJFrogInstances) {
                Optional<JFrogPlatformInstance> preSavedInstance;
                if (StringUtils.isBlank((CharSequence)newInstance.getUrl())) continue;
                if (StringUtils.isBlank((CharSequence)newInstance.getArtifactoryUrl())) {
                    this.setDefaultArtifactoryUrl(newInstance);
                }
                if (StringUtils.isBlank((CharSequence)newInstance.getDistributionUrl())) {
                    this.setDefaultDistributionUrl(newInstance);
                }
                if (!(preSavedInstance = this.getPreSavedInstance(newInstance.getId())).isPresent() || !this.isPlatformUrlChangedSinceLastSave(preSavedInstance.get(), newInstance)) continue;
                if (!StringUtils.startsWithIgnoreCase((CharSequence)newInstance.getArtifactoryUrl(), (CharSequence)newInstance.getUrl()) && !this.isArtifactoryUrlChangedSinceLastSave(preSavedInstance.get(), newInstance)) {
                    this.setDefaultArtifactoryUrl(newInstance);
                }
                if (StringUtils.startsWithIgnoreCase((CharSequence)newInstance.getDistributionUrl(), (CharSequence)newInstance.getUrl()) || this.isDistributionUrlChangedSinceLastSave(preSavedInstance.get(), newInstance)) continue;
                this.setDefaultDistributionUrl(newInstance);
            }
        }

        private void setDefaultArtifactoryUrl(JFrogPlatformInstance newInstance) {
            newInstance.getArtifactory().setArtifactoryUrl(newInstance.getUrl() + "/artifactory");
        }

        private void setDefaultDistributionUrl(JFrogPlatformInstance newInstance) {
            newInstance.setDistributionUrl(newInstance.getUrl() + "/distribution");
        }

        private Optional<JFrogPlatformInstance> getPreSavedInstance(String id) {
            if (this.jfrogInstances == null) {
                return Optional.empty();
            }
            return this.jfrogInstances.stream().filter(inst -> inst.getId().equals(id)).findFirst();
        }

        private boolean isArtifactoryUrlChangedSinceLastSave(JFrogPlatformInstance oldInstance, JFrogPlatformInstance newInstance) {
            return !oldInstance.getArtifactory().getArtifactoryUrl().equals(newInstance.getArtifactory().getArtifactoryUrl());
        }

        private boolean isPlatformUrlChangedSinceLastSave(JFrogPlatformInstance oldInstance, JFrogPlatformInstance newInstance) {
            String oldUrl = oldInstance.getUrl();
            if (StringUtils.isEmpty((CharSequence)oldUrl)) {
                return StringUtils.isNotEmpty((CharSequence)newInstance.getUrl());
            }
            return !oldInstance.getUrl().equals(newInstance.getUrl());
        }

        private boolean isDistributionUrlChangedSinceLastSave(JFrogPlatformInstance oldInstance, JFrogPlatformInstance newInstance) {
            return !oldInstance.getDistributionUrl().equals(newInstance.getDistributionUrl());
        }

        private boolean isInstanceDuplicated(List<JFrogPlatformInstance> jfrogInstances) {
            HashSet<String> serversNames = new HashSet<String>();
            if (jfrogInstances == null) {
                return false;
            }
            for (JFrogPlatformInstance instance : jfrogInstances) {
                String id = instance.getId();
                if (serversNames.contains(id)) {
                    return true;
                }
                serversNames.add(id);
            }
            return false;
        }

        private boolean isJFrogInstancesIDConfigured(List<JFrogPlatformInstance> jfrogInstances) {
            if (jfrogInstances == null) {
                return true;
            }
            for (JFrogPlatformInstance server : jfrogInstances) {
                String platformId = server.getId();
                String artifactoryId = server.getArtifactory().getServerId();
                if (!StringUtils.isBlank((CharSequence)platformId) && !StringUtils.isBlank((CharSequence)artifactoryId)) continue;
                return false;
            }
            return true;
        }

        public List<JFrogPlatformInstance> getJfrogInstances() {
            return this.jfrogInstances;
        }

        public void setJfrogInstances(List<JFrogPlatformInstance> jfrogInstances) {
            this.jfrogInstances = jfrogInstances;
        }

        public static final class ConverterImpl
        extends ArtifactoryBuilderConverter {
            public ConverterImpl(XStream2 xstream) {
                super(xstream);
            }
        }
    }
}

