/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.reporters.MavenAbstractArtifactRecord;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.BuildInfoResultAction;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.JFrogPlatformInstance;
import org.jfrog.hudson.PluginSettings;
import org.jfrog.hudson.Repository;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.UserPluginInfo;
import org.jfrog.hudson.UserPluginInfoParam;
import org.jfrog.hudson.action.ArtifactoryProjectAction;
import org.jfrog.hudson.maven2.ArtifactsDeployer;
import org.jfrog.hudson.maven2.MavenBuildInfoDeployer;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.ProxyUtils;
import org.jfrog.hudson.util.RefreshServerResponse;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.converters.DeployerResolverOverriderConverter;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ArtifactoryRedeployPublisher
extends Recorder
implements DeployerOverrider,
BuildInfoAwareConfigurator {
    public boolean evenIfUnstable;
    private final ServerDetails deployerDetails;
    private boolean deployArtifacts;
    private IncludesExcludes artifactDeploymentPatterns;
    private CredentialsConfig deployerCredentialsConfig;
    private boolean includeEnvVars;
    private IncludesExcludes envVarsPatterns;
    private boolean passIdentifiedDownstream;
    private boolean discardOldBuilds;
    private boolean discardBuildArtifacts;
    private boolean asyncBuildRetention;
    private String deploymentProperties;
    private boolean enableIssueTrackerIntegration;
    private boolean allowPromotionOfNonStagedBuilds;
    private boolean filterExcludedArtifactsFromBuild;
    private boolean recordAllDependencies;
    private String defaultPromotionTargetRepository;
    private boolean deployBuildInfo;
    private String aggregationBuildStatus;
    private boolean aggregateBuildIssues;
    private String customBuildName;
    private boolean overrideBuildName;
    private String project;
    @Deprecated
    private Credentials overridingDeployerCredentials;
    @Deprecated
    private ServerDetails details = null;
    @Deprecated
    private final String matrixParams;

    @DataBoundConstructor
    public ArtifactoryRedeployPublisher(ServerDetails details, ServerDetails deployerDetails, boolean deployArtifacts, IncludesExcludes artifactDeploymentPatterns, CredentialsConfig deployerCredentialsConfig, boolean includeEnvVars, IncludesExcludes envVarsPatterns, boolean deployBuildInfo, boolean evenIfUnstable, boolean discardOldBuilds, boolean passIdentifiedDownstream, boolean discardBuildArtifacts, boolean asyncBuildRetention, String matrixParams, String deploymentProperties, boolean enableIssueTrackerIntegration, boolean aggregateBuildIssues, String aggregationBuildStatus, boolean recordAllDependencies, boolean allowPromotionOfNonStagedBuilds, String defaultPromotionTargetRepository, boolean filterExcludedArtifactsFromBuild, String customBuildName, boolean overrideBuildName, String project) {
        this.matrixParams = null;
        this.deployerDetails = deployerDetails;
        this.deployArtifacts = deployArtifacts;
        this.artifactDeploymentPatterns = artifactDeploymentPatterns;
        this.deployerCredentialsConfig = deployerCredentialsConfig;
        this.includeEnvVars = includeEnvVars;
        this.envVarsPatterns = envVarsPatterns;
        this.evenIfUnstable = evenIfUnstable;
        this.discardOldBuilds = discardOldBuilds;
        this.passIdentifiedDownstream = passIdentifiedDownstream;
        this.discardBuildArtifacts = discardBuildArtifacts;
        this.asyncBuildRetention = asyncBuildRetention;
        this.deploymentProperties = deploymentProperties;
        this.aggregationBuildStatus = aggregationBuildStatus;
        this.filterExcludedArtifactsFromBuild = filterExcludedArtifactsFromBuild;
        this.deployBuildInfo = deployBuildInfo;
        this.enableIssueTrackerIntegration = enableIssueTrackerIntegration;
        this.aggregateBuildIssues = aggregateBuildIssues;
        this.recordAllDependencies = recordAllDependencies;
        this.allowPromotionOfNonStagedBuilds = allowPromotionOfNonStagedBuilds;
        this.defaultPromotionTargetRepository = defaultPromotionTargetRepository;
        this.customBuildName = customBuildName;
        this.overrideBuildName = overrideBuildName;
        this.project = project;
    }

    public ArtifactoryRedeployPublisher(ServerDetails details, ServerDetails deployerDetails) {
        this.matrixParams = null;
        this.details = details;
        this.deployerDetails = deployerDetails;
    }

    public boolean isDeployArtifacts() {
        return this.deployArtifacts;
    }

    public String getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public ServerDetails getDeployerDetails() {
        return this.deployerDetails;
    }

    public IncludesExcludes getArtifactDeploymentPatterns() {
        return this.artifactDeploymentPatterns;
    }

    @Override
    public boolean isDiscardOldBuilds() {
        return this.discardOldBuilds;
    }

    @Override
    public boolean isDiscardBuildArtifacts() {
        return this.discardBuildArtifacts;
    }

    @Override
    public boolean isAsyncBuildRetention() {
        return this.asyncBuildRetention;
    }

    public boolean isPassIdentifiedDownstream() {
        return this.passIdentifiedDownstream;
    }

    @Override
    public CredentialsConfig getDeployerCredentialsConfig() {
        return this.deployerCredentialsConfig;
    }

    @Override
    public boolean isOverridingDefaultDeployer() {
        return this.deployerCredentialsConfig != null && this.deployerCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public Credentials getOverridingDeployerCredentials() {
        return this.overridingDeployerCredentials;
    }

    public boolean isDeployBuildInfo() {
        return this.deployBuildInfo;
    }

    public boolean isEvenIfUnstable() {
        return this.evenIfUnstable;
    }

    @Override
    public boolean isIncludeEnvVars() {
        return this.includeEnvVars;
    }

    @Override
    public IncludesExcludes getEnvVarsPatterns() {
        return this.envVarsPatterns;
    }

    public String getArtifactoryName() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().artifactoryName : null;
    }

    public String getArtifactoryUrl() {
        ArtifactoryServer server = this.getArtifactoryServer();
        return server != null ? server.getArtifactoryUrl() : null;
    }

    @Override
    public String getRepositoryKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getDeployReleaseRepositoryKey() : null;
    }

    public String getSnapshotsRepositoryKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getDeploySnapshotRepositoryKey() : null;
    }

    public String getUserPluginKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getUserPluginKey() : null;
    }

    @Override
    public boolean isEnableIssueTrackerIntegration() {
        return this.enableIssueTrackerIntegration;
    }

    @Override
    public boolean isAggregateBuildIssues() {
        return this.aggregateBuildIssues;
    }

    @Override
    public String getAggregationBuildStatus() {
        return this.aggregationBuildStatus;
    }

    public boolean isAllowPromotionOfNonStagedBuilds() {
        return this.allowPromotionOfNonStagedBuilds;
    }

    @Override
    public String getDefaultPromotionTargetRepository() {
        return this.defaultPromotionTargetRepository;
    }

    public void setDefaultPromotionTargetRepository(String defaultPromotionTargetRepository) {
        this.defaultPromotionTargetRepository = defaultPromotionTargetRepository;
    }

    public boolean isRecordAllDependencies() {
        return this.recordAllDependencies;
    }

    public boolean isFilterExcludedArtifactsFromBuild() {
        return this.filterExcludedArtifactsFromBuild;
    }

    public boolean isApplicable(AbstractBuild build) {
        return !this.isBuildFromM2ReleasePlugin(build);
    }

    @Override
    public String getCustomBuildName() {
        return this.customBuildName;
    }

    @Override
    public boolean isOverrideBuildName() {
        return this.overrideBuildName;
    }

    public String getProject() {
        return this.project;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        if (this.getDeployerDetails() != null) {
            if (this.isOverrideBuildName()) {
                return new ArtifactoryProjectAction(this.getDeployerDetails().getArtifactoryName(), this.getCustomBuildName());
            }
            return new ArtifactoryProjectAction(this.getDeployerDetails().getArtifactoryName(), project);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().isWorseThan(this.getThreshold())) {
            return true;
        }
        if (this.isBuildFromM2ReleasePlugin(build)) {
            listener.getLogger().append("M2 Release build, not uploading artifacts to Artifactory. ");
            return true;
        }
        String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(this, (Run)build);
        if (this.isExtractorUsed(build.getEnvironment((TaskListener)listener))) {
            if (!this.deployBuildInfo) return true;
            this.addJobActions(build, buildName);
            return true;
        }
        if (!(build instanceof MavenModuleSetBuild)) {
            listener.getLogger().format("Non maven build type: %s", build.getClass()).println();
            build.setResult(Result.FAILURE);
            return true;
        }
        MavenModuleSetBuild mavenBuild = (MavenModuleSetBuild)build;
        if (this.getArtifactoryServer() == null) {
            listener.getLogger().format("No Artifactory server configured for %s. Please check your configuration.", this.getArtifactoryName()).println();
            build.setResult(Result.FAILURE);
            return true;
        }
        List<MavenAbstractArtifactRecord> mars = this.getArtifactRecordActions(mavenBuild);
        if (mars.isEmpty()) {
            listener.getLogger().println("No artifacts are recorded. Is this a Maven project?");
            build.setResult(Result.FAILURE);
            return true;
        }
        ArtifactoryServer server = this.getArtifactoryServer();
        CredentialsConfig preferredDeployer = CredentialManager.getPreferredDeployer(this, server);
        try (ArtifactoryManager artifactoryManager = server.createArtifactoryManager(preferredDeployer.provideCredentials((Item)((MavenModuleSetBuild)build).getProject()), ProxyUtils.createProxyConfiguration());){
            server.setLog((TaskListener)listener, artifactoryManager);
            if (this.deployArtifacts) {
                new ArtifactsDeployer(this, artifactoryManager, mavenBuild, listener).deploy();
            }
            if (this.deployBuildInfo) {
                new MavenBuildInfoDeployer((BuildInfoAwareConfigurator)this, artifactoryManager, mavenBuild, (TaskListener)listener).deploy();
                this.addJobActions(build, buildName);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            listener.getLogger().println(e);
            build.setResult(Result.FAILURE);
            return true;
        }
    }

    private void addJobActions(AbstractBuild build, String buildName) {
        build.addAction((Action)new BuildInfoResultAction(this.getArtifactoryUrl(), (Run)build, buildName, this.project));
        if (this.isAllowPromotionOfNonStagedBuilds()) {
            build.addAction((Action)new UnifiedPromoteBuildAction((Run<?, ?>)build, this, this.project));
        }
    }

    private boolean isBuildFromM2ReleasePlugin(AbstractBuild<?, ?> build) {
        List causes = build.getCauses();
        return !causes.isEmpty() && causes.stream().anyMatch(input -> "org.jvnet.hudson.plugins.m2release.ReleaseCause".equals(input.getClass().getName()));
    }

    private boolean isM2Build(AbstractBuild<?, ?> build) {
        return build.getClass().getName().contains("MavenModuleSetBuild") && ((MavenModuleSetBuild)build).getMavenVersionUsed().startsWith("2");
    }

    private boolean isExtractorUsed(EnvVars env) {
        return Boolean.parseBoolean((String)env.get((Object)"extractor.used"));
    }

    protected List<MavenAbstractArtifactRecord> getArtifactRecordActions(MavenModuleSetBuild build) {
        ArrayList<MavenAbstractArtifactRecord> actions = new ArrayList<MavenAbstractArtifactRecord>();
        for (MavenBuild moduleBuild : build.getModuleLastBuilds().values()) {
            MavenAbstractArtifactRecord action = (MavenAbstractArtifactRecord)moduleBuild.getAction(MavenAbstractArtifactRecord.class);
            if (action == null) continue;
            actions.add(action);
        }
        return actions;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Override
    public ArtifactoryServer getArtifactoryServer() {
        return RepositoriesUtils.getArtifactoryServer(this.getArtifactoryName());
    }

    @Nonnull
    private Result getThreshold() {
        if (this.evenIfUnstable) {
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }

    public List<Repository> getReleaseRepositoryList() {
        return RepositoriesUtils.collectRepositories(this.getDeployerDetails().getDeployReleaseRepositoryKey());
    }

    public List<Repository> getSnapshotRepositoryList() {
        return RepositoriesUtils.collectRepositories(this.getDeployerDetails().getDeploySnapshotRepositoryKey());
    }

    public PluginSettings getSelectedStagingPlugin() throws Exception {
        return this.getDeployerDetails().getStagingPlugin();
    }

    public static final class ConverterImpl
    extends DeployerResolverOverriderConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private Item item;

        public DescriptorImpl() {
            super(ArtifactoryRedeployPublisher.class);
            this.load();
        }

        private List<Repository> refreshRepositories(ArtifactoryServer artifactoryServer, CredentialsConfig credentialsConfig) throws IOException {
            List<Repository> repositoriesKeys = RepositoriesUtils.getDeploymentRepositories(artifactoryServer.getArtifactoryUrl(), credentialsConfig, artifactoryServer, this.item);
            Collections.sort(repositoriesKeys);
            return repositoriesKeys;
        }

        private List<PluginSettings> refreshUserPlugins(ArtifactoryServer artifactoryServer, final CredentialsConfig credentialsConfig) {
            List<UserPluginInfo> pluginInfoList = artifactoryServer.getStagingUserPluginInfo(new DeployerOverrider(){

                @Override
                public boolean isOverridingDefaultDeployer() {
                    return credentialsConfig != null && credentialsConfig.isCredentialsProvided();
                }

                @Override
                public Credentials getOverridingDeployerCredentials() {
                    return credentialsConfig.provideCredentials(item);
                }

                @Override
                public CredentialsConfig getDeployerCredentialsConfig() {
                    return credentialsConfig;
                }
            }, this.item);
            ArrayList<PluginSettings> list = new ArrayList<PluginSettings>(pluginInfoList.size());
            for (UserPluginInfo p : pluginInfoList) {
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                List<UserPluginInfoParam> params = p.getPluginParams();
                for (UserPluginInfoParam param : params) {
                    paramsMap.put((String)param.getKey(), (String)param.getDefaultValue());
                }
                PluginSettings plugin = new PluginSettings(p.getPluginName(), paramsMap);
                list.add(plugin);
            }
            return list;
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            this.item = project;
            return PluginsUtils.fillPluginProjectCredentials(project);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return jobType == MavenModuleSet.class;
        }

        @JavaScriptMethod
        public RefreshServerResponse refreshFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
            RefreshServerResponse response = new RefreshServerResponse();
            CredentialsConfig credentialsConfig = new CredentialsConfig(username, password, credentialsId, overrideCredentials);
            try {
                ArtifactoryServer artifactoryServer = RepositoriesUtils.getArtifactoryServer(url);
                List<Repository> releaseRepositories = this.refreshRepositories(artifactoryServer, credentialsConfig);
                List<PluginSettings> userPluginKeys = this.refreshUserPlugins(artifactoryServer, credentialsConfig);
                response.setRepositories(releaseRepositories);
                response.setUserPlugins(userPluginKeys);
                response.setSuccess(true);
            }
            catch (Exception e) {
                response.setResponseMessage(e.getMessage());
                response.setSuccess(false);
            }
            return response;
        }

        public ArtifactoryRedeployPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (ArtifactoryRedeployPublisher)req.bindJSON(ArtifactoryRedeployPublisher.class, formData);
        }

        public String getDisplayName() {
            return "Deploy artifacts to Artifactory";
        }

        public List<JFrogPlatformInstance> getJfrogInstances() {
            return RepositoriesUtils.getJFrogPlatformInstances();
        }

        public boolean isJiraPluginEnabled() {
            return Jenkins.get().getPlugin("jira") != null;
        }

        public boolean isUseCredentialsPlugin() {
            return PluginsUtils.isUseCredentialsPlugin();
        }
    }
}

