/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.util.XStream2;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.usageReport.UsageReporter;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.PluginSettings;
import org.jfrog.hudson.Repository;
import org.jfrog.hudson.ResolutionRepository;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.UserPluginInfo;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.ProxyUtils;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.converters.ArtifactoryServerConverter;

public class ArtifactoryServer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ArtifactoryServer.class.getName());
    private String url;
    private String id;
    private int timeout = 300;
    private boolean bypassProxy;
    private Integer connectionRetry;
    private Integer deploymentThreads;
    private volatile transient List<String> repositories;
    private volatile transient List<ResolutionRepository> resolutionRepositories;
    @Deprecated
    private Credentials deployerCredentials;
    @Deprecated
    private Credentials resolverCredentials;
    private CredentialsConfig deployerCredentialsConfig;
    private CredentialsConfig resolverCredentialsConfig;

    public ArtifactoryServer(String serverId, String artifactoryUrl, CredentialsConfig deployerCredentialsConfig, CredentialsConfig resolverCredentialsConfig, int timeout, boolean bypassProxy, Integer connectionRetry, Integer deploymentThreads) {
        this.url = StringUtils.removeEnd((String)artifactoryUrl, (String)"/");
        this.id = serverId;
        this.deployerCredentialsConfig = deployerCredentialsConfig;
        this.resolverCredentialsConfig = resolverCredentialsConfig;
        this.timeout = timeout > 0 ? timeout : 300;
        this.bypassProxy = bypassProxy;
        this.connectionRetry = connectionRetry != null ? connectionRetry : 3;
        this.deploymentThreads = deploymentThreads != null && deploymentThreads > 0 ? deploymentThreads : 3;
    }

    public String getServerId() {
        return this.id;
    }

    public void setServerId(String id) {
        this.id = id;
    }

    public void setArtifactoryUrl(String url) {
        this.url = url;
    }

    public String getArtifactoryUrl() {
        return this.url != null ? this.url : this.getServerId();
    }

    public CredentialsConfig getDeployerCredentialsConfig() {
        return this.deployerCredentialsConfig;
    }

    public CredentialsConfig getResolverCredentialsConfig() {
        return this.resolverCredentialsConfig;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isBypassProxy() {
        return this.bypassProxy;
    }

    public int getConnectionRetry() {
        if (this.connectionRetry == null) {
            this.connectionRetry = 3;
        }
        return this.connectionRetry;
    }

    public void setConnectionRetry(int connectionRetry) {
        this.connectionRetry = connectionRetry;
    }

    public int getDeploymentThreads() {
        return this.deploymentThreads == null ? 3 : this.deploymentThreads;
    }

    public List<String> getLocalRepositoryKeys(CredentialsConfig credentialsConfig, Item item) throws IOException {
        try {
            List<Repository> deploymentRepos = RepositoriesUtils.getDeploymentRepositories(this.url, credentialsConfig, this, item);
            this.repositories = deploymentRepos.stream().map(Repository::getValue).collect(Collectors.toList());
        }
        catch (IOException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.WARNING, "Could not obtain local repositories list from '" + this.url + "'", e);
            } else {
                log.log(Level.WARNING, "Could not obtain local repositories list from '" + this.url + "': " + e.getMessage());
            }
            throw e;
        }
        return this.repositories;
    }

    public List<String> getReleaseRepositoryKeysFirst(DeployerOverrider deployerOverrider, Item item) throws IOException {
        CredentialsConfig credentialsConfig = CredentialManager.getPreferredDeployer(deployerOverrider, this);
        List<String> repositoryKeys = this.getLocalRepositoryKeys(credentialsConfig, item);
        if (repositoryKeys == null || repositoryKeys.isEmpty()) {
            return new ArrayList<String>();
        }
        repositoryKeys.sort(new RepositoryComparator());
        return repositoryKeys;
    }

    public List<String> getSnapshotRepositoryKeysFirst(DeployerOverrider deployerOverrider, Item item) throws IOException {
        CredentialsConfig credentialsConfig = CredentialManager.getPreferredDeployer(deployerOverrider, this);
        List<String> repositoryKeys = this.getLocalRepositoryKeys(credentialsConfig, item);
        if (repositoryKeys == null || repositoryKeys.isEmpty()) {
            return new ArrayList<String>();
        }
        repositoryKeys.sort(Collections.reverseOrder(new RepositoryComparator()));
        return repositoryKeys;
    }

    public Map getStagingStrategy(PluginSettings selectedStagingPlugin, String buildName, Item item) throws IOException {
        CredentialsConfig resolvingCredentialsConfig = this.getResolvingCredentialsConfig();
        try (ArtifactoryManager artifactoryManager = this.createArtifactoryManager(resolvingCredentialsConfig.provideCredentials(item), ProxyUtils.createProxyConfiguration());){
            Map map = artifactoryManager.getStagingStrategy(selectedStagingPlugin.getPluginName(), buildName, selectedStagingPlugin.getParamMap());
            return map;
        }
    }

    public List<ResolutionRepository> getVirtualRepositoryKeys(ResolverOverrider resolverOverrider, Item item) {
        CredentialsConfig preferredResolver = CredentialManager.getPreferredResolver(resolverOverrider, this);
        try (ArtifactoryManager artifactoryManager = this.createArtifactoryManager(preferredResolver.provideCredentials(item), ProxyUtils.createProxyConfiguration());){
            this.resolutionRepositories = RepositoriesUtils.generateResolutionRepos(artifactoryManager);
        }
        catch (IOException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.WARNING, "Could not obtain virtual repositories list from '" + this.url + "'", e);
            } else {
                log.log(Level.WARNING, "Could not obtain virtual repositories list from '" + this.url + "': " + e.getMessage());
            }
            return new ArrayList<ResolutionRepository>();
        }
        return this.resolutionRepositories;
    }

    public boolean isArtifactoryPro(DeployerOverrider deployerOverrider, Item item) {
        CredentialsConfig credentialsConfig = CredentialManager.getPreferredDeployer(deployerOverrider, this);
        Credentials credentials = credentialsConfig.provideCredentials(item);
        try {
            ArtifactoryManager artifactoryManager = new ArtifactoryManager(this.url, credentials.getUsername(), credentials.getPassword(), (Log)new NullLog());
            return !artifactoryManager.getVersion().isOSS();
        }
        catch (IOException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.WARNING, "Could not obtain artifactory version from '" + this.url + "'", e);
            } else {
                log.log(Level.WARNING, "Could not obtain artifactory version from '" + this.url + "': " + e.getMessage());
            }
            return false;
        }
    }

    public List<UserPluginInfo> getStagingUserPluginInfo(DeployerOverrider deployerOverrider, Item item) {
        ArrayList<UserPluginInfo> infosToReturn = new ArrayList<UserPluginInfo>();
        infosToReturn.add(UserPluginInfo.NO_PLUGIN);
        this.gatherUserPluginInfo(infosToReturn, "staging", deployerOverrider, item);
        return infosToReturn;
    }

    public List<UserPluginInfo> getPromotionsUserPluginInfo(DeployerOverrider deployerOverrider, Item item) {
        ArrayList<UserPluginInfo> infosToReturn = new ArrayList<UserPluginInfo>();
        infosToReturn.add(UserPluginInfo.NO_PLUGIN);
        this.gatherUserPluginInfo(infosToReturn, "promotions", deployerOverrider, item);
        return infosToReturn;
    }

    public ArtifactoryManager createArtifactoryManager(Credentials credentials, ProxyConfiguration proxyConfiguration) {
        return this.createArtifactoryManager(credentials, proxyConfiguration, (Log)new NullLog());
    }

    public ArtifactoryManager createArtifactoryManager(Credentials credentials, ProxyConfiguration proxyConfiguration, Log logger) {
        ArtifactoryManagerBuilder artifactoryManagerBuilder = this.createArtifactoryManagerBuilder(credentials, proxyConfiguration, logger);
        return artifactoryManagerBuilder.build();
    }

    public ArtifactoryManagerBuilder createArtifactoryManagerBuilder(Credentials credentials, ProxyConfiguration proxyConfiguration, Log logger) {
        ArtifactoryManagerBuilder artifactoryManagerBuilder = new ArtifactoryManagerBuilder();
        ((ArtifactoryManagerBuilder)((ArtifactoryManagerBuilder)((ArtifactoryManagerBuilder)((ArtifactoryManagerBuilder)((ArtifactoryManagerBuilder)((ArtifactoryManagerBuilder)artifactoryManagerBuilder.setServerUrl(this.url)).setUsername(credentials.getUsername())).setPassword(credentials.getPassword())).setAccessToken(credentials.getAccessToken())).setLog(logger)).setConnectionRetry(this.getConnectionRetry())).setConnectionTimeout(this.timeout);
        if (!this.bypassProxy) {
            artifactoryManagerBuilder.setProxyConfiguration(proxyConfiguration);
        }
        return artifactoryManagerBuilder;
    }

    private void setRetryParams(ArtifactoryManager artifactoryManager) {
        RepositoriesUtils.setRetryParams(this.getConnectionRetry(), artifactoryManager);
    }

    public ArtifactoryManager createArtifactoryManager(Credentials credentials, ProxyConfiguration proxyConfiguration, TaskListener listener) {
        ArtifactoryManager artifactoryManager = new ArtifactoryManager(this.url, credentials.getUsername(), credentials.getPassword(), credentials.getAccessToken(), (Log)new JenkinsBuildInfoLog(listener));
        artifactoryManager.setConnectionTimeout(this.timeout);
        this.setRetryParams(artifactoryManager);
        if (!this.bypassProxy && proxyConfiguration != null) {
            artifactoryManager.setProxyConfiguration(proxyConfiguration.host, proxyConfiguration.port, proxyConfiguration.username, proxyConfiguration.password);
        }
        return artifactoryManager;
    }

    public CredentialsConfig getResolvingCredentialsConfig() {
        if (this.resolverCredentialsConfig != null && this.resolverCredentialsConfig.isCredentialsProvided()) {
            return this.getResolverCredentialsConfig();
        }
        if (this.deployerCredentialsConfig != null) {
            return this.getDeployerCredentialsConfig();
        }
        return CredentialsConfig.EMPTY_CREDENTIALS_CONFIG;
    }

    private void gatherUserPluginInfo(List<UserPluginInfo> infosToReturn, String pluginKey, DeployerOverrider deployerOverrider, Item item) {
        CredentialsConfig credentialsConfig = CredentialManager.getPreferredDeployer(deployerOverrider, this);
        try (ArtifactoryManager artifactoryManager = this.createArtifactoryManager(credentialsConfig.provideCredentials(item), ProxyUtils.createProxyConfiguration());){
            List stagingUserPluginInfo;
            Map userPluginInfo = artifactoryManager.getUserPluginInfo();
            if (userPluginInfo != null && userPluginInfo.containsKey(pluginKey) && (stagingUserPluginInfo = (List)userPluginInfo.get(pluginKey)) != null) {
                for (Map stagingPluginInfo : stagingUserPluginInfo) {
                    infosToReturn.add(new UserPluginInfo(stagingPluginInfo));
                }
                Collections.sort(infosToReturn, new Comparator<UserPluginInfo>(){

                    @Override
                    public int compare(UserPluginInfo o1, UserPluginInfo o2) {
                        return o1.getPluginName().compareTo(o2.getPluginName());
                    }
                });
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to obtain user plugin info: " + e.getMessage());
        }
    }

    public void setLog(TaskListener listener, ArtifactoryManager artifactoryManager) {
        artifactoryManager.setLog((Log)new JenkinsBuildInfoLog(listener));
    }

    public void reportUsage(String stepName, WorkflowRun build, Log logger) {
        try {
            CredentialsConfig config = this.getDeployerCredentialsConfig();
            if (config == null) {
                config = this.getResolverCredentialsConfig();
            }
            Credentials credentials = config.provideCredentials((Item)build.getParent());
            String[] featureIdArray = new String[]{stepName};
            UsageReporter usageReporter = new UsageReporter("jenkins-artifactory-plugin/" + ActionableHelper.getArtifactoryPluginVersion(), featureIdArray);
            usageReporter.reportUsage(this.getArtifactoryUrl(), credentials.getUsername(), credentials.getPassword(), credentials.getAccessToken(), Utils.getProxyConfiguration(this), null, logger);
            logger.debug("Usage info sent successfully.");
        }
        catch (Exception ex) {
            logger.error("Failed sending usage report to Artifactory: " + ex);
        }
    }

    public static final class ConverterImpl
    extends ArtifactoryServerConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }

    private static class RepositoryComparator
    implements Comparator<String>,
    Serializable {
        private RepositoryComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.contains("snapshot") && !o2.contains("snapshot")) {
                return 1;
            }
            return -1;
        }
    }
}

