/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import hudson.model.BuildBadgeAction;
import hudson.model.Run;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.UrlUtils;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.hudson.ArtifactoryRedeployPublisher;
import org.jfrog.hudson.PublishedBuildDetails;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;

public class BuildInfoResultAction
implements BuildBadgeAction {
    private static final Logger log = Logger.getLogger(BuildInfoResultAction.class.getName());
    private List<PublishedBuildDetails> publishedBuildsDetails = new CopyOnWriteArrayList<PublishedBuildDetails>();
    private final Run build;
    @Deprecated
    private String url;
    @Deprecated
    private transient ArtifactoryRedeployPublisher artifactoryRedeployPublisher;

    public BuildInfoResultAction(Run build) {
        this.build = build;
    }

    public BuildInfoResultAction(String artifactoryUrl, Run build, String buildName, String project) {
        this(build);
        String buildNumber = BuildUniqueIdentifierHelper.getBuildNumber(build);
        this.publishedBuildsDetails.add(this.createBuildInfoIdentifier(artifactoryUrl, buildName, buildNumber, "", "", project));
    }

    public void addBuildInfoResults(String artifactoryUrl, String platformUrl, BuildInfo buildInfo) {
        this.publishedBuildsDetails.add(this.createBuildInfoIdentifier(artifactoryUrl, this.build, buildInfo, platformUrl));
    }

    public Run getBuild() {
        return this.build;
    }

    public String getIconFileName() {
        return "/plugin/artifactory/images/artifactory-icon.png";
    }

    public String getDisplayName() {
        return "Artifactory Build Info";
    }

    public String getUrlName() {
        if (StringUtils.isNotEmpty((CharSequence)this.url)) {
            return this.url;
        }
        if (this.publishedBuildsDetails == null) {
            this.publishedBuildsDetails = new CopyOnWriteArrayList<PublishedBuildDetails>();
        }
        if (this.publishedBuildsDetails.size() == 0 && this.artifactoryRedeployPublisher != null && this.build != null) {
            String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(this.artifactoryRedeployPublisher, this.build);
            return this.generateUrl(this.artifactoryRedeployPublisher.getArtifactoryName(), this.build, buildName);
        }
        if (this.publishedBuildsDetails.size() == 1) {
            return this.publishedBuildsDetails.get(0).getBuildInfoUrl();
        }
        return "published_builds";
    }

    private PublishedBuildDetails createBuildInfoIdentifier(String artifactoryUrl, String buildName, String buildNumber, String platformUrl, String startedBuildTimestamp, String project) {
        return new PublishedBuildDetails(artifactoryUrl, UrlUtils.encodeUrlPathPart((String)buildName), UrlUtils.encodeUrlPathPart((String)buildNumber), platformUrl, startedBuildTimestamp, project);
    }

    private PublishedBuildDetails createBuildInfoIdentifier(String artifactoryUrl, Run build, BuildInfo buildInfo, String platformUrl) {
        String buildName = StringUtils.isNotEmpty((CharSequence)buildInfo.getName()) ? buildInfo.getName() : BuildUniqueIdentifierHelper.getBuildName(build);
        String buildNumber = StringUtils.isNotEmpty((CharSequence)buildInfo.getNumber()) ? buildInfo.getNumber() : BuildUniqueIdentifierHelper.getBuildNumber(build);
        return this.createBuildInfoIdentifier(artifactoryUrl, buildName, buildNumber, platformUrl, String.valueOf(buildInfo.getStartedMillis()), buildInfo.getProject());
    }

    private String generateUrl(String artifactoryUrl, Run<?, ?> build, String buildName) {
        return BuildInfoExtractorUtils.createBuildInfoUrl((String)artifactoryUrl, (String)buildName, (String)BuildUniqueIdentifierHelper.getBuildNumber(build), (String)"", (String)"", (boolean)true, (boolean)false);
    }

    public boolean haveMultipleBuilds() {
        return this.publishedBuildsDetails != null && this.publishedBuildsDetails.size() > 1;
    }

    public List<PublishedBuildDetails> getPublishedBuildsDetails() {
        return this.publishedBuildsDetails;
    }

    @Deprecated
    public void setUrl(String url) {
        this.url = url;
    }
}

