/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import hudson.model.Item;
import hudson.util.Secret;
import hudson.util.XStream2;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.converters.CredentialsConfigConverter;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class CredentialsConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final CredentialsConfig EMPTY_CREDENTIALS_CONFIG = new CredentialsConfig("", "", "", false);
    private Secret username;
    private Secret password;
    private String credentialsId;
    private Boolean overridingCredentials;
    private boolean ignoreCredentialPluginDisabled;
    @Deprecated
    private Credentials credentials = null;

    @DataBoundConstructor
    public CredentialsConfig(String username, String password, String credentialsId, Boolean overridingCredentials) {
        this.overridingCredentials = overridingCredentials != null && overridingCredentials != false;
        if (overridingCredentials == null || overridingCredentials.equals(Boolean.TRUE)) {
            this.username = Secret.fromString((String)username);
            this.password = Secret.fromString((String)password);
        }
        this.credentialsId = credentialsId;
    }

    public CredentialsConfig(String username, String password, String credentialsId) {
        this.overridingCredentials = false;
        this.ignoreCredentialPluginDisabled = StringUtils.isNotEmpty((CharSequence)credentialsId);
        this.username = Secret.fromString((String)username);
        this.password = Secret.fromString((String)password);
        this.credentialsId = credentialsId;
    }

    public void deleteCredentials() {
        this.username = Secret.fromString((String)"");
        this.password = Secret.fromString((String)"");
    }

    public boolean isCredentialsProvided() {
        if (PluginsUtils.isCredentialsPluginEnabled() || this.ignoreCredentialPluginDisabled) {
            return StringUtils.isNotBlank((CharSequence)this.credentialsId);
        }
        return this.overridingCredentials;
    }

    private String provideUsername(Item item) {
        return this.isUsingCredentialsPlugin() ? PluginsUtils.usernamePasswordCredentialsLookup(this.credentialsId, item).getUsername() : Secret.toString((Secret)this.username);
    }

    private String providePassword(Item item) {
        return this.isUsingCredentialsPlugin() ? PluginsUtils.usernamePasswordCredentialsLookup(this.credentialsId, item).getPassword() : Secret.toString((Secret)this.password);
    }

    public String provideAccessToken(Item item) {
        StringCredentials accessTokenCredentials;
        if (this.isUsingCredentialsPlugin() && (accessTokenCredentials = PluginsUtils.accessTokenCredentialsLookup(this.credentialsId, item)) != null) {
            return accessTokenCredentials.getSecret().getPlainText();
        }
        return "";
    }

    public Credentials provideCredentials(Item item) {
        String accessToken = this.provideAccessToken(item);
        if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
            return new Credentials(accessToken);
        }
        return new Credentials(this.provideUsername(item), this.providePassword(item));
    }

    public String getUsername() {
        return Secret.toString((Secret)this.username);
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public boolean isOverridingCredentials() {
        return this.overridingCredentials;
    }

    public boolean isIgnoreCredentialPluginDisabled() {
        return this.ignoreCredentialPluginDisabled;
    }

    public void setIgnoreCredentialPluginDisabled(boolean ignoreCredentialPluginDisabled) {
        this.ignoreCredentialPluginDisabled = ignoreCredentialPluginDisabled;
    }

    public boolean isUsingCredentialsPlugin() {
        return PluginsUtils.isCredentialsPluginEnabled() && StringUtils.isNotEmpty((CharSequence)this.credentialsId) || this.ignoreCredentialPluginDisabled;
    }

    public static final class ConverterImpl
    extends CredentialsConfigConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }
}

