/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.kohsuke.stapler.DataBoundConstructor;

public class JFrogPlatformInstance {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 300;
    public static final int DEFAULT_DEPLOYMENT_THREADS_NUMBER = 3;
    private String url;
    private String distributionUrl;
    private String id;
    private org.jfrog.hudson.ArtifactoryServer artifactoryServer;
    private CredentialsConfig deployerCredentialsConfig;
    private CredentialsConfig resolverCredentialsConfig;
    private boolean bypassProxy;
    private int timeout;
    private Integer connectionRetry;
    private Integer deploymentThreads;

    @DataBoundConstructor
    public JFrogPlatformInstance(String instanceId, String platformUrl, String artifactoryUrl, String distributionUrl, CredentialsConfig deployerCredentialsConfig, CredentialsConfig resolverCredentialsConfig, int timeout, boolean bypassProxy, Integer connectionRetry, Integer deploymentThreads) {
        this.id = instanceId;
        this.url = StringUtils.isNotEmpty((CharSequence)platformUrl) ? StringUtils.removeEnd((String)platformUrl, (String)"/") : null;
        this.deployerCredentialsConfig = deployerCredentialsConfig;
        this.resolverCredentialsConfig = resolverCredentialsConfig;
        this.timeout = timeout > 0 ? timeout : 300;
        this.bypassProxy = bypassProxy;
        this.connectionRetry = connectionRetry != null ? connectionRetry : 3;
        this.deploymentThreads = deploymentThreads != null && deploymentThreads > 0 ? deploymentThreads : 3;
        this.distributionUrl = distributionUrl;
        this.artifactoryServer = new org.jfrog.hudson.ArtifactoryServer(this.id, artifactoryUrl, this.deployerCredentialsConfig, this.resolverCredentialsConfig, this.timeout, this.bypassProxy, this.connectionRetry, this.deploymentThreads);
    }

    public JFrogPlatformInstance(org.jfrog.hudson.ArtifactoryServer artifactoryServer) {
        this(artifactoryServer.getServerId(), null, artifactoryServer.getArtifactoryUrl(), null, artifactoryServer.getDeployerCredentialsConfig(), artifactoryServer.getResolverCredentialsConfig(), artifactoryServer.getTimeout(), artifactoryServer.isBypassProxy(), artifactoryServer.getConnectionRetry(), artifactoryServer.getDeploymentThreads());
    }

    public JFrogPlatformInstance(ArtifactoryServer artifactoryServer) {
        this(null, null, artifactoryServer.getUrl(), null, artifactoryServer.createCredentialsConfig(), artifactoryServer.createCredentialsConfig(), artifactoryServer.getConnection().getTimeout(), artifactoryServer.isBypassProxy(), artifactoryServer.getConnection().getRetry(), artifactoryServer.getDeploymentThreads());
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getInstanceId() {
        return this.getId();
    }

    public void setInstanceId(String instanceId) {
        this.id = instanceId;
    }

    public String getPlatformUrl() {
        return this.getUrl();
    }

    public void setPlatformUrl(String url) {
        this.setUrl(url);
    }

    public String getArtifactoryUrl() {
        return this.artifactoryServer.getArtifactoryUrl();
    }

    public void setArtifactoryUrl(String artifactoryUrl) {
        this.artifactoryServer.setArtifactoryUrl(artifactoryUrl);
    }

    public org.jfrog.hudson.ArtifactoryServer getArtifactory() {
        return this.artifactoryServer;
    }

    public CredentialsConfig getDeployerCredentialsConfig() {
        return this.deployerCredentialsConfig;
    }

    public void setDeployerCredentialsConfig(CredentialsConfig cred) {
        this.deployerCredentialsConfig = cred;
    }

    public CredentialsConfig getResolverCredentialsConfig() {
        return this.resolverCredentialsConfig;
    }

    public void setResolverCredentialsConfig(CredentialsConfig cred) {
        this.resolverCredentialsConfig = cred;
    }

    public List<Integer> getConnectionRetries() {
        ArrayList<Integer> items = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            items.add(i);
        }
        return items;
    }

    public List<Integer> getDeploymentsThreads() {
        ArrayList<Integer> items = new ArrayList<Integer>();
        for (int i = 1; i <= 10; ++i) {
            items.add(i);
        }
        return items;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isBypassProxy() {
        return this.getBypassProxy();
    }

    public boolean getBypassProxy() {
        return this.bypassProxy;
    }

    public void setBypassProxy(boolean bypassProxy) {
        this.bypassProxy = bypassProxy;
    }

    public int getConnectionRetry() {
        if (this.connectionRetry == null) {
            this.connectionRetry = 3;
        }
        return this.connectionRetry;
    }

    public void setConnectionRetry(int connectionRetry) {
        this.connectionRetry = connectionRetry;
    }

    public Integer getDeploymentThreads() {
        return this.deploymentThreads;
    }

    public void setDeploymentThreads(int deploymentThreads) {
        this.deploymentThreads = deploymentThreads;
    }

    public String getDistributionUrl() {
        return this.distributionUrl;
    }

    public void setDistributionUrl(String distributionUrl) {
        this.distributionUrl = distributionUrl;
    }
}

