/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;

public class PublishedBuildDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String artifactoryUrl;
    private final String buildNumber;
    private final String buildName;
    private String startedTimeStamp;
    private String platformUrl;
    private String project;

    public PublishedBuildDetails(String artifactoryUrl, String buildName, String buildNumber) {
        this.artifactoryUrl = artifactoryUrl;
        this.buildName = buildName;
        this.buildNumber = buildNumber;
    }

    public PublishedBuildDetails(String artifactoryUrl, String buildName, String buildNumber, String platformUrl, String startedTimeStamp, String project) {
        this(artifactoryUrl, buildName, buildNumber);
        this.platformUrl = platformUrl;
        this.startedTimeStamp = startedTimeStamp;
        this.project = project;
    }

    public String getBuildInfoUrl() {
        boolean isPlatformUrl = StringUtils.isNotBlank((CharSequence)this.platformUrl);
        String url = isPlatformUrl ? this.platformUrl : this.artifactoryUrl;
        return BuildInfoExtractorUtils.createBuildInfoUrl((String)url, (String)this.buildName, (String)this.buildNumber, (String)this.startedTimeStamp, (String)this.project, (boolean)false, (boolean)isPlatformUrl);
    }

    public String getDisplayName() {
        return this.buildName + " / " + this.buildNumber;
    }
}

