/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.XStream2;
import java.util.HashMap;
import org.jfrog.hudson.PluginSettings;
import org.jfrog.hudson.RepositoryConf;
import org.jfrog.hudson.util.converters.ServerDetailsConverter;
import org.kohsuke.stapler.DataBoundConstructor;

public class ServerDetails {
    public final String artifactoryName;
    private final String artifactoryUrl;
    private final RepositoryConf deployReleaseRepository;
    private final RepositoryConf deploySnapshotRepository;
    private final RepositoryConf resolveSnapshotRepository;
    private final RepositoryConf resolveReleaseRepository;
    @Deprecated
    public String repositoryKey;
    @Deprecated
    public String snapshotsRepositoryKey;
    @Deprecated
    public String downloadSnapshotRepositoryKey;
    @Deprecated
    public String downloadReleaseRepositoryKey;
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="written by jelly")
    private String downloadSnapshotRepositoryDisplayName;
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="written by jelly")
    private String downloadReleaseRepositoryDisplayName;
    private PluginSettings stagingPlugin;
    private String userPluginKey;
    private String userPluginParams;
    @Deprecated
    private String downloadRepositoryKey;

    @DataBoundConstructor
    public ServerDetails(String artifactoryName, String artifactoryUrl, RepositoryConf deployReleaseRepository, RepositoryConf deploySnapshotRepository, RepositoryConf resolveReleaseRepository, RepositoryConf resolveSnapshotRepository, String userPluginKey, String userPluginParams) {
        this.artifactoryName = artifactoryName;
        this.artifactoryUrl = artifactoryUrl;
        this.deployReleaseRepository = deployReleaseRepository;
        this.deploySnapshotRepository = deploySnapshotRepository;
        this.resolveReleaseRepository = resolveReleaseRepository;
        this.resolveSnapshotRepository = resolveSnapshotRepository;
        this.userPluginKey = userPluginKey;
        this.userPluginParams = userPluginParams;
        this.createStagingPlugin();
    }

    public ServerDetails(String artifactoryName, String artifactoryUrl, RepositoryConf deployReleaseRepository, RepositoryConf deploySnapshotRepository, RepositoryConf resolveReleaseRepository, RepositoryConf resolveSnapshotRepository) {
        this(artifactoryName, artifactoryUrl, deployReleaseRepository, deploySnapshotRepository, resolveReleaseRepository, resolveSnapshotRepository, null, null);
    }

    public String getArtifactoryName() {
        return this.artifactoryName;
    }

    public RepositoryConf getDeployReleaseRepository() {
        return this.deployReleaseRepository;
    }

    public RepositoryConf getDeploySnapshotRepository() {
        if (this.deploySnapshotRepository == null) {
            return this.deployReleaseRepository;
        }
        return this.deploySnapshotRepository;
    }

    public RepositoryConf getResolveReleaseRepository() {
        return this.resolveReleaseRepository;
    }

    public RepositoryConf getResolveSnapshotRepository() {
        if (this.resolveSnapshotRepository == null) {
            return this.resolveReleaseRepository;
        }
        return this.resolveSnapshotRepository;
    }

    public String getUserPluginKey() {
        return this.stagingPlugin != null ? this.stagingPlugin.getPluginName() : null;
    }

    public String getDeployReleaseRepositoryKey() {
        if (this.deployReleaseRepository != null) {
            return this.deployReleaseRepository.getRepoKey();
        }
        return "";
    }

    public String getDeploySnapshotRepositoryKey() {
        return this.getDeploySnapshotRepository().getRepoKey();
    }

    public String getResolveReleaseRepositoryKey() {
        return this.getResolveReleaseRepository().getRepoKey();
    }

    public String getResolveSnapshotRepositoryKey() {
        return this.getResolveSnapshotRepository().getRepoKey();
    }

    public void createStagingPlugin() {
        if (this.stagingPlugin == null) {
            this.stagingPlugin = new PluginSettings();
        }
        if (this.userPluginKey != null) {
            this.stagingPlugin.setPluginName(this.userPluginKey);
        }
        if (this.userPluginParams != null) {
            String[] params;
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            for (String param : params = this.userPluginParams.split(" ")) {
                String[] keyValue = param.split("=");
                if (keyValue.length != 2) continue;
                paramsMap.put(keyValue[0], keyValue[1]);
            }
            this.stagingPlugin.setParamMap(paramsMap);
        }
    }

    public String getDownloadReleaseRepositoryDisplayName() {
        if (this.downloadReleaseRepositoryDisplayName == null && this.resolveReleaseRepository != null) {
            return this.resolveReleaseRepository.getRepoKey();
        }
        return this.downloadReleaseRepositoryDisplayName;
    }

    public String getDownloadSnapshotRepositoryDisplayName() {
        if (this.downloadSnapshotRepositoryDisplayName == null && this.resolveSnapshotRepository != null) {
            return this.resolveSnapshotRepository.getRepoKey();
        }
        return this.downloadSnapshotRepositoryDisplayName;
    }

    public PluginSettings getStagingPlugin() {
        return this.stagingPlugin;
    }

    public void setStagingPlugin(PluginSettings stagingPlugin) {
        this.stagingPlugin = stagingPlugin;
    }

    public String getArtifactoryUrl() {
        return this.artifactoryUrl != null ? this.artifactoryUrl : this.artifactoryName;
    }

    public String getStagingPluginName() {
        return this.stagingPlugin != null ? this.stagingPlugin.getPluginName() : null;
    }

    public String getPluginParamValue(String pluginName, String paramKey) {
        return this.stagingPlugin != null ? this.stagingPlugin.getPluginParamValue(pluginName, paramKey) : null;
    }

    public static final class ConverterImpl
    extends ServerDetailsConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }
}

