/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfrog.hudson.UserPluginInfoParam;

public class UserPluginInfo {
    public static final String NO_PLUGIN_KEY = "None";
    private String pluginName;
    private Map pluginParams;
    public static final UserPluginInfo NO_PLUGIN = new UserPluginInfo("None");

    public UserPluginInfo(Map stagingPluginInfo) {
        this.pluginName = stagingPluginInfo.get("name").toString();
        Object params = stagingPluginInfo.get("params");
        this.pluginParams = params == null ? new HashMap() : (Map)params;
    }

    private UserPluginInfo(String name) {
        this.pluginName = name;
        this.pluginParams = new HashMap();
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public List<UserPluginInfoParam> getPluginParams() {
        ArrayList<UserPluginInfoParam> pluginParamList = new ArrayList<UserPluginInfoParam>();
        for (Map.Entry paramEntry : this.pluginParams.entrySet()) {
            pluginParamList.add(new UserPluginInfoParam(paramEntry.getKey(), paramEntry.getValue()));
        }
        Collections.sort(pluginParamList, new Comparator<UserPluginInfoParam>(){

            @Override
            public int compare(UserPluginInfoParam o1, UserPluginInfoParam o2) {
                return o1.getKey().toString().compareTo(o2.getKey().toString());
            }
        });
        return pluginParamList;
    }

    public void addParam(Object key, Object value) {
        this.pluginParams.put(key, value);
    }
}

