/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.generic;

import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.extractor.builder.ModuleBuilder;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.ci.BuildRetention;
import org.jfrog.build.extractor.ci.Dependency;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.retention.Utils;
import org.jfrog.hudson.AbstractBuildInfoDeployer;
import org.jfrog.hudson.generic.ArtifactoryGenericConfigurator;
import org.jfrog.hudson.util.BuildRetentionFactory;
import org.jfrog.hudson.util.ExtractorUtils;

public class GenericBuildInfoDeployer
extends AbstractBuildInfoDeployer {
    private final Run build;
    private ArtifactoryGenericConfigurator configurator;
    private BuildInfo buildInfo;

    public GenericBuildInfoDeployer(ArtifactoryGenericConfigurator configurator, ArtifactoryManager artifactoryManager, Run build, TaskListener listener, List<Artifact> deployedArtifacts, List<BuildDependency> buildDependencies, List<Dependency> publishedDependencies) throws IOException, NoSuchAlgorithmException, InterruptedException {
        super(configurator, build, listener, artifactoryManager);
        this.configurator = configurator;
        this.build = build;
        this.buildInfo = this.createBuildInfo("Generic", "");
        this.buildInfo.setProject(configurator.getProject());
        this.createDeployDetailsAndAddToBuildInfo(deployedArtifacts, publishedDependencies);
    }

    public void deploy() throws IOException {
        String url = this.configurator.getArtifactoryServer().getArtifactoryUrl() + "/api/build";
        this.listener.getLogger().println("Deploying build info to: " + url);
        BuildRetention retention = this.getBuildRetention();
        Utils.sendBuildAndBuildRetention((ArtifactoryManager)this.artifactoryManager, (BuildInfo)this.buildInfo, (BuildRetention)retention, (boolean)this.configurator.isAsyncBuildRetention());
    }

    private BuildRetention getBuildRetention() {
        BuildRetention buildRetention = null;
        if (this.configurator.isDiscardOldBuilds()) {
            buildRetention = BuildRetentionFactory.createBuildRetention(this.build, this.configurator.isDiscardBuildArtifacts());
        }
        return buildRetention;
    }

    private void createDeployDetailsAndAddToBuildInfo(List<Artifact> deployedArtifacts, List<Dependency> publishedDependencies) throws IOException, NoSuchAlgorithmException {
        ModuleBuilder moduleBuilder = new ModuleBuilder().id(ExtractorUtils.sanitizeBuildName(this.build.getParent().getDisplayName()) + ":" + this.build.getNumber()).artifacts(deployedArtifacts);
        moduleBuilder.dependencies(publishedDependencies);
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(moduleBuilder.build());
        this.buildInfo.setModules(modules);
    }
}

