/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.gradle;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.BuildableItem;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.FreeStyleBuild;
import hudson.model.Item;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.gradle.Gradle;
import hudson.tasks.BuildWrapper;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.hudson.AbstractBuildWrapperDescriptor;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.BuildInfoResultAction;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.MultiConfigurationAware;
import org.jfrog.hudson.PluginSettings;
import org.jfrog.hudson.Repository;
import org.jfrog.hudson.RepositoryConf;
import org.jfrog.hudson.ResolutionRepository;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.UserPluginInfo;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.action.ArtifactoryProjectAction;
import org.jfrog.hudson.gradle.GradleInitScriptWriter;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.release.gradle.BaseGradleReleaseAction;
import org.jfrog.hudson.release.gradle.GradleReleaseAction;
import org.jfrog.hudson.release.gradle.GradleReleaseApiAction;
import org.jfrog.hudson.release.gradle.GradleReleaseWrapper;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.ConcurrentJobsHelper;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.RefreshServerResponse;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.ResolverContext;
import org.jfrog.hudson.util.converters.DeployerResolverOverriderConverter;
import org.jfrog.hudson.util.plugins.MultiConfigurationUtils;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.jfrog.hudson.util.publisher.PublisherContext;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ArtifactoryGradleConfigurator
extends BuildWrapper
implements DeployerOverrider,
ResolverOverrider,
BuildInfoAwareConfigurator,
MultiConfigurationAware {
    public boolean deployMaven;
    public boolean deployIvy;
    public String remotePluginLocation;
    public boolean deployBuildInfo;
    public boolean includeEnvVars;
    private CredentialsConfig deployerCredentialsConfig;
    private CredentialsConfig resolverCredentialsConfig;
    private String ivyPattern;
    private boolean enableIssueTrackerIntegration;
    private boolean aggregateBuildIssues;
    private String artifactPattern;
    private Boolean useMavenPatterns;
    private IncludesExcludes artifactDeploymentPatterns;
    private boolean discardOldBuilds;
    private boolean passIdentifiedDownstream;
    private GradleReleaseWrapper releaseWrapper;
    private boolean discardBuildArtifacts;
    private boolean asyncBuildRetention;
    private String deploymentProperties;
    private Boolean useArtifactoryGradlePlugin;
    private boolean allowPromotionOfNonStagedBuilds;
    private boolean filterExcludedArtifactsFromBuild;
    private final ServerDetails resolverDetails;
    private String defaultPromotionTargetRepository;
    private ServerDetails deployerDetails;
    private boolean deployArtifacts;
    private IncludesExcludes envVarsPatterns;
    private String aggregationBuildStatus;
    private String artifactoryCombinationFilter;
    private String customBuildName;
    private boolean overrideBuildName;
    private String project;
    @Deprecated
    private Credentials overridingDeployerCredentials;
    @Deprecated
    private Credentials overridingResolverCredentials;
    @Deprecated
    private ServerDetails details = null;
    @Deprecated
    private final String matrixParams;
    @Deprecated
    private final Boolean notM2Compatible = null;
    @Deprecated
    private final Boolean skipInjectInitScript = null;

    @DataBoundConstructor
    public ArtifactoryGradleConfigurator(ServerDetails details, ServerDetails deployerDetails, ServerDetails resolverDetails, CredentialsConfig deployerCredentialsConfig, CredentialsConfig resolverCredentialsConfig, boolean deployMaven, boolean deployIvy, boolean deployArtifacts, String remotePluginLocation, boolean includeEnvVars, IncludesExcludes envVarsPatterns, boolean deployBuildInfo, String ivyPattern, String artifactPattern, Boolean useMavenPatterns, Boolean notM2Compatible, IncludesExcludes artifactDeploymentPatterns, boolean discardOldBuilds, boolean passIdentifiedDownstream, GradleReleaseWrapper releaseWrapper, boolean discardBuildArtifacts, boolean asyncBuildRetention, String matrixParams, String deploymentProperties, Boolean skipInjectInitScript, Boolean useArtifactoryGradlePlugin, boolean enableIssueTrackerIntegration, boolean aggregateBuildIssues, String aggregationBuildStatus, boolean allowPromotionOfNonStagedBuilds, String defaultPromotionTargetRepository, boolean filterExcludedArtifactsFromBuild, String artifactoryCombinationFilter, String customBuildName, boolean overrideBuildName, String project) {
        this.matrixParams = null;
        this.deployerDetails = deployerDetails;
        this.resolverDetails = resolverDetails;
        this.deployerCredentialsConfig = deployerCredentialsConfig;
        this.resolverCredentialsConfig = resolverCredentialsConfig;
        this.deployMaven = deployMaven;
        this.deployIvy = deployIvy;
        this.deployArtifacts = deployArtifacts;
        this.remotePluginLocation = remotePluginLocation;
        this.includeEnvVars = includeEnvVars;
        this.envVarsPatterns = envVarsPatterns;
        this.deployBuildInfo = deployBuildInfo;
        this.ivyPattern = ivyPattern;
        this.enableIssueTrackerIntegration = enableIssueTrackerIntegration;
        this.aggregateBuildIssues = aggregateBuildIssues;
        this.aggregationBuildStatus = aggregationBuildStatus;
        this.filterExcludedArtifactsFromBuild = filterExcludedArtifactsFromBuild;
        this.artifactPattern = this.cleanString(artifactPattern);
        this.useMavenPatterns = useMavenPatterns;
        this.artifactDeploymentPatterns = artifactDeploymentPatterns;
        this.discardOldBuilds = discardOldBuilds;
        this.passIdentifiedDownstream = passIdentifiedDownstream;
        this.releaseWrapper = releaseWrapper;
        this.asyncBuildRetention = asyncBuildRetention;
        this.discardBuildArtifacts = discardBuildArtifacts;
        this.deploymentProperties = deploymentProperties;
        this.useArtifactoryGradlePlugin = useArtifactoryGradlePlugin;
        this.allowPromotionOfNonStagedBuilds = allowPromotionOfNonStagedBuilds;
        this.defaultPromotionTargetRepository = defaultPromotionTargetRepository;
        this.artifactoryCombinationFilter = artifactoryCombinationFilter;
        this.customBuildName = customBuildName;
        this.overrideBuildName = overrideBuildName;
        this.project = project;
    }

    public ArtifactoryGradleConfigurator(ServerDetails details, ServerDetails deployerDetails, ServerDetails resolverDetails) {
        this.matrixParams = null;
        this.details = details;
        this.deployerDetails = deployerDetails;
        this.resolverDetails = resolverDetails;
    }

    public GradleReleaseWrapper getReleaseWrapper() {
        return this.releaseWrapper;
    }

    public ServerDetails getDeployerDetails() {
        return this.deployerDetails;
    }

    public ServerDetails getResolverDetails() {
        return this.resolverDetails;
    }

    public String getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public boolean isPassIdentifiedDownstream() {
        return this.passIdentifiedDownstream;
    }

    @Override
    public boolean isDiscardBuildArtifacts() {
        return this.discardBuildArtifacts;
    }

    @Override
    public boolean isDiscardOldBuilds() {
        return this.discardOldBuilds;
    }

    @Override
    public boolean isAsyncBuildRetention() {
        return this.asyncBuildRetention;
    }

    public boolean isUseArtifactoryGradlePlugin() {
        if (this.useArtifactoryGradlePlugin != null) {
            return this.useArtifactoryGradlePlugin;
        }
        return false;
    }

    @Override
    public boolean isOverridingDefaultDeployer() {
        return this.deployerCredentialsConfig != null && this.deployerCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public Credentials getOverridingDeployerCredentials() {
        return this.overridingDeployerCredentials;
    }

    @Override
    public CredentialsConfig getDeployerCredentialsConfig() {
        return this.deployerCredentialsConfig;
    }

    public String getArtifactPattern() {
        return this.cleanString(this.artifactPattern);
    }

    public String getIvyPattern() {
        return this.ivyPattern;
    }

    public IncludesExcludes getArtifactDeploymentPatterns() {
        return this.artifactDeploymentPatterns;
    }

    public boolean isDeployBuildInfo() {
        return this.deployBuildInfo;
    }

    @Override
    public boolean isIncludeEnvVars() {
        return this.includeEnvVars;
    }

    @Override
    public IncludesExcludes getEnvVarsPatterns() {
        return this.envVarsPatterns;
    }

    @Override
    public String getRepositoryKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getDeployReleaseRepository().getRepoKey() : null;
    }

    public String getUserPluginKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getUserPluginKey() : null;
    }

    public String getDownloadReleaseRepositoryKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getResolveReleaseRepository().getRepoKey() : null;
    }

    public String getArtifactoryName() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().artifactoryName : null;
    }

    public String getArtifactoryResolverName() {
        return this.resolverDetails != null ? this.resolverDetails.artifactoryName : null;
    }

    public String getArtifactoryUrl() {
        ArtifactoryServer server = this.getArtifactoryServer();
        return server != null ? server.getArtifactoryUrl() : null;
    }

    public boolean isDeployArtifacts() {
        return this.deployArtifacts;
    }

    public boolean isDeployMaven() {
        return this.deployMaven;
    }

    public boolean isDeployIvy() {
        return this.deployIvy;
    }

    public boolean isUseMavenPatterns() {
        return this.useMavenPatterns;
    }

    @Override
    public boolean isEnableIssueTrackerIntegration() {
        return this.enableIssueTrackerIntegration;
    }

    @Override
    public boolean isAggregateBuildIssues() {
        return this.aggregateBuildIssues;
    }

    @Override
    public String getAggregationBuildStatus() {
        return this.aggregationBuildStatus;
    }

    public boolean isAllowPromotionOfNonStagedBuilds() {
        return this.allowPromotionOfNonStagedBuilds;
    }

    @Override
    public String getDefaultPromotionTargetRepository() {
        return this.defaultPromotionTargetRepository;
    }

    public void setDefaultPromotionTargetRepository(String defaultPromotionTargetRepository) {
        this.defaultPromotionTargetRepository = defaultPromotionTargetRepository;
    }

    public boolean isFilterExcludedArtifactsFromBuild() {
        return this.filterExcludedArtifactsFromBuild;
    }

    @Override
    public String getArtifactoryCombinationFilter() {
        return this.artifactoryCombinationFilter;
    }

    @Override
    public boolean isMultiConfProject() {
        return this.getDescriptor().isMultiConfProject();
    }

    @Override
    public String getCustomBuildName() {
        return this.customBuildName;
    }

    @Override
    public boolean isOverrideBuildName() {
        return this.overrideBuildName;
    }

    private String cleanString(String artifactPattern) {
        return StringUtils.removeEnd((String)StringUtils.removeStart((String)artifactPattern, (String)"\""), (String)"\"");
    }

    public String getProject() {
        return this.project;
    }

    public Action getProjectAction(AbstractProject job) {
        return super.getProjectAction(job);
    }

    public Collection<? extends Action> getProjectActions(AbstractProject project) {
        List<ArtifactoryProjectAction> action = this.isOverrideBuildName() ? ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project, this.getCustomBuildName()) : ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project);
        if (this.getReleaseWrapper() != null) {
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.addAll(action);
            actions.add(new GradleReleaseAction(project));
            actions.add(new GradleReleaseApiAction(project));
            return actions;
        }
        return action;
    }

    public BuildWrapper.Environment setUp(final AbstractBuild build, final Launcher launcher, final BuildListener listener) throws IOException, InterruptedException {
        Gradle gradleBuild;
        final PrintStream log = listener.getLogger();
        log.println("Jenkins Artifactory Plugin version: " + ActionableHelper.getArtifactoryPluginVersion());
        PublisherContext.Builder publisherBuilder = this.getBuilder();
        RepositoriesUtils.validateServerConfig(build, listener, this.getArtifactoryServer(), this.getArtifactoryUrl());
        int totalBuilds = 1;
        if (this.isMultiConfProject(build)) {
            totalBuilds = ((MatrixProject)build.getParent().getParent()).getActiveConfigurations().size();
            if (this.isDeployArtifacts()) {
                if (StringUtils.isBlank((CharSequence)this.getArtifactoryCombinationFilter())) {
                    String error = "The field \"Combination Matches\" is empty, but is defined as mandatory!";
                    log.println(error);
                    throw new IllegalArgumentException(error);
                }
                boolean isFiltered = MultiConfigurationUtils.isfiltrated(build, this.getArtifactoryCombinationFilter());
                if (isFiltered) {
                    publisherBuilder.skipBuildInfoDeploy(true).deployArtifacts(false);
                }
            }
        }
        if (this.isRelease(build)) {
            this.releaseWrapper.setUp(build, launcher, listener);
        }
        if ((gradleBuild = this.getLastGradleBuild(build.getProject())) != null) {
            new ConcurrentJobsHelper.ConcurrentBuildSetupSync(build, totalBuilds){

                @Override
                public void setUp() {
                    ConcurrentJobsHelper.ConcurrentBuild concurrentBuild = ConcurrentJobsHelper.getConcurrentBuild(build);
                    String switches = gradleBuild.getSwitches() != null ? gradleBuild.getSwitches().replace("${ARTIFACTORY_INIT_SCRIPT}", "") : "";
                    String tasks = gradleBuild.getTasks() != null ? gradleBuild.getTasks().replace("${ARTIFACTORY_TASKS}", "") : "";
                    concurrentBuild.putParam("switches", switches);
                    concurrentBuild.putParam("tasks", tasks);
                    if (!ArtifactoryGradleConfigurator.this.isUseArtifactoryGradlePlugin()) {
                        ArtifactoryGradleConfigurator.this.setTargetsField(gradleBuild, "switches", switches + " ${ARTIFACTORY_INIT_SCRIPT}");
                    }
                    if (!StringUtils.contains((CharSequence)gradleBuild.getTasks(), (CharSequence)"artifactoryPublish")) {
                        tasks = ArtifactoryGradleConfigurator.this.isRelease(build) && StringUtils.isNotBlank((CharSequence)ArtifactoryGradleConfigurator.this.releaseWrapper.getAlternativeTasks()) ? "${ARTIFACTORY_TASKS}" : tasks + " ${ARTIFACTORY_TASKS}";
                        ArtifactoryGradleConfigurator.this.setTargetsField(gradleBuild, "tasks", tasks);
                    }
                }
            };
        } else {
            log.println("[Warning] No Gradle build configured");
        }
        final PublisherContext.Builder finalPublisherBuilder = publisherBuilder;
        return new BuildWrapper.Environment(){
            String initScriptPath;

            public void buildEnvVars(Map<String, String> env) {
                String alternativeGoals;
                GradleInitScriptWriter writer = new GradleInitScriptWriter(ActionableHelper.getNode(launcher).getRootPath());
                FilePath workspace = build.getWorkspace();
                try {
                    FilePath initScript = workspace.createTextTempFile("init-artifactory", "gradle", writer.generateInitScript(new EnvVars(env)), false);
                    ActionableHelper.deleteFilePathOnExit(initScript);
                    this.initScriptPath = initScript.getRemote();
                    this.initScriptPath = this.initScriptPath.replace('\\', '/');
                    env.put("ARTIFACTORY_INIT_SCRIPT", " --init-script " + this.initScriptPath);
                }
                catch (Exception e) {
                    log.println("Error occurred while writing Gradle Init Script: " + e.getMessage());
                    build.setResult(Result.FAILURE);
                }
                String tasks = "";
                if (ArtifactoryGradleConfigurator.this.isRelease(build) && StringUtils.isNotBlank((CharSequence)(alternativeGoals = ArtifactoryGradleConfigurator.this.releaseWrapper.getAlternativeTasks()))) {
                    tasks = alternativeGoals;
                }
                env.put("ARTIFACTORY_TASKS", tasks + " " + "artifactoryPublish");
                ServerDetails serverDetails = ArtifactoryGradleConfigurator.this.getDeployerDetails();
                serverDetails = this.releaseActionOverride(env, serverDetails);
                finalPublisherBuilder.serverDetails(serverDetails);
                ServerDetails resolverServerDetails = ArtifactoryGradleConfigurator.this.getResolverDetails();
                ResolverContext resolverContext = null;
                if (StringUtils.isNotBlank((CharSequence)resolverServerDetails.getResolveReleaseRepository().getRepoKey())) {
                    CredentialsConfig resolverCredentials = CredentialManager.getPreferredResolver(ArtifactoryGradleConfigurator.this, ArtifactoryGradleConfigurator.this.getArtifactoryServer());
                    resolverContext = new ResolverContext(ArtifactoryGradleConfigurator.this.getArtifactoryResolverServer(), resolverServerDetails, resolverCredentials.provideCredentials((Item)build.getProject()), ArtifactoryGradleConfigurator.this);
                }
                try {
                    ExtractorUtils.addBuilderInfoArguments(env, (Run)build, (TaskListener)listener, finalPublisherBuilder.build(), resolverContext, build.getWorkspace(), launcher, ArtifactoryGradleConfigurator.this.useArtifactoryGradlePlugin);
                }
                catch (Exception e) {
                    log.println(e.getMessage());
                    throw new RuntimeException(e);
                }
            }

            public boolean tearDown(final AbstractBuild build2, BuildListener listener2) throws IOException, InterruptedException {
                boolean success = false;
                boolean releaseSuccess = true;
                Result result = build2.getResult();
                if (ArtifactoryGradleConfigurator.this.isRelease(build2)) {
                    releaseSuccess = ArtifactoryGradleConfigurator.this.releaseWrapper.tearDown(build2, listener2);
                }
                if (gradleBuild != null) {
                    new ConcurrentJobsHelper.ConcurrentBuildTearDownSync(build2, result){

                        @Override
                        public void tearDown() {
                            ConcurrentJobsHelper.ConcurrentBuild concurrentBuild = ConcurrentJobsHelper.getConcurrentBuild(build2);
                            String switches = concurrentBuild.getParam("switches");
                            String tasks = concurrentBuild.getParam("tasks");
                            switches = switches.replace("${ARTIFACTORY_INIT_SCRIPT}", "");
                            tasks = tasks.replace("${ARTIFACTORY_TASKS}", "");
                            ArtifactoryGradleConfigurator.this.setTargetsField(gradleBuild, "switches", switches);
                            ArtifactoryGradleConfigurator.this.setTargetsField(gradleBuild, "tasks", tasks);
                            try {
                                ActionableHelper.deleteFilePath(build2.getWorkspace(), initScriptPath);
                            }
                            catch (IOException e) {
                                log.println(Arrays.toString(e.getStackTrace()));
                            }
                        }
                    };
                }
                if (result != null && result.isBetterOrEqualTo(Result.SUCCESS)) {
                    if (ArtifactoryGradleConfigurator.this.isDeployBuildInfo()) {
                        String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(ArtifactoryGradleConfigurator.this, (Run)build2);
                        build2.addAction((Action)new BuildInfoResultAction(ArtifactoryGradleConfigurator.this.getArtifactoryUrl(), (Run)build2, buildName, ArtifactoryGradleConfigurator.this.project));
                        ArtifactoryGradleConfigurator configurator = ActionableHelper.getBuildWrapper((BuildableItem)build2.getProject(), ArtifactoryGradleConfigurator.class);
                        if (configurator != null && ArtifactoryGradleConfigurator.this.isAllowPromotionOfNonStagedBuilds()) {
                            build2.addAction((Action)new UnifiedPromoteBuildAction((Run<?, ?>)build2, ArtifactoryGradleConfigurator.this, ArtifactoryGradleConfigurator.this.project));
                        }
                    }
                    success = true;
                }
                if (Result.ABORTED.equals(result)) {
                    ConcurrentJobsHelper.removeConcurrentBuildJob(build2);
                }
                return success && releaseSuccess;
            }

            private ServerDetails releaseActionOverride(Map<String, String> env, ServerDetails serverDetails) {
                ReleaseAction releaseAction = ActionableHelper.getLatestAction((Run)build, ReleaseAction.class);
                if (releaseAction != null) {
                    releaseAction.addVars(env);
                    String stagingRepository = releaseAction.getStagingRepositoryKey();
                    if (StringUtils.isBlank((CharSequence)stagingRepository)) {
                        stagingRepository = ArtifactoryGradleConfigurator.this.getRepositoryKey();
                    }
                    serverDetails = new ServerDetails(serverDetails.artifactoryName, serverDetails.getArtifactoryUrl(), new RepositoryConf(stagingRepository, stagingRepository, false), serverDetails.getDeploySnapshotRepository(), serverDetails.getResolveReleaseRepository(), serverDetails.getResolveSnapshotRepository());
                }
                return serverDetails;
            }
        };
    }

    private PublisherContext.Builder getBuilder() {
        return new PublisherContext.Builder().artifactoryServer(this.getArtifactoryServer()).deployerOverrider(this).discardOldBuilds(this.isDiscardOldBuilds()).deployArtifacts(this.isDeployArtifacts()).includesExcludes(this.getArtifactDeploymentPatterns()).skipBuildInfoDeploy(!this.isDeployBuildInfo()).includeEnvVars(this.isIncludeEnvVars()).envVarsPatterns(this.getEnvVarsPatterns()).discardBuildArtifacts(this.isDiscardBuildArtifacts()).asyncBuildRetention(this.isAsyncBuildRetention()).deploymentProperties(this.getDeploymentProperties()).artifactsPattern(this.getArtifactPattern()).ivyPattern(this.getIvyPattern()).deployIvy(this.isDeployIvy()).deployMaven(this.isDeployMaven()).maven2Compatible(this.isUseMavenPatterns()).enableIssueTrackerIntegration(this.isEnableIssueTrackerIntegration()).aggregateBuildIssues(this.isAggregateBuildIssues()).aggregationBuildStatus(this.getAggregationBuildStatus()).filterExcludedArtifactsFromBuild(this.isFilterExcludedArtifactsFromBuild()).artifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion()).overrideBuildName(this.isOverrideBuildName()).customBuildName(this.getCustomBuildName()).project(this.getProject());
    }

    public boolean isRelease(AbstractBuild build) {
        boolean actionExists = build.getAction(GradleReleaseAction.class) != null || build.getAction(GradleReleaseApiAction.class) != null;
        return this.getReleaseWrapper() != null && actionExists;
    }

    private Gradle getLastGradleBuild(AbstractProject project) {
        List<Gradle> gradles;
        if (project instanceof Project && (gradles = ActionableHelper.getBuilder((Project)project, Gradle.class)) != null && !gradles.isEmpty()) {
            return gradles.get(gradles.size() - 1);
        }
        return null;
    }

    private void setTargetsField(Gradle builder, String fieldName, String value) {
        try {
            Field targetsField = builder.getClass().getDeclaredField(fieldName);
            targetsField.setAccessible(true);
            targetsField.set(builder, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ArtifactoryServer getArtifactoryServer() {
        return RepositoriesUtils.getArtifactoryServer(this.getArtifactoryName());
    }

    public ArtifactoryServer getArtifactoryResolverServer() {
        return RepositoriesUtils.getArtifactoryServer(this.getArtifactoryResolverName());
    }

    public List<Repository> getReleaseRepositories() {
        return RepositoriesUtils.collectRepositories(this.getDeployerDetails().getDeployReleaseRepository().getKeyFromSelect());
    }

    public List<ResolutionRepository> getResolutionRepositories() {
        return RepositoriesUtils.collectResolutionRepositories(null, this.resolverDetails.getResolveSnapshotRepository().getKeyFromSelect());
    }

    @Override
    public boolean isOverridingDefaultResolver() {
        return this.resolverCredentialsConfig != null && this.resolverCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public Credentials getOverridingResolverCredentials() {
        return this.overridingResolverCredentials;
    }

    @Override
    public CredentialsConfig getResolverCredentialsConfig() {
        return this.resolverCredentialsConfig;
    }

    public List<UserPluginInfo> getStagingUserPluginInfo() {
        ArtifactoryServer artifactoryServer = this.getArtifactoryServer();
        return artifactoryServer.getStagingUserPluginInfo(this, null);
    }

    public PluginSettings getSelectedStagingPlugin() {
        return this.getDeployerDetails().getStagingPlugin();
    }

    private boolean isMultiConfProject(AbstractBuild build) {
        return build.getProject().getClass().equals(MatrixConfiguration.class);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static final class ConverterImpl
    extends DeployerResolverOverriderConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }

    @Extension
    public static final class ReleaseRunListener
    extends RunListener<AbstractBuild> {
        public void onCompleted(AbstractBuild run, TaskListener listener) {
            if (!(run instanceof FreeStyleBuild)) {
                return;
            }
            BaseGradleReleaseAction releaseAction = (BaseGradleReleaseAction)run.getAction(GradleReleaseAction.class);
            if (releaseAction == null) {
                releaseAction = (BaseGradleReleaseAction)run.getAction(GradleReleaseApiAction.class);
            }
            if (releaseAction == null) {
                return;
            }
            ArtifactoryGradleConfigurator wrapper = ActionableHelper.getBuildWrapper((BuildableItem)((BuildableItemWithBuildWrappers)run.getProject()), ArtifactoryGradleConfigurator.class);
            Result result = run.getResult();
            boolean successRun = result.isBetterOrEqualTo(Result.SUCCESS);
            if (!wrapper.isAllowPromotionOfNonStagedBuilds() && successRun) {
                run.addAction((Action)new UnifiedPromoteBuildAction((Run<?, ?>)run, wrapper, ""));
            }
            try {
                wrapper.getReleaseWrapper().getScmCoordinator().buildCompleted();
            }
            catch (Exception e) {
                run.setResult(Result.FAILURE);
                listener.error("[RELEASE] Failed on build completion");
                listener.getLogger().println(e);
            }
            releaseAction.reset();
            run.removeAction((Action)releaseAction);
        }
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractBuildWrapperDescriptor {
        private static final String DISPLAY_NAME = "Gradle-Artifactory Integration";
        private static final String CONFIG_PREFIX = "gradle";

        public DescriptorImpl() {
            super(ArtifactoryGradleConfigurator.class, DISPLAY_NAME, CONFIG_PREFIX);
        }

        protected DescriptorImpl(Class<? extends BuildWrapper> clazz) {
            super(clazz, DISPLAY_NAME, CONFIG_PREFIX);
        }

        @JavaScriptMethod
        public RefreshServerResponse refreshFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
            return super.refreshDeployersFromArtifactory(url, credentialsId, username, password, overrideCredentials, true);
        }

        @Override
        @JavaScriptMethod
        public RefreshServerResponse refreshResolversFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
            return super.refreshResolversFromArtifactory(url, credentialsId, username, password, overrideCredentials);
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            return PluginsUtils.fillPluginProjectCredentials(project);
        }
    }
}

