/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.ivy;

import hudson.Extension;
import hudson.ivy.IvyModuleSet;
import hudson.ivy.IvyModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import org.jfrog.hudson.BuildInfoResultAction;
import org.jfrog.hudson.ivy.ArtifactoryIvyConfigurator;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;

@Extension(optional=true)
public class ArtifactoryIvyRunListener
extends RunListener<AbstractBuild> {
    public ArtifactoryIvyRunListener() {
        super(AbstractBuild.class);
    }

    public void onCompleted(AbstractBuild run, TaskListener listener) {
        if ("hudson.ivy.IvyModuleSetBuild".equals(run.getClass().getName())) {
            IvyModuleSetBuild ivyRun = (IvyModuleSetBuild)run;
            Result result = ivyRun.getResult();
            if (result == null || result.isWorseThan(Result.SUCCESS)) {
                return;
            }
            ArtifactoryIvyConfigurator artifactoryIvyConfigurator = (ArtifactoryIvyConfigurator)((IvyModuleSet)ivyRun.getProject()).getBuildWrappersList().get(ArtifactoryIvyConfigurator.class);
            if (artifactoryIvyConfigurator == null) {
                return;
            }
            if (artifactoryIvyConfigurator.isDeployBuildInfo()) {
                String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(artifactoryIvyConfigurator, (Run)run);
                run.addAction((Action)new BuildInfoResultAction(artifactoryIvyConfigurator.getArtifactoryUrl(), (Run)run, buildName, ""));
                run.addAction((Action)new UnifiedPromoteBuildAction((Run<?, ?>)run, artifactoryIvyConfigurator, ""));
            }
        }
    }
}

