/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.jfpipelines;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.client.PreemptiveHttpClient;
import org.jfrog.build.client.PreemptiveHttpClientBuilder;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.client.Version;
import org.jfrog.build.util.VersionCompatibilityType;
import org.jfrog.build.util.VersionException;
import org.jfrog.hudson.jfpipelines.payloads.JobStatusPayload;
import org.jfrog.hudson.util.SerializationUtils;

public class JFrogPipelinesHttpClient
implements AutoCloseable {
    static final Version MINIMAL_PIPELINES_VERSION = new Version("1.6.0");
    private static final int DEFAULT_CONNECTION_TIMEOUT_SECS = 300;
    private static final int DEFAULT_CONNECTION_RETRIES = 3;
    private ProxyConfiguration proxyConfiguration;
    private final String pipelinesIntegrationUrl;
    private PreemptiveHttpClient httpClient;
    private final String accessToken;
    private int connectionTimeout = 300;
    private int connectionRetries = 3;
    private final Log log;

    public JFrogPipelinesHttpClient(String pipelinesIntegrationUrl, String accessToken, Log log) {
        this.pipelinesIntegrationUrl = StringUtils.stripEnd((String)pipelinesIntegrationUrl, (String)"/");
        this.accessToken = accessToken;
        this.log = log;
    }

    public JFrogPipelinesHttpClient(String pipelinesIntegrationUrl, String accessToken) {
        this(pipelinesIntegrationUrl, accessToken, (Log)new NullLog());
    }

    public void setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setConnectionRetries(int connectionRetries) {
        this.connectionRetries = connectionRetries;
    }

    public int getConnectionRetries() {
        return this.connectionRetries;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public PreemptiveHttpClient getHttpClient() {
        return this.getHttpClient(this.connectionTimeout);
    }

    public PreemptiveHttpClient getHttpClient(int connectionTimeout) {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        PreemptiveHttpClientBuilder clientBuilder = new PreemptiveHttpClientBuilder().setConnectionRetries(this.connectionRetries).setTimeout(connectionTimeout).setLog(this.log);
        if (this.proxyConfiguration != null) {
            clientBuilder.setProxyConfiguration(this.proxyConfiguration);
        }
        clientBuilder.setAccessToken(this.accessToken);
        this.httpClient = clientBuilder.build();
        return this.httpClient;
    }

    /*
     * Exception decompiling
     */
    public Version getVersion() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Version verifyCompatibleVersion() throws VersionException {
        Version version;
        try {
            version = this.getVersion();
        }
        catch (IOException e) {
            throw new VersionException("Error occurred while requesting version information: " + e.getMessage(), (Throwable)e, VersionCompatibilityType.NOT_FOUND);
        }
        if (version.isNotFound()) {
            throw new VersionException("There is either an incompatible version or no instance of JFrog Pipelines accessible at the provided URL.", VersionCompatibilityType.NOT_FOUND);
        }
        if (!version.isAtLeast(MINIMAL_PIPELINES_VERSION)) {
            throw new VersionException("This plugin is compatible with version " + MINIMAL_PIPELINES_VERSION + " or above of JFrog Pipelines. Please upgrade your JFrog Pipelines server!", VersionCompatibilityType.INCOMPATIBLE);
        }
        return version;
    }

    public CloseableHttpResponse sendStatus(JobStatusPayload payload) throws IOException {
        String text = SerializationUtils.createMapper().writeValueAsString((Object)payload);
        this.log.debug("Sending status to JFrog Pipelines with payload: " + text);
        StringEntity body = new StringEntity(text, ContentType.APPLICATION_JSON);
        return this.executePostRequest((HttpEntity)body);
    }

    private CloseableHttpResponse executePostRequest(HttpEntity body) throws IOException {
        HttpPost httpPost = new HttpPost(this.pipelinesIntegrationUrl);
        httpPost.setEntity(body);
        return this.getHttpClient().execute((HttpUriRequest)httpPost);
    }

    public String getMessageFromEntity(HttpEntity entity) throws IOException {
        if (entity == null) {
            return "";
        }
        String responseMessage = this.getResponseEntityContent(entity);
        if (StringUtils.isNotBlank((CharSequence)responseMessage)) {
            responseMessage = " Response message: " + responseMessage;
        }
        return responseMessage;
    }

    private String getResponseEntityContent(HttpEntity responseEntity) throws IOException {
        InputStream in = responseEntity.getContent();
        return StringUtils.defaultString((String)IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8));
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }
}

