/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.jfpipelines;

import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.jfpipelines.JFrogPipelinesHttpClient;
import org.jfrog.hudson.jfpipelines.JFrogPipelinesJobInfo;
import org.jfrog.hudson.jfpipelines.OutputResource;
import org.jfrog.hudson.jfpipelines.Utils;
import org.jfrog.hudson.jfpipelines.payloads.JobStartedPayload;
import org.jfrog.hudson.jfpipelines.payloads.JobStatusPayload;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.ProxyUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class JFrogPipelinesServer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERVER_NOT_FOUND_EXCEPTION = "Please configure JFrog Pipelines server under 'Manage Jenkins' -> 'Configure System' -> 'JFrog Pipelines server'.";
    public static final String FAILURE_PREFIX = "Failed to report status to JFrog Pipelines: ";
    public static final String BUILD_STARTED = "STARTED";
    public static final String BUILD_QUEUED = "QUEUED";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 300;
    private static final int DEFAULT_CONNECTION_RETRIES = 3;
    private CredentialsConfig credentialsConfig;
    private final int connectionRetries;
    private String integrationUrl;
    private boolean bypassProxy;
    private final int timeout;

    @DataBoundConstructor
    public JFrogPipelinesServer(String integrationUrl, CredentialsConfig credentialsConfig, int timeout, boolean bypassProxy, int connectionRetries) {
        this.connectionRetries = connectionRetries >= 0 ? connectionRetries : 3;
        this.integrationUrl = StringUtils.removeEnd((String)integrationUrl, (String)"/");
        this.timeout = timeout > 0 ? timeout : 300;
        this.credentialsConfig = credentialsConfig;
        this.bypassProxy = bypassProxy;
    }

    public JFrogPipelinesServer() {
        this.connectionRetries = 3;
        this.timeout = 300;
    }

    public String getIntegrationUrl() {
        return this.integrationUrl;
    }

    public CredentialsConfig getCredentialsConfig() {
        if (this.credentialsConfig == null) {
            return CredentialsConfig.EMPTY_CREDENTIALS_CONFIG;
        }
        return this.credentialsConfig;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isBypassProxy() {
        return this.bypassProxy;
    }

    public List<Integer> getConnectionRetriesOptions() {
        return IntStream.range(0, 10).boxed().collect(Collectors.toList());
    }

    public int getConnectionRetries() {
        return this.connectionRetries;
    }

    private JFrogPipelinesHttpClient createHttpClient(Log logger) {
        JFrogPipelinesHttpClient client = new JFrogPipelinesHttpClient(this.integrationUrl, this.credentialsConfig.provideCredentials(null).getAccessToken(), logger);
        client.setConnectionRetries(this.getConnectionRetries());
        client.setConnectionTimeout(this.getTimeout());
        if (!this.isBypassProxy()) {
            client.setProxyConfiguration(ProxyUtils.createProxyConfiguration());
        }
        return client;
    }

    public static void reportQueueId(Queue.Item queueItem, String stepId) throws IOException {
        JFrogPipelinesServer.getAndVerifyServer().report(new JobStatusPayload(BUILD_QUEUED, stepId, Utils.createJobInfo(queueItem), null), (Log)new NullLog());
    }

    public static void reportStarted(Run<?, ?> build, TaskListener listener) {
        JobStartedPayload payload = Utils.getJobStartedPayload(build, listener);
        if (payload == null || StringUtils.isBlank((CharSequence)payload.getStepId())) {
            return;
        }
        JenkinsBuildInfoLog logger = new JenkinsBuildInfoLog(listener);
        try {
            JFrogPipelinesServer.getAndVerifyServer().report(new JobStatusPayload(BUILD_STARTED, payload.getStepId(), Utils.createJobInfo(build), null), logger);
        }
        catch (IOException e) {
            logger.error(FAILURE_PREFIX + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportCompleted(Run<?, ?> build, TaskListener listener) {
        JobStartedPayload payload = Utils.getJobStartedPayload(build, listener);
        if (payload == null || StringUtils.isBlank((CharSequence)payload.getStepId())) {
            return;
        }
        JenkinsBuildInfoLog logger = new JenkinsBuildInfoLog(listener);
        try {
            JFrogPipelinesServer pipelinesServer = JFrogPipelinesServer.getAndVerifyServer();
            JFrogPipelinesJobInfo jobInfo = Utils.getPipelinesJobInfo(build);
            List<OutputResource> outputResources = null;
            if (jobInfo != null) {
                if (jobInfo.isReported()) {
                    logger.debug("Skipping reporting to JFrog Pipelines - status is already reported in jfPipelines step.");
                    return;
                }
                outputResources = OutputResource.fromString(jobInfo.getOutputResources());
            }
            Result result = (Result)ObjectUtils.defaultIfNull((Object)build.getResult(), (Object)Result.NOT_BUILT);
            pipelinesServer.report(new JobStatusPayload(result.toExportedObject(), payload.getStepId(), Utils.createJobInfo(build), outputResources), logger);
        }
        catch (IOException | InterruptedException e) {
            logger.error(FAILURE_PREFIX + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
        }
        finally {
            DeclarativePipelineUtils.deleteBuildDataDir(Utils.getWorkspace(build.getParent()), String.valueOf(build.getNumber()), logger);
        }
    }

    public void report(JobStatusPayload payload, Log logger) throws IOException {
        try (JFrogPipelinesHttpClient client = this.createHttpClient(logger);
             CloseableHttpResponse response = client.sendStatus(payload);){
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() != 200) {
                logger.error("Failed to report status to JFrog Pipelines: Received: " + response.getStatusLine());
                return;
            }
        }
        logger.info("Successfully reported status '" + payload.getStatus() + "' to JFrog Pipelines.");
    }

    private static JFrogPipelinesServer getAndVerifyServer() throws IOException {
        JFrogPipelinesServer pipelinesServer = Utils.getPipelinesServer();
        if (Utils.isNotConfigured(pipelinesServer)) {
            throw new IOException(SERVER_NOT_FOUND_EXCEPTION);
        }
        return pipelinesServer;
    }
}

