/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.maven2;

import hudson.EnvVars;
import hudson.Util;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.reporters.MavenArtifact;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.hudson.ArtifactoryRedeployPublisher;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.MavenVersionHelper;

public class ArtifactsDeployer {
    private static final String HIGHEST_VERSION_BEFORE_ARCHIVE_FIX = "1.404";
    private static final String SHA1 = "SHA1";
    private static Logger debuggingLogger = Logger.getLogger(ArtifactsDeployer.class.getName());
    private final ArtifactoryServer artifactoryServer;
    private final String targetReleasesRepository;
    private final String targetSnapshotsRepository;
    private final ArtifactoryManager artifactoryManager;
    private final MavenModuleSetBuild mavenModuleSetBuild;
    private final BuildListener listener;
    private final IncludeExcludePatterns patterns;
    private final boolean downstreamIdentifier;
    private final boolean isArchiveJenkinsVersion;
    private final EnvVars env;
    private final String[] deploymentProperties;
    private final AbstractBuild<?, ?> rootBuild;

    public ArtifactsDeployer(ArtifactoryRedeployPublisher artifactoryPublisher, ArtifactoryManager artifactoryManager, MavenModuleSetBuild mavenModuleSetBuild, BuildListener listener) throws IOException, InterruptedException {
        this.artifactoryManager = artifactoryManager;
        this.mavenModuleSetBuild = mavenModuleSetBuild;
        this.listener = listener;
        this.env = mavenModuleSetBuild.getEnvironment((TaskListener)listener);
        this.artifactoryServer = artifactoryPublisher.getArtifactoryServer();
        ReleaseAction releaseAction = ActionableHelper.getLatestAction((Run)mavenModuleSetBuild, ReleaseAction.class);
        if (releaseAction != null) {
            String stagingRepoKey = releaseAction.getStagingRepositoryKey();
            if (StringUtils.isBlank((CharSequence)stagingRepoKey)) {
                stagingRepoKey = Util.replaceMacro((String)artifactoryPublisher.getRepositoryKey(), (Map)this.env);
            }
            this.targetReleasesRepository = stagingRepoKey;
        } else {
            this.targetReleasesRepository = Util.replaceMacro((String)artifactoryPublisher.getRepositoryKey(), (Map)this.env);
        }
        this.targetSnapshotsRepository = Util.replaceMacro((String)artifactoryPublisher.getSnapshotsRepositoryKey(), (Map)this.env);
        this.downstreamIdentifier = artifactoryPublisher.isPassIdentifiedDownstream();
        IncludesExcludes patterns = artifactoryPublisher.getArtifactDeploymentPatterns();
        this.patterns = patterns != null ? new IncludeExcludePatterns(Util.replaceMacro((String)patterns.getIncludePatterns(), (Map)this.env), Util.replaceMacro((String)patterns.getExcludePatterns(), (Map)this.env)) : IncludeExcludePatterns.EMPTY;
        this.deploymentProperties = StringUtils.split((String)Util.replaceMacro((String)artifactoryPublisher.getDeploymentProperties(), (Map)this.env), (String)"; ");
        debuggingLogger.fine("Getting root build");
        this.rootBuild = BuildUniqueIdentifierHelper.getRootBuild(mavenModuleSetBuild);
        this.isArchiveJenkinsVersion = Hudson.getVersion().isNewerThan(new VersionNumber(HIGHEST_VERSION_BEFORE_ARCHIVE_FIX));
    }

    public void deploy() throws IOException, InterruptedException, NoSuchAlgorithmException {
        this.listener.getLogger().println("Deploying artifacts to " + this.artifactoryServer.getArtifactoryUrl());
        Map mavenBuildMap = this.mavenModuleSetBuild.getModuleLastBuilds();
        for (Map.Entry mavenBuildEntry : mavenBuildMap.entrySet()) {
            MavenBuild mavenBuild = (MavenBuild)mavenBuildEntry.getValue();
            Result result = mavenBuild.getResult();
            if (Result.NOT_BUILT.equals(result)) {
                this.listener.getLogger().println("Module: '" + ((MavenModule)mavenBuildEntry.getKey()).getName() + "' wasn't built. Skipping.");
                continue;
            }
            this.listener.getLogger().println("Deploying artifacts of module: " + ((MavenModule)mavenBuildEntry.getKey()).getName());
            MavenArtifactRecord mar = ActionableHelper.getLatestMavenArtifactRecord(mavenBuild);
            MavenArtifact mavenArtifact = mar.mainArtifact;
            debuggingLogger.fine("Deploying main artifact: " + this.artifactToString(mavenArtifact, mavenBuild));
            this.deployArtifact(mavenBuild, mavenArtifact);
            if (!mar.isPOM() && mar.pomArtifact != null && mar.pomArtifact != mar.mainArtifact) {
                debuggingLogger.fine("Deploying pom artifact: " + this.artifactToString(mavenArtifact, mavenBuild));
                this.deployArtifact(mavenBuild, mar.pomArtifact);
            }
            for (MavenArtifact attachedArtifact : mar.attachedArtifacts) {
                debuggingLogger.fine("Deploying attached artifact: " + this.artifactToString(mavenArtifact, mavenBuild));
                this.deployArtifact(mavenBuild, attachedArtifact);
            }
        }
    }

    private String artifactToString(MavenArtifact mavenArtifact, MavenBuild mavenBuild) throws IOException {
        return ToStringBuilder.reflectionToString((Object)mavenArtifact) + "[File: " + this.getArtifactFile(mavenBuild, mavenArtifact) + "]";
    }

    private void deployArtifact(MavenBuild mavenBuild, MavenArtifact mavenArtifact) throws IOException, InterruptedException, NoSuchAlgorithmException {
        String branch;
        String url;
        String revision;
        String upstreamProject;
        String artifactPath = this.buildArtifactPath(mavenArtifact);
        if (PatternMatcher.pathConflicts((String)artifactPath, (IncludeExcludePatterns)this.patterns)) {
            this.listener.getLogger().println("Skipping the deployment of '" + artifactPath + "' due to the defined include-exclude patterns.");
            return;
        }
        File artifactFile = this.getArtifactFile(mavenBuild, mavenArtifact);
        Map checksums = FileChecksumCalculator.calculateChecksums((File)artifactFile, (String[])new String[]{SHA1});
        DeployDetails.Builder builder = new DeployDetails.Builder().file(artifactFile).artifactPath(artifactPath).targetRepository(this.getTargetRepository(mavenArtifact.version)).md5(mavenArtifact.md5sum).sha1((String)checksums.get(SHA1)).addProperty("build.name", ExtractorUtils.sanitizeBuildName(this.mavenModuleSetBuild.getParent().getFullName())).addProperty("build.number", this.mavenModuleSetBuild.getNumber() + "").addProperty("build.timestamp", mavenBuild.getTimestamp().getTime().getTime() + "").packageType(DeployDetails.PackageType.MAVEN);
        String identifier = BuildUniqueIdentifierHelper.getUpstreamIdentifier(this.rootBuild);
        if (StringUtils.isNotBlank((CharSequence)identifier)) {
            builder.addProperty("build.root", identifier);
        }
        if (StringUtils.isNotBlank((CharSequence)(upstreamProject = ActionableHelper.getUpstreamProject((Run)this.mavenModuleSetBuild)))) {
            builder.addProperty("build.parentName", ExtractorUtils.sanitizeBuildName(upstreamProject));
            Integer upstreamBuild = ActionableHelper.getUpstreamBuild((Run)this.mavenModuleSetBuild);
            if (upstreamBuild != null) {
                builder.addProperty("build.parentNumber", upstreamBuild + "");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(revision = ExtractorUtils.getVcsRevision((Map<String, String>)this.env)))) {
            builder.addProperty("vcs.revision", revision);
        }
        if (StringUtils.isNotBlank((CharSequence)(url = ExtractorUtils.getVcsUrl((Map<String, String>)this.env)))) {
            builder.addProperty("vcs.url", url);
        }
        if (StringUtils.isNotBlank((CharSequence)(branch = ExtractorUtils.getVcsBranch((Map<String, String>)this.env)))) {
            builder.addProperty("vcs.branch", branch);
        }
        String message = ExtractorUtils.getVcsMessage((Map<String, String>)this.env);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            builder.addProperty("vcs.message", message);
        }
        this.addDeploymentProperties(builder);
        DeployDetails deployDetails = builder.build();
        this.logDeploymentPath(deployDetails, artifactPath);
        this.artifactoryManager.upload(deployDetails);
    }

    private void addDeploymentProperties(DeployDetails.Builder builder) {
        if (this.deploymentProperties == null) {
            return;
        }
        for (String property : this.deploymentProperties) {
            String[] split = StringUtils.split((String)property, (char)'=');
            if (split.length != 2) continue;
            String value = split[1];
            builder.addProperty(split[0], value);
        }
    }

    private void logDeploymentPath(DeployDetails deployDetails, String artifactPath) {
        String deploymentPath = this.artifactoryServer.getArtifactoryUrl() + "/" + deployDetails.getTargetRepository() + "/" + artifactPath;
        this.listener.getLogger().println("Deploying artifact: " + deploymentPath);
    }

    public String getTargetRepository(String version) {
        if (this.targetSnapshotsRepository != null && version.endsWith("SNAPSHOT")) {
            return this.targetSnapshotsRepository;
        }
        return this.targetReleasesRepository;
    }

    private String buildArtifactPath(MavenArtifact mavenArtifact) {
        String directoryPath = mavenArtifact.groupId.replace('.', '/') + "/" + mavenArtifact.artifactId + "/" + mavenArtifact.version;
        return directoryPath + "/" + mavenArtifact.canonicalName;
    }

    private File getArtifactFile(MavenBuild build, MavenArtifact mavenArtifact) throws IOException {
        File file;
        String fileName = mavenArtifact.fileName;
        if (this.isArchiveJenkinsVersion) {
            fileName = mavenArtifact.canonicalName;
        }
        if (!(file = new File(new File(new File(new File(build.getArtifactsDir(), mavenArtifact.groupId), mavenArtifact.artifactId), mavenArtifact.version), fileName)).exists()) {
            throw new FileNotFoundException("Archived artifact is missing: " + file + " " + this.getAdditionalMessage());
        }
        return file;
    }

    private String getAdditionalMessage() throws IOException {
        try {
            if (MavenVersionHelper.isLowerThanMaven3(this.mavenModuleSetBuild, this.env, this.listener)) {
                return "\nDisabling the automatic archiving and using the external Maven extractor is compatible with Maven 3.0.2 and up";
            }
            return "";
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to determine Maven version", e);
        }
    }
}

