/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.maven2;

import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.reporters.MavenArtifact;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Fingerprinter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jfrog.build.extractor.builder.ArtifactBuilder;
import org.jfrog.build.extractor.builder.DependencyBuilder;
import org.jfrog.build.extractor.builder.ModuleBuilder;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.hudson.AbstractBuildInfoDeployer;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.JFrogPlatformInstance;
import org.jfrog.hudson.MavenDependenciesRecord;
import org.jfrog.hudson.MavenDependency;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.util.RepositoriesUtils;

public class MavenBuildInfoDeployer
extends AbstractBuildInfoDeployer {
    private final BuildInfo buildInfo;
    private BuildInfoAwareConfigurator configurator;

    public MavenBuildInfoDeployer(BuildInfoAwareConfigurator configurator, ArtifactoryManager artifactoryManager, MavenModuleSetBuild build, TaskListener listener) throws IOException, InterruptedException {
        super(configurator, (Run)build, listener, artifactoryManager);
        this.configurator = configurator;
        this.buildInfo = this.createBuildInfo("Maven", build.getParent().getMaven().getName());
        this.gatherModuleAndDependencyInfo(build);
    }

    public void deploy() throws IOException {
        JFrogPlatformInstance jfrogServer = RepositoriesUtils.getJFrogPlatformInstances(this.configurator.getArtifactoryServer().getServerId());
        this.listener.getLogger().println("Deploying build info to: " + jfrogServer.getArtifactory().getArtifactoryUrl() + "/api/build");
        this.artifactoryManager.publishBuildInfo(this.buildInfo, jfrogServer.getUrl());
    }

    private void gatherModuleAndDependencyInfo(MavenModuleSetBuild mavenModulesBuild) {
        Map mavenBuildMap = mavenModulesBuild.getModuleLastBuilds();
        CopyOnWriteArrayList<Module> modules = new CopyOnWriteArrayList<Module>();
        for (Map.Entry moduleBuild : mavenBuildMap.entrySet()) {
            MavenModule mavenModule = (MavenModule)moduleBuild.getKey();
            MavenBuild mavenBuild = (MavenBuild)moduleBuild.getValue();
            Result result = mavenBuild.getResult();
            if (Result.NOT_BUILT.equals(result)) continue;
            MavenArtifactRecord mar = ActionableHelper.getLatestMavenArtifactRecord(mavenBuild);
            String moduleId = mavenModule.getName() + ":" + mavenModule.getVersion();
            ModuleBuilder moduleBuilder = new ModuleBuilder().id(moduleId);
            moduleBuilder.addArtifact(this.toArtifact(mar.mainArtifact));
            if (!mar.isPOM() && mar.pomArtifact != null && mar.pomArtifact != mar.mainArtifact) {
                moduleBuilder.addArtifact(this.toArtifact(mar.pomArtifact));
            }
            for (MavenArtifact attachedArtifact : mar.attachedArtifacts) {
                moduleBuilder.addArtifact(this.toArtifact(attachedArtifact));
            }
            this.addDependencies(moduleBuilder, mavenBuild);
            modules.add(moduleBuilder.build());
        }
        this.buildInfo.setModules(modules);
    }

    private void addDependencies(ModuleBuilder moduleBuilder, MavenBuild mavenBuild) {
        MavenDependenciesRecord dependenciesRecord = ActionableHelper.getLatestAction((Run)mavenBuild, MavenDependenciesRecord.class);
        if (dependenciesRecord != null) {
            Set<MavenDependency> dependencies = dependenciesRecord.getDependencies();
            for (MavenDependency dependency : dependencies) {
                HashSet<String> scopes = new HashSet<String>();
                scopes.add(dependency.getScope());
                DependencyBuilder dependencyBuilder = new DependencyBuilder().id(dependency.getId()).scopes(scopes).type(dependency.getType()).md5(this.getMd5(dependency.getGroupId(), dependency.getFileName(), mavenBuild));
                moduleBuilder.addDependency(dependencyBuilder.build());
            }
            this.build.removeActions(MavenDependenciesRecord.class);
        }
    }

    private Artifact toArtifact(MavenArtifact mavenArtifact) {
        ArtifactBuilder artifactBuilder = new ArtifactBuilder(mavenArtifact.canonicalName).type(mavenArtifact.type).md5(mavenArtifact.md5sum);
        return artifactBuilder.build();
    }

    private String getMd5(String groupId, String fileName, MavenBuild mavenBuild) {
        String md5 = null;
        Fingerprinter.FingerprintAction fingerprint = ActionableHelper.getLatestAction((Run)mavenBuild, Fingerprinter.FingerprintAction.class);
        if (fingerprint != null) {
            md5 = (String)fingerprint.getRecords().get(groupId + ":" + fileName);
        }
        return md5;
    }
}

