/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.maven3;

import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.hudson.AbstractBuildWrapperDescriptor;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.BuildInfoResultAction;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.MultiConfigurationAware;
import org.jfrog.hudson.Repository;
import org.jfrog.hudson.ResolutionRepository;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.RefreshServerResponse;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.ResolverContext;
import org.jfrog.hudson.util.converters.DeployerResolverOverriderConverter;
import org.jfrog.hudson.util.plugins.MultiConfigurationUtils;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.jfrog.hudson.util.publisher.PublisherContext;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ArtifactoryMaven3Configurator
extends BuildWrapper
implements DeployerOverrider,
ResolverOverrider,
BuildInfoAwareConfigurator,
MultiConfigurationAware {
    private final ServerDetails deployerDetails;
    private final ServerDetails resolverDetails;
    private CredentialsConfig deployerCredentialsConfig;
    private CredentialsConfig resolverCredentialsConfig;
    private boolean deployArtifacts;
    private IncludesExcludes artifactDeploymentPatterns;
    private boolean includeEnvVars;
    private boolean deployBuildInfo;
    private boolean discardOldBuilds;
    private boolean discardBuildArtifacts;
    private boolean asyncBuildRetention;
    private String deploymentProperties;
    private boolean enableIssueTrackerIntegration;
    private boolean filterExcludedArtifactsFromBuild;
    private boolean enableResolveArtifacts;
    private IncludesExcludes envVarsPatterns;
    private boolean aggregateBuildIssues;
    private String aggregationBuildStatus;
    private boolean recordAllDependencies;
    private String artifactoryCombinationFilter;
    private String customBuildName;
    private boolean overrideBuildName;
    @Deprecated
    private Credentials overridingDeployerCredentials;
    @Deprecated
    private Credentials overridingResolverCredentials;
    @Deprecated
    private ServerDetails details = null;
    @Deprecated
    private final String matrixParams;
    private String project;

    @DataBoundConstructor
    public ArtifactoryMaven3Configurator(ServerDetails details, ServerDetails deployerDetails, ServerDetails resolverDetails, CredentialsConfig deployerCredentialsConfig, CredentialsConfig resolverCredentialsConfig, boolean enableResolveArtifacts, IncludesExcludes artifactDeploymentPatterns, boolean deployArtifacts, boolean deployBuildInfo, boolean includeEnvVars, IncludesExcludes envVarsPatterns, boolean discardOldBuilds, boolean discardBuildArtifacts, boolean asyncBuildRetention, String matrixParams, String deploymentProperties, boolean enableIssueTrackerIntegration, boolean aggregateBuildIssues, String aggregationBuildStatus, boolean recordAllDependencies, boolean filterExcludedArtifactsFromBuild, String customBuildName, String project, boolean overrideBuildName, String artifactoryCombinationFilter) {
        this.matrixParams = null;
        this.deployerDetails = deployerDetails;
        this.resolverDetails = resolverDetails;
        this.deployerCredentialsConfig = deployerCredentialsConfig;
        this.resolverCredentialsConfig = resolverCredentialsConfig;
        this.artifactDeploymentPatterns = artifactDeploymentPatterns;
        this.envVarsPatterns = envVarsPatterns;
        this.discardOldBuilds = discardOldBuilds;
        this.discardBuildArtifacts = discardBuildArtifacts;
        this.asyncBuildRetention = asyncBuildRetention;
        this.deploymentProperties = deploymentProperties;
        this.enableIssueTrackerIntegration = enableIssueTrackerIntegration;
        this.aggregateBuildIssues = aggregateBuildIssues;
        this.aggregationBuildStatus = aggregationBuildStatus;
        this.recordAllDependencies = recordAllDependencies;
        this.filterExcludedArtifactsFromBuild = filterExcludedArtifactsFromBuild;
        this.deployBuildInfo = deployBuildInfo;
        this.deployArtifacts = deployArtifacts;
        this.includeEnvVars = includeEnvVars;
        this.artifactoryCombinationFilter = artifactoryCombinationFilter;
        this.enableResolveArtifacts = enableResolveArtifacts;
        this.customBuildName = customBuildName;
        this.overrideBuildName = overrideBuildName;
        this.project = project;
    }

    public ArtifactoryMaven3Configurator(ServerDetails details, ServerDetails deployerDetails, ServerDetails resolverDetails) {
        this.matrixParams = null;
        this.details = details;
        this.deployerDetails = deployerDetails;
        this.resolverDetails = resolverDetails;
    }

    public ServerDetails getDeployerDetails() {
        return this.deployerDetails;
    }

    public ServerDetails getResolverDetails() {
        return this.resolverDetails;
    }

    public String getDownloadReleaseRepositoryKey() {
        return this.resolverDetails != null ? this.resolverDetails.getResolveReleaseRepositoryKey() : null;
    }

    public String getDownloadSnapshotRepositoryKey() {
        return this.resolverDetails != null ? this.resolverDetails.getResolveReleaseRepositoryKey() : null;
    }

    @Override
    public boolean isDiscardOldBuilds() {
        return this.discardOldBuilds;
    }

    @Override
    public boolean isDiscardBuildArtifacts() {
        return this.discardBuildArtifacts;
    }

    @Override
    public boolean isAsyncBuildRetention() {
        return this.asyncBuildRetention;
    }

    @Override
    public boolean isOverridingDefaultDeployer() {
        return this.deployerCredentialsConfig != null && this.deployerCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public Credentials getOverridingDeployerCredentials() {
        return this.overridingDeployerCredentials;
    }

    @Override
    public CredentialsConfig getDeployerCredentialsConfig() {
        return this.deployerCredentialsConfig;
    }

    @Override
    public boolean isOverridingDefaultResolver() {
        return this.resolverCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public Credentials getOverridingResolverCredentials() {
        return this.overridingResolverCredentials;
    }

    @Override
    public CredentialsConfig getResolverCredentialsConfig() {
        return this.resolverCredentialsConfig;
    }

    public boolean isOverridingResolverCredentials() {
        return this.resolverCredentialsConfig.isCredentialsProvided();
    }

    public boolean isDeployArtifacts() {
        return this.deployArtifacts;
    }

    public String getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public IncludesExcludes getArtifactDeploymentPatterns() {
        return this.artifactDeploymentPatterns;
    }

    public boolean isDeployBuildInfo() {
        return this.deployBuildInfo;
    }

    @Override
    public String getCustomBuildName() {
        return this.customBuildName;
    }

    @Override
    public boolean isOverrideBuildName() {
        return this.overrideBuildName;
    }

    public String getProject() {
        return this.project;
    }

    public boolean isRecordAllDependencies() {
        return this.recordAllDependencies;
    }

    @Override
    public ArtifactoryServer getArtifactoryServer() {
        return RepositoriesUtils.getArtifactoryServer(this.getArtifactoryName());
    }

    @Override
    public String getRepositoryKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getDeployReleaseRepositoryKey() : null;
    }

    @Override
    public String getDefaultPromotionTargetRepository() {
        return null;
    }

    public String getSnapshotsRepositoryKey() {
        return this.getDeployerDetails() != null ? (this.getDeployerDetails().getDeploySnapshotRepository() != null ? this.getDeployerDetails().getDeploySnapshotRepository().getRepoKey() : this.getDeployerDetails().getDeployReleaseRepository().getRepoKey()) : null;
    }

    public String getArtifactoryName() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().artifactoryName : null;
    }

    public String getArtifactoryUrl() {
        ArtifactoryServer server = this.getArtifactoryServer();
        return server != null ? server.getArtifactoryUrl() : null;
    }

    @Override
    public boolean isIncludeEnvVars() {
        return this.includeEnvVars;
    }

    @Override
    public IncludesExcludes getEnvVarsPatterns() {
        return this.envVarsPatterns;
    }

    @Override
    public boolean isEnableIssueTrackerIntegration() {
        return this.enableIssueTrackerIntegration;
    }

    @Override
    public boolean isAggregateBuildIssues() {
        return this.aggregateBuildIssues;
    }

    public boolean isEnableResolveArtifacts() {
        return this.enableResolveArtifacts;
    }

    @Override
    public String getAggregationBuildStatus() {
        return this.aggregationBuildStatus;
    }

    public boolean isFilterExcludedArtifactsFromBuild() {
        return this.filterExcludedArtifactsFromBuild;
    }

    @Override
    public String getArtifactoryCombinationFilter() {
        return this.artifactoryCombinationFilter;
    }

    @Override
    public boolean isMultiConfProject() {
        return this.getDescriptor().isMultiConfProject();
    }

    public ArtifactoryServer getArtifactoryServer(String artifactoryServerName) {
        return RepositoriesUtils.getArtifactoryServer(artifactoryServerName);
    }

    public List<Repository> getReleaseRepositoryList() {
        return RepositoriesUtils.collectRepositories(this.getDeployerDetails().getDeployReleaseRepository().getKeyFromSelect());
    }

    public List<Repository> getSnapshotRepositoryList() {
        return RepositoriesUtils.collectRepositories(this.getDeployerDetails().getDeploySnapshotRepository().getKeyFromSelect());
    }

    public List<ResolutionRepository> getResolveReleaseRepositoryList() {
        return RepositoriesUtils.collectResolutionRepositories(null, this.resolverDetails.getResolveReleaseRepository().getKeyFromSelect());
    }

    public List<ResolutionRepository> getResolveSnapshotRepositoryList() {
        return RepositoriesUtils.collectResolutionRepositories(null, this.resolverDetails.getResolveSnapshotRepository().getKeyFromSelect());
    }

    public Collection<? extends Action> getProjectActions(AbstractProject project) {
        if (this.isOverrideBuildName()) {
            return ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project, this.getCustomBuildName());
        }
        return ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project);
    }

    public BuildWrapper.Environment setUp(final AbstractBuild build, final Launcher launcher, final BuildListener listener) throws IOException, InterruptedException {
        String artifactoryServerName = this.getArtifactoryName();
        if (StringUtils.isBlank((CharSequence)artifactoryServerName)) {
            return super.setUp(build, launcher, listener);
        }
        ArtifactoryServer artifactoryServer = this.getArtifactoryServer(artifactoryServerName);
        if (artifactoryServer == null) {
            listener.getLogger().format("No Artifactory server configured for %s. Please check your configuration.", artifactoryServerName).println();
            throw new IllegalArgumentException("No Artifactory server configured for " + artifactoryServerName);
        }
        PublisherContext.Builder publisherBuilder = new PublisherContext.Builder().artifactoryServer(artifactoryServer).serverDetails(this.getDeployerDetails()).deployerOverrider(this).discardOldBuilds(this.isDiscardOldBuilds()).deployArtifacts(this.isDeployArtifacts()).includesExcludes(this.getArtifactDeploymentPatterns()).skipBuildInfoDeploy(!this.deployBuildInfo).recordAllDependencies(this.isRecordAllDependencies()).includeEnvVars(this.isIncludeEnvVars()).envVarsPatterns(this.getEnvVarsPatterns()).discardBuildArtifacts(this.isDiscardBuildArtifacts()).asyncBuildRetention(this.isAsyncBuildRetention()).deploymentProperties(this.getDeploymentProperties()).enableIssueTrackerIntegration(this.isEnableIssueTrackerIntegration()).aggregateBuildIssues(this.isAggregateBuildIssues()).aggregationBuildStatus(this.getAggregationBuildStatus()).filterExcludedArtifactsFromBuild(this.isFilterExcludedArtifactsFromBuild()).artifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion()).overrideBuildName(this.isOverrideBuildName()).customBuildName(this.getCustomBuildName()).project(this.getProject());
        if (this.isMultiConfProject(build) && this.isDeployArtifacts()) {
            if (StringUtils.isBlank((CharSequence)this.getArtifactoryCombinationFilter())) {
                String error = "The field \"Combination Matches\" is empty, but is defined as mandatory!";
                listener.getLogger().println(error);
                throw new IllegalArgumentException(error);
            }
            boolean isFiltered = MultiConfigurationUtils.isfiltrated(build, this.getArtifactoryCombinationFilter());
            if (isFiltered) {
                publisherBuilder.skipBuildInfoDeploy(true).deployArtifacts(false);
            }
        }
        ResolverContext resolver = null;
        if (this.isEnableResolveArtifacts()) {
            CredentialsConfig credentialResolver = CredentialManager.getPreferredResolver(this, this.getArtifactoryServer());
            resolver = new ResolverContext(this.getArtifactoryServer(), this.getResolverDetails(), credentialResolver.provideCredentials((Item)build.getProject()), this);
        }
        final ResolverContext resolverContext = resolver;
        final PublisherContext publisherContext = publisherBuilder.build();
        build.setResult(Result.SUCCESS);
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                try {
                    ExtractorUtils.addBuilderInfoArguments(env, (Run)build, (TaskListener)listener, publisherContext, resolverContext, build.getWorkspace(), launcher, false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public boolean tearDown(AbstractBuild build2, BuildListener listener2) {
                Result result = build2.getResult();
                if (ArtifactoryMaven3Configurator.this.deployBuildInfo && result != null && result.isBetterOrEqualTo(Result.SUCCESS)) {
                    String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(ArtifactoryMaven3Configurator.this, (Run)build2);
                    build2.addAction((Action)new BuildInfoResultAction(ArtifactoryMaven3Configurator.this.getArtifactoryUrl(), (Run)build2, buildName, ArtifactoryMaven3Configurator.this.project));
                    build2.addAction((Action)new UnifiedPromoteBuildAction((Run<?, ?>)build2, ArtifactoryMaven3Configurator.this, ArtifactoryMaven3Configurator.this.project));
                }
                return true;
            }
        };
    }

    private boolean isMultiConfProject(AbstractBuild build) {
        return build.getProject().getClass().equals(MatrixConfiguration.class);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static final class ConverterImpl
    extends DeployerResolverOverriderConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractBuildWrapperDescriptor {
        private static final String DISPLAY_NAME = "Maven3-Artifactory Integration";
        private static final String CONFIG_PREFIX = "maven3";

        public DescriptorImpl() {
            super(ArtifactoryMaven3Configurator.class, DISPLAY_NAME, CONFIG_PREFIX);
            this.load();
        }

        @JavaScriptMethod
        public RefreshServerResponse refreshFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
            return super.refreshDeployersFromArtifactory(url, credentialsId, username, password, overrideCredentials, false);
        }

        @Override
        @JavaScriptMethod
        public RefreshServerResponse refreshResolversFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
            return super.refreshResolversFromArtifactory(url, credentialsId, username, password, overrideCredentials);
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            return PluginsUtils.fillPluginProjectCredentials(project);
        }
    }
}

