/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.maven3;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jfrog.hudson.AbstractBuildWrapperDescriptor;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.JFrogPlatformInstance;
import org.jfrog.hudson.ResolutionRepository;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.MavenVersionHelper;
import org.jfrog.hudson.util.RefreshServerResponse;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.converters.DeployerResolverOverriderConverter;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ArtifactoryMaven3NativeConfigurator
extends BuildWrapper
implements ResolverOverrider {
    private final ServerDetails resolverDetails;
    @Deprecated
    private Credentials overridingResolverCredentials;
    private CredentialsConfig resolverCredentialsConfig;
    @Deprecated
    private ServerDetails details = null;

    @DataBoundConstructor
    public ArtifactoryMaven3NativeConfigurator(ServerDetails details, ServerDetails resolverDetails, CredentialsConfig resolverCredentialsConfig) {
        this.resolverDetails = resolverDetails;
        this.resolverCredentialsConfig = resolverCredentialsConfig;
    }

    public ArtifactoryMaven3NativeConfigurator(ServerDetails details, ServerDetails resolverDetails) {
        this.details = details;
        this.resolverDetails = resolverDetails;
    }

    public ServerDetails getDeployerDetails() {
        return this.getResolverDetails();
    }

    public ServerDetails getResolverDetails() {
        return this.resolverDetails;
    }

    public String getDownloadReleaseRepositoryKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getResolveReleaseRepository().getRepoKey() : null;
    }

    public String getDownloadSnapshotRepositoryKey() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().getResolveSnapshotRepositoryKey() : null;
    }

    public String getArtifactoryName() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().artifactoryName : null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject project) {
        return Collections.emptyList();
    }

    @Override
    public boolean isOverridingDefaultResolver() {
        return this.resolverCredentialsConfig != null && this.resolverCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public Credentials getOverridingResolverCredentials() {
        return this.overridingResolverCredentials;
    }

    @Override
    public CredentialsConfig getResolverCredentialsConfig() {
        return this.resolverCredentialsConfig;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (!(build instanceof MavenModuleSetBuild)) {
            return new BuildWrapper.Environment(){};
        }
        PrintStream log = listener.getLogger();
        log.println("Jenkins Artifactory Plugin version: " + ActionableHelper.getArtifactoryPluginVersion());
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        boolean supportedMavenVersion = MavenVersionHelper.isAtLeastResolutionCapableVersion((MavenModuleSetBuild)build, envVars, (TaskListener)listener);
        if (!supportedMavenVersion) {
            log.println("Artifactory resolution is not active. Maven 3.0.2 or higher is required to force resolution from Artifactory.");
            return new BuildWrapper.Environment(){};
        }
        return new BuildWrapper.Environment(){};
    }

    public ArtifactoryServer getArtifactoryServer() {
        List<JFrogPlatformInstance> jfrogInstances = this.getDescriptor().getJfrogInstances();
        for (JFrogPlatformInstance JFrogPlatformInstance2 : jfrogInstances) {
            if (!JFrogPlatformInstance2.getId().equals(this.getArtifactoryName())) continue;
            return JFrogPlatformInstance2.getArtifactory();
        }
        return null;
    }

    public List<ResolutionRepository> getVirtualRepositoryList() {
        String releaseRepoKey = this.getDeployerDetails().getResolveReleaseRepository().getKeyFromSelect();
        String snapshotRepoKey = this.getDeployerDetails().getResolveSnapshotRepository().getKeyFromSelect();
        List<ResolutionRepository> repos = RepositoriesUtils.collectResolutionRepositories(null, releaseRepoKey);
        return RepositoriesUtils.collectResolutionRepositories(repos, snapshotRepoKey);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private boolean isExtractorUsed(EnvVars env) {
        return Boolean.parseBoolean((String)env.get((Object)"extractor.used"));
    }

    public static final class ConverterImpl
    extends DeployerResolverOverriderConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractBuildWrapperDescriptor {
        private static final String DISPLAY_NAME = "Resolve artifacts from Artifactory";
        private static final String CONFIG_PREFIX = "maven";

        public DescriptorImpl() {
            super(ArtifactoryMaven3NativeConfigurator.class, DISPLAY_NAME, CONFIG_PREFIX);
        }

        @Override
        public boolean isApplicable(AbstractProject<?, ?> item) {
            this.item = item;
            Class<?> itemClass = item.getClass();
            return MavenModuleSet.class.equals(itemClass) || "PromotionProcess".equals(itemClass.getSimpleName());
        }

        @Override
        @JavaScriptMethod
        public RefreshServerResponse refreshResolversFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
            return super.refreshResolversFromArtifactory(url, credentialsId, username, password, overrideCredentials);
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            return PluginsUtils.fillPluginProjectCredentials(project);
        }

        public String getHelpFile() {
            return "/plugin/artifactory/help/ArtifactoryMaven3NativeConfigurator/help.html";
        }
    }
}

