/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.maven3;

import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Maven;
import hudson.util.ArgumentListBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.maven3.Messages;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.util.PluginDependencyHelper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class Maven3Builder
extends Builder {
    public static final String CLASSWORLDS_LAUNCHER = "org.codehaus.plexus.classworlds.launcher.Launcher";
    public static final String MAVEN_HOME_PREFIX_IN_VERSION = "Maven home:";
    public static final String MAVEN_HOME = "MAVEN_HOME";
    private final String mavenName;
    private final String rootPom;
    private final String goals;
    private final String mavenOpts;
    private final boolean useWrapper;
    private String classworldsConfPath;

    @DataBoundConstructor
    public Maven3Builder(String mavenName, String rootPom, String goals, String mavenOpts, boolean useWrapper) {
        this.mavenName = mavenName;
        this.rootPom = rootPom;
        this.goals = goals;
        this.mavenOpts = mavenOpts;
        this.useWrapper = useWrapper;
    }

    public String getMavenName() {
        return this.mavenName;
    }

    public String getRootPom() {
        return this.rootPom;
    }

    public String getGoals() {
        return this.goals;
    }

    public String getMavenOpts() {
        return this.mavenOpts;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Jenkins Artifactory Plugin version: " + ActionableHelper.getArtifactoryPluginVersion());
        EnvVars env = build.getEnvironment((TaskListener)listener);
        FilePath workDir = build.getModuleRoot();
        FilePath ws = build.getWorkspace();
        FilePath mavenHome = this.getMavenHome((TaskListener)listener, env, launcher, ws);
        if (!mavenHome.exists()) {
            listener.error("Couldn't find Maven home: " + mavenHome.getRemote());
            throw new Run.RunnerAbortedException();
        }
        ArgumentListBuilder args = this.buildMavenCmdLine((Run<?, ?>)build, (TaskListener)listener, env, launcher, mavenHome, ws, ws);
        this.RunMaven(launcher, (TaskListener)listener, env, workDir, args);
        return true;
    }

    public void perform(Run<?, ?> build, Launcher launcher, TaskListener listener, EnvVars env, FilePath workDir, FilePath tempDir) throws InterruptedException, IOException {
        listener.getLogger().println("Jenkins Artifactory Plugin version: " + ActionableHelper.getArtifactoryPluginVersion());
        FilePath mavenHome = this.getMavenHome(listener, env, launcher, workDir);
        if (!mavenHome.exists()) {
            listener.getLogger().println("Couldn't find Maven home at " + mavenHome.getRemote() + " on agent " + Utils.getAgentName(workDir) + ". This could be because this build is running inside a Docker container.");
        }
        ArgumentListBuilder args = this.buildMavenCmdLine(build, listener, env, launcher, mavenHome, workDir, tempDir);
        this.RunMaven(launcher, listener, env, workDir, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void RunMaven(Launcher launcher, TaskListener listener, EnvVars env, FilePath workDir, ArgumentListBuilder args) throws IOException {
        try {
            Utils.launch("Maven", launcher, args, env, listener, workDir);
        }
        finally {
            ActionableHelper.deleteFilePath(workDir, this.classworldsConfPath);
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private ArgumentListBuilder buildMavenCmdLine(Run<?, ?> build, TaskListener listener, EnvVars env, Launcher launcher, FilePath mavenHome, FilePath ws, FilePath tempDir) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(Utils.getJavaPathBuilder((String)env.get((Object)"PATH+JDK"), launcher));
        String fileSeparator = this.getFileSeparator(launcher);
        Object[] pathsToJoin = new String[]{mavenHome.getRemote(), "boot", "*"};
        args.add(new String[]{"-classpath", StringUtils.join((Object[])pathsToJoin, (String)fileSeparator)});
        args.addKeyValuePair("-D", "maven.home", mavenHome.getRemote(), false);
        FilePath mavenConf = mavenHome.child("conf");
        args.addKeyValuePair("-D", "maven.conf", mavenConf.getRemote(), false);
        String buildInfoPropertiesFile = (String)env.get((Object)"buildInfoConfig.propertiesFile");
        boolean artifactoryIntegration = StringUtils.isNotBlank((CharSequence)buildInfoPropertiesFile);
        listener.getLogger().println("Artifactory integration is " + (artifactoryIntegration ? "enabled" : "disabled"));
        if (artifactoryIntegration) {
            this.addArtifactoryIntegrationArgs(args, buildInfoPropertiesFile, tempDir, env);
            ActionableHelper.deleteFilePathOnExit(tempDir, this.classworldsConfPath);
        } else {
            args.addKeyValuePair("-D", "classworlds.conf", new FilePath(mavenHome, "bin/m2.conf").getRemote(), false);
        }
        args.addKeyValuePair("-D", "maven.multiModuleProjectDirectory", this.getMavenProjectPath(build, ws), false);
        String rootPom = this.getRootPom();
        this.addMavenOpts(args, build, ws);
        args.add(CLASSWORLDS_LAUNCHER);
        if (StringUtils.isNotBlank((CharSequence)rootPom)) {
            args.add(new String[]{"-f", rootPom});
        }
        args.addTokenized(Util.replaceMacro((String)this.getGoals(), (Map)env));
        return args;
    }

    private String getFileSeparator(Launcher launcher) {
        String fileSeparator = "/";
        if (!launcher.isUnix()) {
            fileSeparator = "\\";
        }
        return fileSeparator;
    }

    private void addArtifactoryIntegrationArgs(ArgumentListBuilder args, String buildInfoPropertiesFile, FilePath ws, EnvVars env) throws IOException, InterruptedException {
        args.addKeyValuePair("-D", "buildInfoConfig.propertiesFile", buildInfoPropertiesFile, false);
        if (Boolean.parseBoolean((String)env.get((Object)"buildInfoConfig.artifactoryResolutionEnabled"))) {
            args.addKeyValuePair("-D", "buildInfoConfig.artifactoryResolutionEnabled", Boolean.TRUE.toString(), false);
        }
        File extractorJar = PluginDependencyHelper.getExtractorJar(env);
        FilePath actualDependencyDirectory = PluginDependencyHelper.getActualDependencyDirectory(extractorJar, ws);
        if (this.getMavenOpts() == null || !this.getMavenOpts().contains("-Dm3plugin.lib")) {
            args.addKeyValuePair("-D", "m3plugin.lib", actualDependencyDirectory.getRemote(), false);
        }
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/jfrog/hudson/maven3/classworlds-freestyle.conf");
        this.classworldsConfPath = this.copyClassWorldsFile(ws, resource).getRemote();
        args.addKeyValuePair("-D", "classworlds.conf", this.classworldsConfPath, false);
    }

    private void addMavenOpts(ArgumentListBuilder args, Run<?, ?> build, FilePath ws) throws IOException, InterruptedException {
        FilePath jvmConfig;
        String mavenOpts = this.getMavenOpts();
        FilePath dotMvn = ws.child(this.rootPom).sibling(".mvn");
        if (dotMvn != null && (jvmConfig = dotMvn.child("jvm.config")).exists()) {
            mavenOpts = String.join((CharSequence)" ", mavenOpts, jvmConfig.readToString());
        }
        if (StringUtils.isNotBlank((CharSequence)mavenOpts)) {
            if (build instanceof AbstractBuild) {
                mavenOpts = Util.replaceMacro((String)mavenOpts, (Map)((AbstractBuild)build).getBuildVariables());
            }
            args.addTokenized(mavenOpts);
        }
    }

    private FilePath getMavenHome(TaskListener listener, EnvVars env, Launcher launcher, FilePath ws) throws IOException, InterruptedException {
        String mavenHome = null;
        if (this.useWrapper) {
            mavenHome = this.createAndGetWrapper(launcher, env, listener, ws);
        } else if (StringUtils.isNotEmpty((CharSequence)this.mavenName)) {
            mavenHome = this.getMavenFromTool(launcher, env, listener);
        } else if (env.get((Object)MAVEN_HOME) != null) {
            mavenHome = (String)env.get((Object)MAVEN_HOME);
        }
        if (StringUtils.isBlank((CharSequence)mavenHome)) {
            throw new RuntimeException("Couldn't find maven installation");
        }
        return new FilePath(launcher.getChannel(), mavenHome);
    }

    private String createAndGetWrapper(Launcher launcher, EnvVars env, TaskListener listener, FilePath ws) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            TeeOutputStream printStream = new TeeOutputStream((OutputStream)listener.getLogger(), (OutputStream)os);
            Utils.launch("Maven Wrapper", launcher, this.getMavenWrapperVersionArgs(launcher), env, (TaskListener)new StreamBuildListener((OutputStream)printStream), this.getMavenWrapperPath(ws));
            os.flush();
            String mvnVersionOutput = os.toString(StandardCharsets.UTF_8.name());
            try (BufferedReader reader = new BufferedReader(new StringReader(mvnVersionOutput));){
                String line = reader.readLine();
                while (true) {
                    if (line != null) {
                        if (StringUtils.startsWithIgnoreCase((CharSequence)line, (CharSequence)MAVEN_HOME_PREFIX_IN_VERSION)) {
                            String string = StringUtils.trim((String)StringUtils.removeStartIgnoreCase((String)line, (String)MAVEN_HOME_PREFIX_IN_VERSION));
                            return string;
                        }
                        line = reader.readLine();
                        continue;
                    }
                    break;
                }
            }
        }
        throw new IOException("Failed to detect the Maven home of the Maven wrapper");
    }

    private FilePath getMavenWrapperPath(FilePath ws) {
        if (StringUtils.isNotBlank((CharSequence)this.rootPom)) {
            ws = ws.child(this.rootPom);
            if (StringUtils.endsWith((CharSequence)this.rootPom, (CharSequence)".xml")) {
                ws = ws.getParent();
            }
        }
        return ws;
    }

    private ArgumentListBuilder getMavenWrapperVersionArgs(Launcher launcher) {
        String wrapperExe = launcher.isUnix() ? "./mvnw" : "mvnw.cmd";
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{wrapperExe, "-version"});
        if (!launcher.isUnix()) {
            args = args.toWindowsCommand();
        }
        return args;
    }

    private String getMavenFromTool(Launcher launcher, EnvVars env, TaskListener listener) throws IOException, InterruptedException {
        Maven.MavenInstallation mi = this.getMaven();
        if (mi == null) {
            listener.error("Couldn't find Maven executable.");
            throw new Run.RunnerAbortedException();
        }
        Node node = ActionableHelper.getNode(launcher);
        mi = mi.forNode(node, listener);
        mi = mi.forEnvironment(env);
        return mi.getHome();
    }

    private Maven.MavenInstallation getMaven() {
        Maven.MavenInstallation[] installations;
        for (Maven.MavenInstallation i : installations = this.getDescriptor().getInstallations()) {
            if (this.mavenName == null || !this.mavenName.equals(i.getName())) continue;
            return i;
        }
        return null;
    }

    private String getMavenProjectPath(Run<?, ?> build, FilePath ws) {
        if (build instanceof AbstractBuild) {
            if (StringUtils.isNotBlank((CharSequence)this.getRootPom())) {
                return ((AbstractBuild)build).getModuleRoot().getRemote() + File.separatorChar + this.getRootPom().replace("/pom.xml", "");
            }
            return ((AbstractBuild)build).getModuleRoot().getRemote();
        }
        return ws.getRemote();
    }

    private FilePath copyClassWorldsFile(FilePath ws, URL resource) {
        try {
            FilePath remoteClassworlds = ws.createTextTempFile("classworlds", "conf", "");
            remoteClassworlds.copyFrom(resource);
            return remoteClassworlds;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return FreeStyleProject.class.isAssignableFrom(jobType) || MatrixProject.class.isAssignableFrom(jobType) || Jenkins.get().getPlugin("jenkins-multijob-plugin") != null && MultiJobProject.class.isAssignableFrom(jobType);
        }

        public String getHelpFile() {
            return "/help/project-config/maven.html";
        }

        public String getDisplayName() {
            return Messages.step_displayName();
        }

        public Maven.MavenInstallation[] getInstallations() {
            return ((Maven.DescriptorImpl)Jenkins.get().getDescriptorByType(Maven.DescriptorImpl.class)).getInstallations();
        }

        @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
        public Maven3Builder newInstance(StaplerRequest request, JSONObject formData) throws Descriptor.FormException {
            return (Maven3Builder)((Object)request.bindJSON(this.clazz, formData));
        }
    }
}

