/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;

public abstract class ArtifactorySynchronousStepExecution<T>
extends SynchronousStepExecution<T> {
    protected static final long serialVersionUID = 1L;
    protected transient TaskListener listener;
    protected transient Launcher launcher;
    protected transient WorkflowRun build;
    protected transient FilePath rootWs;
    protected transient FilePath ws;
    protected transient EnvVars env;

    protected ArtifactorySynchronousStepExecution(StepContext context) throws IOException, InterruptedException {
        super(context);
        this.listener = (TaskListener)context.get(TaskListener.class);
        this.build = (WorkflowRun)context.get(WorkflowRun.class);
        this.launcher = (Launcher)context.get(Launcher.class);
        this.ws = (FilePath)context.get(FilePath.class);
        this.rootWs = Utils.extractRootWorkspace(context, this.build, this.ws);
        this.env = (EnvVars)context.get(EnvVars.class);
    }

    protected abstract T runStep() throws Exception;

    public abstract ArtifactoryServer getUsageReportServer() throws Exception;

    public abstract String getUsageReportFeatureName();

    protected T run() throws Exception {
        try {
            ArtifactoryServer server;
            if (this.ws != null) {
                this.ws.mkdirs();
            }
            if ((server = this.getUsageReportServer()) != null) {
                new Thread(() -> server.reportUsage(this.getUsageReportFeatureName(), this.build, new JenkinsBuildInfoLog(this.listener))).start();
            }
            T t = this.runStep();
            return t;
        }
        finally {
            this.listener.getLogger().flush();
        }
    }
}

