/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.EnvExtractor;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.PluginDependencyHelper;

public abstract class BuildInfoProcessRunner
implements Executor {
    TaskListener listener;
    BuildInfo buildInfo;
    Launcher launcher;
    String javaArgs;
    FilePath ws;
    String path;
    String module;
    EnvVars env;
    Run build;

    public BuildInfoProcessRunner(BuildInfo buildInfo, Launcher launcher, String javaArgs, FilePath ws, String path, String module, EnvVars env, TaskListener listener, Run build) {
        this.listener = listener;
        this.buildInfo = Utils.prepareBuildinfo(build, buildInfo);
        this.launcher = launcher;
        this.javaArgs = javaArgs;
        this.ws = ws;
        this.path = Objects.toString(path, ".");
        this.module = module;
        this.env = env;
        this.build = build;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String taskName, String classToExecute, EnvExtractor envExtractor, FilePath tempDir) throws Exception {
        ExtractorUtils.addVcsDetailsToEnv(new FilePath(this.ws, this.path), this.env, this.listener);
        envExtractor.execute();
        String absoluteDependencyDirPath = PluginDependencyHelper.copyExtractorJars(this.env, tempDir);
        FilePath javaTmpDir = new FilePath(tempDir, "javatmpdir");
        try {
            Utils.launch(taskName, this.launcher, this.getArgs(absoluteDependencyDirPath, classToExecute, javaTmpDir), this.env, this.listener, this.ws);
        }
        finally {
            if (javaTmpDir.exists()) {
                javaTmpDir.deleteRecursive();
            }
        }
        String generatedBuildPath = (String)this.env.get((Object)"generated.build.info");
        this.buildInfo.append(Utils.getGeneratedBuildInfo(this.build, this.listener, this.launcher, generatedBuildPath));
        this.buildInfo.setAgentName(Utils.getAgentName(this.ws));
    }

    private ArgumentListBuilder getArgs(String absoluteDependencyDirPath, String classToExecute, FilePath javaTmpDir) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(Utils.getJavaPathBuilder((String)this.env.get((Object)"PATH+JDK"), this.launcher));
        if (StringUtils.isNotBlank((CharSequence)this.javaArgs)) {
            args.add(this.javaArgs.split("\\s+"));
        }
        if (args.toList().stream().noneMatch(s -> s.contains("java.io.tmpdir"))) {
            if (!javaTmpDir.exists()) {
                javaTmpDir.mkdirs();
            }
            args.add("-Djava.io.tmpdir=" + javaTmpDir.getRemote());
        }
        args.add(new String[]{"-cp", absoluteDependencyDirPath + "/*"});
        args.add(classToExecute);
        if (!this.launcher.isUnix()) {
            return args.toWindowsCommand();
        }
        return args;
    }
}

