/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.Env;

public class CollectEnvExecutor
implements Executor {
    private final Run<?, ?> build;
    private final Env env;
    private final EnvVars envVars;
    private transient TaskListener listener;
    private transient FilePath ws;

    public CollectEnvExecutor(Run<?, ?> build, TaskListener listener, FilePath ws, Env env, EnvVars envVars) {
        this.listener = listener;
        this.ws = ws;
        this.env = env;
        this.envVars = envVars;
        this.build = build;
    }

    @Override
    public void execute() throws IOException, InterruptedException {
        Env collectedEnv = (Env)this.ws.act((FilePath.FileCallable)new CollectEnvCallable(this.env.collectBuildParameters(this.build, this.listener), this.envVars));
        this.env.append(collectedEnv);
    }

    public static class CollectEnvCallable
    extends MasterToSlaveFileCallable<Env> {
        private final EnvVars envVars;
        private final Env env;

        CollectEnvCallable(Env env, EnvVars envVars) {
            this.env = env;
            this.envVars = envVars;
        }

        public Env invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
            return this.env.collectVariables(this.envVars);
        }
    }
}

