/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.issuesCollection.IssuesCollector;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.common.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.Issues;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.ProxyUtils;

public class CollectIssuesExecutor
implements Executor {
    private transient Run build;
    private transient TaskListener listener;
    private transient FilePath ws;
    private String buildName;
    private String config;
    private Issues issues;
    private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer pipelineServer;
    private String project;

    public CollectIssuesExecutor(Run build, TaskListener listener, FilePath ws, String buildName, String config, Issues issues, org.jfrog.hudson.pipeline.common.types.ArtifactoryServer pipelineServer, String project) {
        this.build = build;
        this.listener = listener;
        this.ws = ws;
        this.buildName = buildName;
        this.config = config;
        this.issues = issues;
        this.pipelineServer = pipelineServer;
        this.project = project;
    }

    @Override
    public void execute() throws IOException, InterruptedException {
        ArtifactoryManagerBuilder artifactoryManagerBuilder = this.getArtifactoryManagerBuilder(this.pipelineServer, this.build, this.listener);
        org.jfrog.build.extractor.ci.Issues newIssues = (org.jfrog.build.extractor.ci.Issues)this.ws.act((FilePath.FileCallable)new CollectIssuesCallable(new JenkinsBuildInfoLog(this.listener), this.config, artifactoryManagerBuilder, this.buildName, this.ws, this.listener, this.project));
        this.issues.convertAndAppend(newIssues);
    }

    private ArtifactoryManagerBuilder getArtifactoryManagerBuilder(org.jfrog.hudson.pipeline.common.types.ArtifactoryServer pipelineServer, Run build, TaskListener listener) {
        ArtifactoryServer server = Utils.prepareArtifactoryServer(null, pipelineServer);
        CredentialsConfig preferredDeployer = CredentialManager.getPreferredDeployer(new ArtifactoryConfigurator(server), server);
        return server.createArtifactoryManagerBuilder(preferredDeployer.provideCredentials((Item)build.getParent()), ProxyUtils.createProxyConfiguration(), new JenkinsBuildInfoLog(listener));
    }

    public static class CollectIssuesCallable
    extends MasterToSlaveFileCallable<org.jfrog.build.extractor.ci.Issues> {
        private Log logger;
        private String config;
        private ArtifactoryManagerBuilder artifactoryManagerBuilder;
        private String buildName;
        private String project;
        private FilePath ws;
        private TaskListener listener;

        CollectIssuesCallable(Log logger, String config, ArtifactoryManagerBuilder artifactoryManagerBuilder, String buildName, FilePath ws, TaskListener listener, String project) {
            this.logger = logger;
            this.config = config;
            this.artifactoryManagerBuilder = artifactoryManagerBuilder;
            this.buildName = buildName;
            this.project = project;
            this.ws = ws;
            this.listener = listener;
        }

        public org.jfrog.build.extractor.ci.Issues invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
            IssuesCollector issuesCollector = new IssuesCollector();
            return issuesCollector.collectIssues(file, this.logger, this.config, this.artifactoryManagerBuilder, this.buildName, Utils.extractVcs(this.ws, new JenkinsBuildInfoLog(this.listener)), this.project);
        }
    }
}

