/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.ci.Vcs;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;

public class ConanExecutor
implements Executor {
    private static final String CONAN_CLIENT_EXEC = "conan";
    private static final String CONAN_CONFIG_SET_CMD = "conan config set";
    private static final String CONAN_ADD_REMOTE_CMD = "conan remote add";
    private static final String CONAN_ADD_USER_CMD = "conan user";
    private static final String CONAN_BUILD_INFO_CMD = "conan_build_info";
    private static final String CONAN_LOG_FILE = "conan_log.log";
    private BuildInfo buildInfo;
    private String conanHome;
    private ArgumentListBuilder conanCmdArgs;
    private FilePath ws;
    private Launcher launcher;
    private TaskListener listener;
    private EnvVars env;
    private Run build;

    public ConanExecutor(String conanHome, FilePath ws, Launcher launcher, TaskListener listener, EnvVars env, Run build) {
        this(null, conanHome, ws, launcher, listener, env, build);
    }

    public ConanExecutor(BuildInfo buildInfo, String conanHome, FilePath ws, Launcher launcher, TaskListener listener, EnvVars env, Run build) {
        this.buildInfo = buildInfo;
        this.ws = ws;
        this.launcher = launcher;
        this.listener = listener;
        this.build = build;
        this.conanHome = conanHome;
        EnvVars extendedEnv = new EnvVars(env);
        extendedEnv.put("CONAN_USER_HOME", conanHome);
        this.env = extendedEnv;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public void execClientInit() throws Exception {
        this.conanCmdArgs = new ArgumentListBuilder();
        this.conanCmdArgs.addTokenized(CONAN_CONFIG_SET_CMD);
        this.conanCmdArgs.add("log.trace_file=" + StringUtils.trim((String)this.getLogFilePath()));
        this.execute();
    }

    public void execRemoteAdd(String serverName, String serverUrl, boolean force, boolean verifySSL) throws Exception {
        this.conanCmdArgs = new ArgumentListBuilder();
        this.conanCmdArgs.addTokenized(CONAN_ADD_REMOTE_CMD);
        if (force) {
            this.conanCmdArgs.add("--force");
        }
        this.conanCmdArgs.add(serverName);
        this.conanCmdArgs.add(serverUrl);
        this.conanCmdArgs.add(verifySSL ? "True" : "False");
        this.execute();
    }

    public void execUserAdd(String username, String password, String serverName) throws Exception {
        this.conanCmdArgs = new ArgumentListBuilder();
        this.conanCmdArgs.addTokenized(CONAN_ADD_USER_CMD);
        this.conanCmdArgs.add(username);
        this.conanCmdArgs.add("-p");
        this.conanCmdArgs.addMasked(password);
        this.conanCmdArgs.add("-r");
        this.conanCmdArgs.add(serverName);
        this.listener.getLogger().println("Adding conan user '" + username + "', server '" + serverName + "'");
        this.execute();
    }

    public void execCommand(String command) throws Exception {
        this.conanCmdArgs = new ArgumentListBuilder();
        this.conanCmdArgs.add(CONAN_CLIENT_EXEC);
        this.conanCmdArgs.addTokenized(command);
        this.buildInfo = Utils.prepareBuildinfo(this.build, this.buildInfo);
        FilePath conanHomeDirectory = new FilePath(this.launcher.getChannel(), this.conanHome);
        this.persistBuildProperties(conanHomeDirectory);
        this.execute();
        FilePath logFilePath = this.collectConanBuildInfo(this.env);
        org.jfrog.build.extractor.ci.BuildInfo regularBuildInfo = Utils.getGeneratedBuildInfo(this.build, this.listener, this.launcher, logFilePath.getRemote());
        this.buildInfo.append(regularBuildInfo);
    }

    @Override
    public void execute() throws Exception {
        try {
            if (!this.ws.exists()) {
                this.ws.mkdirs();
            }
            if (this.launcher.isUnix()) {
                boolean hasMaskedArguments = this.conanCmdArgs.hasMaskedArguments();
                StringBuilder sb = new StringBuilder();
                for (String arg : this.conanCmdArgs.toList()) {
                    sb.append(Utils.escapeUnixArgument(arg)).append(" ");
                }
                this.conanCmdArgs.clear();
                this.conanCmdArgs.add(new String[]{"sh", "-c"});
                if (hasMaskedArguments) {
                    this.conanCmdArgs.addMasked(sb.toString());
                } else {
                    this.conanCmdArgs.add(sb.toString());
                }
            } else {
                this.conanCmdArgs = this.conanCmdArgs.toWindowsCommand();
            }
        }
        catch (Exception e) {
            this.listener.error("Couldn't execute the conan client executable. " + e.getMessage());
            throw new Run.RunnerAbortedException();
        }
        Utils.launch("Conan", this.launcher, this.conanCmdArgs, this.env, this.listener, this.ws);
    }

    private void persistBuildProperties(FilePath conanHomeDirectory) throws IOException, InterruptedException {
        FilePath buildProperties = new FilePath(conanHomeDirectory, ".conan").child("artifacts.properties");
        long startTime = this.buildInfo.getStartDate().getTime();
        Vcs vcs = Utils.extractVcs(this.ws, new JenkinsBuildInfoLog(this.listener));
        buildProperties.touch(System.currentTimeMillis());
        buildProperties.act((FilePath.FileCallable)new PersistBuildPropertiesCallable(this.buildInfo, startTime, vcs));
    }

    private FilePath collectConanBuildInfo(EnvVars extendedEnv) throws Exception {
        FilePath tempDir = ExtractorUtils.createAndGetTempDir(this.ws);
        FilePath outputFilePath = tempDir.createTextTempFile(CONAN_CLIENT_EXEC, "build-info", "", true);
        this.conanCmdArgs = new ArgumentListBuilder(new String[]{CONAN_BUILD_INFO_CMD, this.getLogFilePath(), "--output", outputFilePath.getRemote()});
        this.execute();
        return outputFilePath;
    }

    public String getLogFilePath() {
        String separator;
        String string = separator = this.launcher.isUnix() ? "/" : "\\";
        if (StringUtils.endsWith((CharSequence)this.conanHome, (CharSequence)separator)) {
            return this.conanHome + CONAN_LOG_FILE;
        }
        return this.conanHome + separator + CONAN_LOG_FILE;
    }

    public static class PersistBuildPropertiesCallable
    extends MasterToSlaveFileCallable<Boolean> {
        private static final String PROPS_PREFIX = "artifact_property_";
        private BuildInfo buildInfo;
        private long startTime;
        private Vcs vcs;

        PersistBuildPropertiesCallable(BuildInfo buildInfo, long startTime, Vcs vcs) {
            this.buildInfo = buildInfo;
            this.startTime = startTime;
            this.vcs = vcs;
        }

        public Boolean invoke(File conanProperties, VirtualChannel channel) throws IOException, InterruptedException {
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(conanProperties.getCanonicalFile()), StandardCharsets.UTF_8.name()));){
                pw.println(String.format("%s=%s", "artifact_property_build.name", this.buildInfo.getName()));
                pw.println(String.format("%s=%s", "artifact_property_build.number", this.buildInfo.getNumber()));
                pw.println(String.format("%s=%s", "artifact_property_build.timestamp", String.valueOf(this.startTime)));
                if (StringUtils.isNotEmpty((CharSequence)this.vcs.getRevision())) {
                    pw.println(String.format("%s=%s", "artifact_property_vcs.revision", this.vcs.getRevision()));
                }
                if (StringUtils.isNotEmpty((CharSequence)this.vcs.getUrl())) {
                    pw.println(String.format("%s=%s", "artifact_property_vcs.url", this.vcs.getUrl()));
                }
            }
            return true;
        }
    }
}

