/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.hudson.pipeline.common.executors.BuildInfoProcessRunner;
import org.jfrog.hudson.pipeline.common.executors.DockerEnvExtractor;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.resolvers.CommonResolver;
import org.jfrog.hudson.util.ExtractorUtils;

public class DockerPullExecutor
extends BuildInfoProcessRunner {
    private final ArtifactoryServer server;
    private final String imageTag;
    private final String host;
    private final String targetRepo;

    public DockerPullExecutor(ArtifactoryServer pipelineServer, BuildInfo buildInfo, Run<?, ?> build, String imageTag, String targetRepo, String host, String javaArgs, Launcher launcher, TaskListener listener, FilePath ws, EnvVars envVars) {
        super(buildInfo, launcher, javaArgs, ws, "", "", envVars, listener, build);
        this.targetRepo = StringUtils.removeEnd((String)targetRepo, (String)"/");
        this.server = pipelineServer;
        this.imageTag = imageTag;
        this.host = host;
    }

    @Override
    public void execute() throws Exception {
        if (this.server == null) {
            throw new IllegalStateException("Artifactory server must be configured");
        }
        CommonResolver resolver = new CommonResolver();
        resolver.setServer(this.server);
        resolver.setRepo(this.targetRepo);
        FilePath tempDir = ExtractorUtils.createAndGetTempDir(this.ws);
        DockerEnvExtractor envExtractor = new DockerEnvExtractor(this.build, this.buildInfo, null, resolver, this.listener, this.launcher, tempDir, this.env, this.imageTag, this.host);
        super.execute("docker", "org.jfrog.build.extractor.docker.extractor.DockerPull", envExtractor, tempDir);
    }

    @Override
    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }
}

