/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.common.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.ProxyUtils;

public class PublishBuildInfoExecutor
implements Executor {
    private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer pipelineServer;
    private TaskListener listener;
    private BuildInfo buildInfo;
    private Run build;
    private FilePath ws;

    public PublishBuildInfoExecutor(Run build, TaskListener listener, BuildInfo buildInfo, org.jfrog.hudson.pipeline.common.types.ArtifactoryServer pipelineServer, FilePath ws) {
        this.pipelineServer = pipelineServer;
        this.buildInfo = buildInfo;
        this.listener = listener;
        this.build = build;
        this.ws = ws;
    }

    @Override
    public void execute() throws Exception {
        this.buildInfo.filterVariables();
        this.buildInfo.appendVcs(Utils.extractVcs(this.ws, new JenkinsBuildInfoLog(this.listener)));
        ArtifactoryServer server = Utils.prepareArtifactoryServer(null, this.pipelineServer);
        try (ArtifactoryManager artifactoryManager = this.createArtifactoryManager(server, this.build, this.listener);){
            this.buildInfo.createDeployer(this.build, this.listener, new ArtifactoryConfigurator(server), artifactoryManager, this.pipelineServer.getPlatformUrl()).deploy();
        }
    }

    private ArtifactoryManager createArtifactoryManager(ArtifactoryServer server, Run build, TaskListener listener) {
        CredentialsConfig preferredDeployer = CredentialManager.getPreferredDeployer(new ArtifactoryConfigurator(server), server);
        return server.createArtifactoryManager(preferredDeployer.provideCredentials((Item)build.getParent()), ProxyUtils.createProxyConfiguration(), new JenkinsBuildInfoLog(listener));
    }
}

