/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import org.jfrog.build.extractor.clientConfiguration.DistributionManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.DistributionManager;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.request.CreateReleaseBundleRequest;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.types.DistributionServer;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;

public class ReleaseBundleCreateExecutor
implements Executor {
    private final DistributionManagerBuilder distributionManagerBuilder;
    private final CreateReleaseBundleRequest request;
    private final transient FilePath ws;
    private final String gpgPassphrase;

    public ReleaseBundleCreateExecutor(DistributionServer server, String name, String version, String spec, String storingRepo, boolean signImmediately, boolean dryRun, String gpgPassphrase, String releaseNotesPath, String releaseNotesSyntax, String description, TaskListener listener, Run<?, ?> build, FilePath ws, EnvVars env) throws IOException {
        this.distributionManagerBuilder = server.createDistributionManagerBuilder(new JenkinsBuildInfoLog(listener), (Item)build.getParent());
        this.request = this.createRequest(name, version, Util.replaceMacro((String)spec, (Map)env), description, storingRepo, signImmediately, dryRun, releaseNotesPath, releaseNotesSyntax);
        this.ws = ws;
        this.gpgPassphrase = gpgPassphrase;
    }

    @Override
    public void execute() throws IOException, InterruptedException {
        this.ws.act((FilePath.FileCallable)new ReleaseBundleCreateCallable(this.distributionManagerBuilder, this.request, this.gpgPassphrase));
    }

    private CreateReleaseBundleRequest createRequest(String name, String version, String spec, String description, String storingRepo, boolean signImmediately, boolean dryRun, String releaseNotesPath, String releaseNotesSyntax) throws IOException {
        return ((CreateReleaseBundleRequest.Builder)((CreateReleaseBundleRequest.Builder)((CreateReleaseBundleRequest.Builder)((CreateReleaseBundleRequest.Builder)((CreateReleaseBundleRequest.Builder)((CreateReleaseBundleRequest.Builder)new CreateReleaseBundleRequest.Builder(name, version).releaseNotes(Utils.createReleaseNotes(releaseNotesPath, releaseNotesSyntax))).storingRepository(storingRepo)).signImmediately(signImmediately)).spec(spec)).description(description)).dryRun(dryRun)).build();
    }

    private static class ReleaseBundleCreateCallable
    extends MasterToSlaveFileCallable<Void> {
        private final DistributionManagerBuilder distributionManagerBuilder;
        private final CreateReleaseBundleRequest request;
        private final String gpgPassphrase;

        public ReleaseBundleCreateCallable(DistributionManagerBuilder distributionManagerBuilder, CreateReleaseBundleRequest request, String gpgPassphrase) {
            this.distributionManagerBuilder = distributionManagerBuilder;
            this.request = request;
            this.gpgPassphrase = gpgPassphrase;
        }

        public Void invoke(File file, VirtualChannel channel) throws IOException, InterruptedException {
            try (DistributionManager distributionManager = this.distributionManagerBuilder.build();){
                distributionManager.createReleaseBundle(this.request, this.gpgPassphrase);
            }
            return null;
        }
    }
}

