/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import org.jfrog.build.extractor.clientConfiguration.DistributionManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.DistributionManager;
import org.jfrog.build.extractor.clientConfiguration.client.distribution.request.UpdateReleaseBundleRequest;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.types.DistributionServer;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;

public class ReleaseBundleUpdateExecutor
implements Executor {
    private final DistributionManagerBuilder distributionManagerBuilder;
    private final UpdateReleaseBundleRequest request;
    private final transient FilePath ws;
    private final String gpgPassphrase;
    private final String version;
    private final String name;

    public ReleaseBundleUpdateExecutor(DistributionServer server, String name, String version, String spec, String storingRepo, boolean signImmediately, boolean dryRun, String gpgPassphrase, String releaseNotesPath, String releaseNotesSyntax, String description, TaskListener listener, Run<?, ?> build, FilePath ws, EnvVars env) throws IOException {
        this.distributionManagerBuilder = server.createDistributionManagerBuilder(new JenkinsBuildInfoLog(listener), (Item)build.getParent());
        this.request = this.createRequest(Util.replaceMacro((String)spec, (Map)env), description, storingRepo, signImmediately, dryRun, releaseNotesPath, releaseNotesSyntax);
        this.ws = ws;
        this.gpgPassphrase = gpgPassphrase;
        this.version = version;
        this.name = name;
    }

    @Override
    public void execute() throws IOException, InterruptedException {
        this.ws.act((FilePath.FileCallable)new ReleaseBundleUpdateCallable(this.distributionManagerBuilder, this.request, this.gpgPassphrase, this.name, this.version));
    }

    private UpdateReleaseBundleRequest createRequest(String spec, String description, String storingRepo, boolean signImmediately, boolean dryRun, String releaseNotesPath, String releaseNotesSyntax) throws IOException {
        return ((UpdateReleaseBundleRequest.Builder)((UpdateReleaseBundleRequest.Builder)((UpdateReleaseBundleRequest.Builder)((UpdateReleaseBundleRequest.Builder)((UpdateReleaseBundleRequest.Builder)((UpdateReleaseBundleRequest.Builder)new UpdateReleaseBundleRequest.Builder().releaseNotes(Utils.createReleaseNotes(releaseNotesPath, releaseNotesSyntax))).storingRepository(storingRepo)).signImmediately(signImmediately)).spec(spec)).description(description)).dryRun(dryRun)).build();
    }

    private static class ReleaseBundleUpdateCallable
    extends MasterToSlaveFileCallable<Void> {
        private final DistributionManagerBuilder distributionManagerBuilder;
        private final UpdateReleaseBundleRequest request;
        private final String gpgPassphrase;
        private final String version;
        private final String name;

        public ReleaseBundleUpdateCallable(DistributionManagerBuilder distributionManagerBuilder, UpdateReleaseBundleRequest request, String gpgPassphrase, String name, String version) {
            this.distributionManagerBuilder = distributionManagerBuilder;
            this.request = request;
            this.gpgPassphrase = gpgPassphrase;
            this.name = name;
            this.version = version;
        }

        public Void invoke(File file, VirtualChannel channel) throws IOException, InterruptedException {
            try (DistributionManager distributionManager = this.distributionManagerBuilder.build();){
                distributionManager.updateReleaseBundle(this.name, this.version, this.request, this.gpgPassphrase);
            }
            return null;
        }
    }
}

