/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.ConanRemote;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;

public class ConanClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CONAN_LOG_FILE = "conan_log.log";
    private transient CpsScript cpsScript;
    private String userPath;
    private boolean unixAgent;
    private ConanRemote remote = new ConanRemote();

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
        this.remote.setCpsScript(cpsScript);
    }

    public void setUnixAgent(boolean unixAgent) {
        this.unixAgent = unixAgent;
    }

    @Whitelisted
    public String getUserPath() {
        return this.userPath;
    }

    public void setUserPath(String conanHomePath) {
        this.userPath = conanHomePath;
        this.remote.setConanHome(conanHomePath);
    }

    @Whitelisted
    public ConanRemote getRemote() {
        return this.remote;
    }

    public void setRemote(ConanRemote remote) {
        this.remote = remote;
    }

    @Whitelisted
    public void run(Map<String, Object> args) {
        if (!args.containsKey("command")) {
            throw new IllegalArgumentException("'command' is a mandatory argument.");
        }
        String command = (String)args.get("command");
        Map<String, Object> stepVariables = this.getRunCommandExecutionArguments(command, (BuildInfo)args.get("buildInfo"));
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        this.cpsScript.invokeMethod("runConanCommand", stepVariables);
    }

    private Map<String, Object> getRunCommandExecutionArguments(String command, BuildInfo buildInfo) {
        LinkedHashMap<String, Object> stepVariables = new LinkedHashMap<String, Object>();
        stepVariables.put("command", command);
        stepVariables.put("conanHome", this.getUserPath());
        stepVariables.put("buildInfo", buildInfo);
        return stepVariables;
    }
}

