/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;

public class ConanRemote
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient CpsScript cpsScript;
    private String conanHome;

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }

    public void setConanHome(String conanHome) {
        this.conanHome = conanHome;
    }

    @Whitelisted
    public String add(Map<String, Object> args) {
        if (!args.containsKey("server") || !args.containsKey("repo")) {
            throw new IllegalArgumentException("server and repo are mandatory arguments.");
        }
        ArtifactoryServer server = (ArtifactoryServer)args.get("server");
        String serverName = args.containsKey("remoteName") ? args.get("remoteName").toString() : UUID.randomUUID().toString();
        String repo = (String)args.get("repo");
        boolean force = args.containsKey("force") && (Boolean)args.get("force") != false;
        boolean verifySSL = args.containsKey("verifySSL") ? (Boolean)args.get("verifySSL") : true;
        this.cpsScript.invokeMethod("conanAddRemote", this.getAddRemoteExecutionArguments(server, serverName, repo, force, verifySSL));
        this.cpsScript.invokeMethod("conanAddUser", this.getAddUserExecutionArguments(server, serverName));
        return serverName;
    }

    private Map<String, Object> getAddRemoteExecutionArguments(ArtifactoryServer server, String serverName, String repo, boolean force, boolean verifySSL) {
        String serverUrl = Utils.buildConanRemoteUrl(server, repo);
        LinkedHashMap<String, Object> stepVariables = new LinkedHashMap<String, Object>();
        stepVariables.put("serverUrl", serverUrl);
        stepVariables.put("serverName", serverName);
        stepVariables.put("conanHome", this.conanHome);
        stepVariables.put("force", force);
        stepVariables.put("verifySSL", verifySSL);
        return stepVariables;
    }

    private Map<String, Object> getAddUserExecutionArguments(ArtifactoryServer server, String serverName) {
        LinkedHashMap<String, Object> stepVariables = new LinkedHashMap<String, Object>();
        stepVariables.put("server", server);
        stepVariables.put("serverName", serverName);
        stepVariables.put("conanHome", this.conanHome);
        return stepVariables;
    }
}

