/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.DistributionServer;

public class JFrogPlatformInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ArtifactoryServer artifactory;
    private final DistributionServer distribution;
    private String id;
    private String url;

    public JFrogPlatformInstance() {
        this.artifactory = new ArtifactoryServer();
        this.distribution = new DistributionServer();
    }

    public JFrogPlatformInstance(ArtifactoryServer artifactory, DistributionServer distribution, String url, String id) {
        this.id = id;
        this.url = StringUtils.removeEnd((String)url, (String)"/");
        this.artifactory = artifactory;
        this.distribution = distribution;
    }

    @Whitelisted
    public ArtifactoryServer getArtifactory() {
        return this.artifactory;
    }

    @Whitelisted
    public DistributionServer getDistribution() {
        return this.distribution;
    }

    public void setCpsScript(CpsScript cpsScript) {
        if (this.artifactory != null) {
            this.artifactory.setCpsScript(cpsScript);
        }
        if (this.distribution != null) {
            this.distribution.setCpsScript(cpsScript);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

