/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.buildInfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class BuildRetention
implements Serializable {
    public static final long serialVersionUID = 1L;
    private boolean deleteBuildArtifacts;
    private int maxBuilds;
    private List<String> doNotDiscardBuilds = new ArrayList<String>();
    private int maxDays;
    private boolean async;

    public BuildRetention() {
        this.clear();
    }

    public org.jfrog.build.extractor.ci.BuildRetention createBuildRetention() {
        org.jfrog.build.extractor.ci.BuildRetention buildRetention = new org.jfrog.build.extractor.ci.BuildRetention();
        buildRetention.setCount(Math.max(this.maxBuilds, -1));
        if (this.maxDays > -1) {
            GregorianCalendar cal = new GregorianCalendar();
            ((Calendar)cal).add(5, -1 * this.maxDays);
            buildRetention.setMinimumBuildDate(cal.getTime());
        } else {
            buildRetention.setMinimumBuildDate(null);
        }
        buildRetention.setBuildNumbersNotToBeDiscarded(this.getDoNotDiscardBuilds());
        buildRetention.setDeleteBuildArtifacts(this.deleteBuildArtifacts);
        return buildRetention;
    }

    @Whitelisted
    public void clear() {
        this.maxDays = -1;
        this.deleteBuildArtifacts = false;
        this.maxBuilds = -1;
        this.doNotDiscardBuilds = new ArrayList<String>();
        this.async = false;
    }

    @Whitelisted
    public int getMaxBuilds() {
        return this.maxBuilds;
    }

    @Whitelisted
    public void setMaxBuilds(int maxBuilds) {
        this.maxBuilds = maxBuilds;
    }

    @Whitelisted
    public int getMaxDays() {
        return this.maxDays;
    }

    @Whitelisted
    public void setMaxDays(int days) {
        this.maxDays = days;
    }

    @Whitelisted
    public void setDeleteBuildArtifacts(boolean deleteBuildArtifacts) {
        this.deleteBuildArtifacts = deleteBuildArtifacts;
    }

    @Whitelisted
    public boolean isDeleteBuildArtifacts() {
        return this.deleteBuildArtifacts;
    }

    @Whitelisted
    public void setDoNotDiscardBuilds(List<String> buildNumbersNotToBeDiscarded) {
        if (buildNumbersNotToBeDiscarded == null) {
            this.doNotDiscardBuilds = new ArrayList<String>();
            return;
        }
        this.doNotDiscardBuilds = buildNumbersNotToBeDiscarded;
    }

    @Whitelisted
    public List<String> getDoNotDiscardBuilds() {
        return this.doNotDiscardBuilds;
    }

    @Whitelisted
    public void setAsync(boolean async) {
        this.async = async;
    }

    @Whitelisted
    public boolean isAsync() {
        return this.async;
    }
}

