/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.builds;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.PackageManagerBuild;
import org.jfrog.hudson.pipeline.common.types.resolvers.CommonResolver;

public class NugetBuild
extends PackageManagerBuild {
    public static final String NUGET_BUILD = "nugetBuild";
    public static final String JAVA_ARGS = "javaArgs";
    private boolean useDotnetCli = false;
    private String apiProtocol = "v2";

    public NugetBuild() {
        this.resolver = new CommonResolver();
    }

    @Whitelisted
    public void resolver(Map<String, Object> resolverArguments) throws Exception {
        this.setResolver(resolverArguments, Arrays.asList("repo", "server"));
    }

    @Whitelisted
    public void run(Map<String, Object> args) {
        Map<String, Object> stepVariables = this.prepareNugetStep(args, Arrays.asList(JAVA_ARGS, "args", "buildInfo", "module"));
        stepVariables.put("args", args.get("args"));
        this.cpsScript.invokeMethod("artifactoryNugetRun", stepVariables);
    }

    public void setUseDotnetCli(boolean useDotnetCli) {
        this.useDotnetCli = useDotnetCli;
    }

    public boolean useDotnetCli() {
        return this.useDotnetCli;
    }

    @Whitelisted
    public void setApiProtocol(String apiProtocol) {
        this.apiProtocol = apiProtocol;
    }

    @Whitelisted
    public String getApiProtocol() {
        return this.apiProtocol;
    }

    private Map<String, Object> prepareNugetStep(Map<String, Object> args, List<String> keysAsList) {
        Set<String> nugetArgumentsSet = args.keySet();
        if (!keysAsList.containsAll(nugetArgumentsSet)) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList.toString());
        }
        Map<String, Object> stepVariables = this.getRunArguments((String)args.get("module"), (BuildInfo)args.get("buildInfo"));
        Utils.appendBuildInfo(this.cpsScript, stepVariables);
        stepVariables.put(JAVA_ARGS, args.get(JAVA_ARGS));
        return stepVariables;
    }

    private Map<String, Object> getRunArguments(String module, BuildInfo buildInfo) {
        LinkedHashMap<String, Object> stepVariables = new LinkedHashMap<String, Object>();
        stepVariables.put(NUGET_BUILD, this);
        stepVariables.put("module", module);
        stepVariables.put("buildInfo", buildInfo);
        return stepVariables;
    }
}

