/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousStepExecution;
import org.jfrog.hudson.pipeline.common.types.DistributionServer;
import org.jfrog.hudson.pipeline.common.types.JFrogPlatformInstance;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CreateServerStep
extends AbstractStepImpl {
    public static final String STEP_NAME = "rtServer";
    private final String id;
    private Integer deploymentThreads;
    private String credentialsId;
    private Boolean bypassProxy;
    private String username;
    private String password;
    private Integer timeout;
    private Integer retry;
    private String url;

    @DataBoundConstructor
    public CreateServerStep(String id) {
        this.id = id;
    }

    @DataBoundSetter
    public void setUrl(String url) {
        this.url = url;
    }

    @DataBoundSetter
    public void setUsername(String username) {
        this.username = username;
    }

    @DataBoundSetter
    public void setPassword(String password) {
        this.password = password;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setBypassProxy(boolean bypassProxy) {
        this.bypassProxy = bypassProxy;
    }

    @DataBoundSetter
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @DataBoundSetter
    public void setRetry(int retry) {
        this.retry = retry;
    }

    @DataBoundSetter
    public void setDeploymentThreads(int deploymentThreads) {
        this.deploymentThreads = deploymentThreads;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return CreateServerStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Creates new Artifactory server";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousStepExecution<Void> {
        protected static final long serialVersionUID = 1L;
        private final transient CreateServerStep step;

        @Inject
        public Execution(CreateServerStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.ws, this.step.id, false);
            if (server == null) {
                server = new org.jfrog.hudson.pipeline.common.types.ArtifactoryServer();
            }
            this.checkInputs(server);
            this.overrideServerParameters(server);
            JFrogPlatformInstance instance = new JFrogPlatformInstance(server, new DistributionServer(), "", this.step.id);
            BuildDataFile buildDataFile = new BuildDataFile("jfrogInstance", this.step.id);
            buildDataFile.putPOJO(instance);
            String buildNumber = BuildUniqueIdentifierHelper.getBuildNumber((Run)this.build);
            DeclarativePipelineUtils.writeBuildDataFile(this.rootWs, buildNumber, buildDataFile, new JenkinsBuildInfoLog(this.listener));
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws Exception {
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return null;
        }

        private void checkInputs(org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server) throws IOException {
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{server.getUrl(), this.step.url})) {
                throw new IOException("Server URL is missing");
            }
            if (StringUtils.isNotBlank((CharSequence)this.step.credentialsId)) {
                if (StringUtils.isNotBlank((CharSequence)this.step.username)) {
                    throw new IOException("'rtServer' step can't include both credentialsId and username");
                }
                if (StringUtils.isNotBlank((CharSequence)this.step.password)) {
                    throw new IOException("'rtServer' step can't include both credentialsId and password");
                }
            }
        }

        private void overrideServerParameters(org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server) {
            if (StringUtils.isNotBlank((CharSequence)this.step.url)) {
                server.setUrl(this.step.url);
            }
            if (StringUtils.isNotBlank((CharSequence)this.step.credentialsId)) {
                server.setCredentialsId(this.step.credentialsId);
            }
            if (StringUtils.isNotBlank((CharSequence)this.step.username)) {
                server.setUsername(this.step.username);
            }
            if (StringUtils.isNotBlank((CharSequence)this.step.password)) {
                server.setPassword(this.step.password);
            }
            if (this.step.deploymentThreads != null) {
                server.setDeploymentThreads(this.step.deploymentThreads);
            }
            if (this.step.bypassProxy != null) {
                server.setBypassProxy(this.step.bypassProxy);
            }
            if (this.step.retry != null) {
                server.getConnection().setRetry(this.step.retry);
            }
            if (this.step.timeout != null) {
                server.getConnection().setTimeout(this.step.timeout);
            }
        }
    }
}

