/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Result;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.jfpipelines.JFrogPipelinesJobInfo;
import org.jfrog.hudson.jfpipelines.JFrogPipelinesServer;
import org.jfrog.hudson.jfpipelines.OutputResource;
import org.jfrog.hudson.jfpipelines.Utils;
import org.jfrog.hudson.jfpipelines.payloads.JobStartedPayload;
import org.jfrog.hudson.jfpipelines.payloads.JobStatusPayload;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousStepExecution;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class JfPipelinesStep
extends AbstractStepImpl {
    public static final String STEP_NAME = "jfPipelines";
    public static final List<String> ACCEPTABLE_RESULTS = Stream.of(Result.FAILURE, Result.SUCCESS, Result.ABORTED, Result.NOT_BUILT, Result.UNSTABLE).map(Result::toString).collect(Collectors.toList());
    private String outputResources;
    private String reportStatus;

    @DataBoundConstructor
    public JfPipelinesStep() {
    }

    @DataBoundSetter
    public void setOutputResources(String outputResources) {
        this.outputResources = outputResources;
    }

    @DataBoundSetter
    public void setReportStatus(String reportStatus) {
        this.reportStatus = reportStatus;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return JfPipelinesStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Set output resources and report results for JFrog Pipelines";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousStepExecution<Void> {
        protected static final long serialVersionUID = 1L;
        private transient JfPipelinesStep step;

        @Inject
        public Execution(JfPipelinesStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            JenkinsBuildInfoLog logger = new JenkinsBuildInfoLog(this.listener);
            JobStartedPayload payload = Utils.getJobStartedPayload(this.build, this.listener);
            if (payload == null || StringUtils.isBlank((CharSequence)payload.getStepId())) {
                logger.info("Skipping jfPipelines step.");
                return null;
            }
            JFrogPipelinesJobInfo jobInfo = (JFrogPipelinesJobInfo)ObjectUtils.defaultIfNull((Object)Utils.getPipelinesJobInfo(this.build), (Object)new JFrogPipelinesJobInfo());
            JFrogPipelinesServer pipelinesServer = Utils.getPipelinesServer();
            if (Utils.isNotConfigured(pipelinesServer)) {
                throw new IllegalStateException("Please configure JFrog Pipelines server under 'Manage Jenkins' -> 'Configure System' -> 'JFrog Pipelines server'.");
            }
            boolean saveJobInfo = false;
            if (StringUtils.isNotBlank((CharSequence)this.step.outputResources)) {
                jobInfo.setOutputResources(this.step.outputResources);
                saveJobInfo = true;
            }
            if (StringUtils.isNotBlank((CharSequence)this.step.reportStatus)) {
                if (!ACCEPTABLE_RESULTS.contains(StringUtils.upperCase((String)this.step.reportStatus))) {
                    throw new IllegalArgumentException("Illegal build results '" + this.step.reportStatus + "'. Acceptable values: " + ACCEPTABLE_RESULTS);
                }
                if (jobInfo.isReported()) {
                    throw new IllegalStateException("This job already reported the status to JFrog Pipelines Step ID " + payload.getStepId() + ". You can run jfPipelines with the 'reportStatus' parameter only once.");
                }
                List<OutputResource> outputResources = OutputResource.fromString(jobInfo.getOutputResources());
                pipelinesServer.report(new JobStatusPayload(this.step.reportStatus, payload.getStepId(), Utils.createJobInfo(this.build), outputResources), logger);
                jobInfo.setReported();
                saveJobInfo = true;
            }
            if (saveJobInfo) {
                this.saveJobInfo(jobInfo, logger);
            }
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws Exception {
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return null;
        }

        private void saveJobInfo(JFrogPipelinesJobInfo jobInfo, JenkinsBuildInfoLog logger) throws Exception {
            BuildDataFile buildDataFile = new BuildDataFile(JfPipelinesStep.STEP_NAME, "0");
            buildDataFile.putPOJO(jobInfo);
            DeclarativePipelineUtils.writeBuildDataFile(Utils.getWorkspace(this.build.getParent()), String.valueOf(this.build.getNumber()), buildDataFile, logger);
        }
    }
}

