/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.PromotionExecutor;
import org.jfrog.hudson.pipeline.common.types.PromotionConfig;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PromoteBuildStep
extends AbstractStepImpl {
    public static final String STEP_NAME = "rtPromote";
    protected PromotionConfig promotionConfig;
    protected String serverId;

    @DataBoundConstructor
    public PromoteBuildStep(String serverId, String targetRepo) {
        this.serverId = serverId;
        this.promotionConfig = new PromotionConfig();
        if (StringUtils.isNotBlank((CharSequence)targetRepo)) {
            this.promotionConfig.setTargetRepo(targetRepo);
        }
    }

    @DataBoundSetter
    public void setBuildName(String buildName) {
        this.promotionConfig.setBuildName(buildName);
    }

    @DataBoundSetter
    public void setBuildNumber(String buildNumber) {
        this.promotionConfig.setBuildNumber(buildNumber);
    }

    @DataBoundSetter
    public void setProject(String project) {
        this.promotionConfig.setProject(project);
    }

    @DataBoundSetter
    public void setSourceRepo(String sourceRepo) {
        this.promotionConfig.setSourceRepo(sourceRepo);
    }

    @DataBoundSetter
    public void setComment(String comment) {
        this.promotionConfig.setComment(comment);
    }

    @DataBoundSetter
    public void setStatus(String status) {
        this.promotionConfig.setStatus(status);
    }

    @DataBoundSetter
    public void setCopy(boolean copy) {
        this.promotionConfig.setCopy(copy);
    }

    @DataBoundSetter
    public void setIncludeDependencies(boolean includeDependencies) {
        this.promotionConfig.setIncludeDependencies(includeDependencies);
    }

    @DataBoundSetter
    public void setFailFast(boolean failFast) {
        this.promotionConfig.setFailFast(failFast);
    }

    PromotionConfig preparePromotionConfig(Run<?, ?> build) {
        if (StringUtils.isBlank((CharSequence)this.promotionConfig.getBuildName())) {
            this.promotionConfig.setBuildName(BuildUniqueIdentifierHelper.getBuildName(build));
        }
        if (StringUtils.isBlank((CharSequence)this.promotionConfig.getBuildNumber())) {
            this.promotionConfig.setBuildNumber(BuildUniqueIdentifierHelper.getBuildNumber(build));
        }
        this.promotionConfig.setProject(this.promotionConfig.getProject());
        return this.promotionConfig;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return PromoteBuildStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Promote build";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        protected static final long serialVersionUID = 1L;
        private final transient PromoteBuildStep step;

        @Inject
        public Execution(PromoteBuildStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            PromotionConfig promotionConfig = this.step.preparePromotionConfig((Run<?, ?>)this.build);
            org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, this.step.serverId, true);
            new PromotionExecutor(Utils.prepareArtifactoryServer(null, server), (Run<?, ?>)this.build, this.listener, this.getContext(), promotionConfig).execute();
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws IOException, InterruptedException {
            org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, this.step.serverId, true);
            return Utils.prepareArtifactoryServer(null, server);
        }

        @Override
        public String getUsageReportFeatureName() {
            return PromoteBuildStep.STEP_NAME;
        }
    }
}

