/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.distribution;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.executors.ReleaseBundleDistributeExecutor;
import org.jfrog.hudson.pipeline.common.types.DistributionServer;
import org.jfrog.hudson.pipeline.declarative.steps.distribution.RemoteReleaseBundleStep;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DistributeReleaseBundleStep
extends RemoteReleaseBundleStep {
    public static final String STEP_NAME = "dsDistributeReleaseBundle";

    @DataBoundConstructor
    public DistributeReleaseBundleStep(String serverId, String name, String version) {
        super(serverId, name, version);
    }

    @DataBoundSetter
    public void setCountryCodes(List<String> countryCodes) {
        this.countryCodes = countryCodes;
    }

    @DataBoundSetter
    public void setDistRules(String distRules) {
        this.distRules = distRules;
    }

    @DataBoundSetter
    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    @DataBoundSetter
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    @DataBoundSetter
    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @DataBoundSetter
    public void setSync(boolean sync) {
        this.sync = sync;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return DistributeReleaseBundleStep.STEP_NAME;
        }

        @Nonnull
        public String getDisplayName() {
            return "Distribute a release bundle";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        protected static final long serialVersionUID = 1L;
        private final transient DistributeReleaseBundleStep step;

        @Inject
        public Execution(DistributeReleaseBundleStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            DistributionServer server = DeclarativePipelineUtils.getDistributionServer(this.build, this.rootWs, this.step.serverId, true);
            new ReleaseBundleDistributeExecutor(server, this.step.name, this.step.version, this.step.dryRun, this.step.sync, this.step.distRules, this.step.countryCodes, this.step.siteName, this.step.cityName, this.listener, (Run<?, ?>)this.build, this.ws).execute();
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return DistributeReleaseBundleStep.STEP_NAME;
        }
    }
}

