/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.distribution;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.executors.ReleaseBundleUpdateExecutor;
import org.jfrog.hudson.pipeline.common.types.DistributionServer;
import org.jfrog.hudson.pipeline.declarative.steps.distribution.CreateUpdateReleaseBundleStep;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class UpdateReleaseBundleStep
extends CreateUpdateReleaseBundleStep {
    public static final String STEP_NAME = "dsUpdateReleaseBundle";

    @DataBoundConstructor
    public UpdateReleaseBundleStep(String serverId, String name, String version, String spec) {
        super(serverId, name, version, spec);
    }

    @DataBoundSetter
    public void setReleaseNotesSyntax(String releaseNotesSyntax) {
        this.releaseNotesSyntax = releaseNotesSyntax;
    }

    @DataBoundSetter
    public void setSignImmediately(boolean signImmediately) {
        this.signImmediately = signImmediately;
    }

    @DataBoundSetter
    public void setReleaseNotesPath(String releaseNotesPath) {
        this.releaseNotesPath = releaseNotesPath;
    }

    @DataBoundSetter
    public void setGpgPassphrase(String gpgPassphrase) {
        this.gpgPassphrase = gpgPassphrase;
    }

    @DataBoundSetter
    public void setStoringRepo(String storingRepo) {
        this.storingRepo = storingRepo;
    }

    @DataBoundSetter
    public void setDescription(String description) {
        this.description = description;
    }

    @DataBoundSetter
    public void setSpecPath(String specPath) {
        this.specPath = specPath;
    }

    @DataBoundSetter
    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return UpdateReleaseBundleStep.STEP_NAME;
        }

        @Nonnull
        public String getDisplayName() {
            return "Update a release bundle";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        protected static final long serialVersionUID = 1L;
        private final transient UpdateReleaseBundleStep step;

        @Inject
        public Execution(UpdateReleaseBundleStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            DistributionServer server = DeclarativePipelineUtils.getDistributionServer(this.build, this.rootWs, this.step.serverId, true);
            String spec = CreateUpdateReleaseBundleStep.getSpec(this.step.specPath, this.step.spec);
            new ReleaseBundleUpdateExecutor(server, this.step.name, this.step.version, spec, this.step.storingRepo, this.step.signImmediately, this.step.dryRun, this.step.gpgPassphrase, this.step.releaseNotesPath, this.step.releaseNotesSyntax, this.step.description, this.listener, (Run<?, ?>)this.build, this.ws, this.env).execute();
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return UpdateReleaseBundleStep.STEP_NAME;
        }
    }
}

