/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.docker;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.BuildInfoProcessRunner;
import org.jfrog.hudson.pipeline.common.executors.CreateDockerBuildExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CreateDockerBuild
extends AbstractStepImpl {
    static final String STEP_NAME = "rtCreateDockerBuild";
    private final String sourceRepo;
    private final String serverId;
    private String kanikoImageFile;
    private String jibImageFiles;
    private String buildNumber;
    private String buildName;
    private String javaArgs;
    private String project;

    @DataBoundConstructor
    public CreateDockerBuild(String serverId, String sourceRepo) {
        this.sourceRepo = sourceRepo;
        this.serverId = serverId;
    }

    @DataBoundSetter
    public void setKanikoImageFile(String kanikoImageFile) {
        this.kanikoImageFile = kanikoImageFile;
    }

    @DataBoundSetter
    public void setJibImageFiles(String jibImageFiles) {
        this.jibImageFiles = jibImageFiles;
    }

    @DataBoundSetter
    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    @DataBoundSetter
    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    @DataBoundSetter
    public void setProject(String project) {
        this.project = project;
    }

    @DataBoundSetter
    public void setJavaArgs(String javaArgs) {
        this.javaArgs = javaArgs;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return CreateDockerBuild.STEP_NAME;
        }

        @Nonnull
        public String getDisplayName() {
            return "run Artifactory create Docker build";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        protected static final long serialVersionUID = 1L;
        private final transient CreateDockerBuild step;

        @Inject
        public Execution(CreateDockerBuild step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            BuildInfo buildInfo = DeclarativePipelineUtils.getBuildInfo(this.rootWs, this.build, this.step.buildName, this.step.buildNumber, this.step.project);
            org.jfrog.hudson.pipeline.common.types.ArtifactoryServer pipelineServer = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, this.step.serverId, true);
            CreateDockerBuildExecutor dockerExecutor = new CreateDockerBuildExecutor(pipelineServer, buildInfo, (Run<?, ?>)this.build, this.step.kanikoImageFile, this.step.jibImageFiles, this.step.sourceRepo, this.step.javaArgs, this.launcher, this.listener, this.ws, this.env);
            dockerExecutor.execute();
            DeclarativePipelineUtils.saveBuildInfo(((BuildInfoProcessRunner)dockerExecutor).getBuildInfo(), this.rootWs, this.build, new JenkinsBuildInfoLog(this.listener));
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(this.step.serverId, null);
        }

        @Override
        public String getUsageReportFeatureName() {
            return CreateDockerBuild.STEP_NAME;
        }
    }
}

