/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.docker;

import com.google.common.collect.ArrayListMultimap;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.DockerPushExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DockerPushStep
extends AbstractStepImpl {
    static final String STEP_NAME = "rtDockerPush";
    private final ArrayListMultimap<String, String> properties = ArrayListMultimap.create();
    private final String serverId;
    private final String image;
    private final String targetRepo;
    private String host;
    private String buildNumber;
    private String buildName;
    private String project;
    private String javaArgs;

    @DataBoundConstructor
    public DockerPushStep(String serverId, String image, String targetRepo, String javaArgs) {
        this.serverId = serverId;
        this.image = image;
        this.targetRepo = targetRepo;
        this.javaArgs = javaArgs;
    }

    @DataBoundSetter
    public void setHost(String host) {
        this.host = host;
    }

    @DataBoundSetter
    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    @DataBoundSetter
    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    @DataBoundSetter
    public void setProject(String project) {
        this.project = project;
    }

    @DataBoundSetter
    public void setJavaArgs(String javaArgs) {
        this.javaArgs = javaArgs;
    }

    @DataBoundSetter
    public void setProperties(String properties) {
        String[] props;
        for (String property : props = properties.split(";")) {
            String[] keyValue = property.split("=");
            if (keyValue.length != 2) continue;
            this.properties.put((Object)keyValue[0], (Object)keyValue[1]);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return DockerPushStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "run Artifactory docker push";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        protected static final long serialVersionUID = 1L;
        private final transient DockerPushStep step;

        @Inject
        public Execution(DockerPushStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            BuildInfo buildInfo = DeclarativePipelineUtils.getBuildInfo(this.rootWs, this.build, this.step.buildName, this.step.buildNumber, this.step.project);
            org.jfrog.hudson.pipeline.common.types.ArtifactoryServer pipelineServer = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, this.step.serverId, true);
            DockerPushExecutor dockerExecutor = new DockerPushExecutor(pipelineServer, buildInfo, (Run)this.build, this.step.image, this.step.targetRepo, this.step.host, this.step.javaArgs, this.launcher, (ArrayListMultimap<String, String>)this.step.properties, this.listener, this.ws, this.env);
            dockerExecutor.execute();
            DeclarativePipelineUtils.saveBuildInfo(dockerExecutor.getBuildInfo(), this.rootWs, this.build, new JenkinsBuildInfoLog(this.listener));
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() {
            return Utils.prepareArtifactoryServer(this.step.serverId, null);
        }

        @Override
        public String getUsageReportFeatureName() {
            return DockerPushStep.STEP_NAME;
        }
    }
}

