/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.generic;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.pipeline.common.executors.GenericUploadExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.declarative.steps.generic.GenericStep;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;

public class UploadStep
extends GenericStep {
    static final String STEP_NAME = "rtUpload";

    @DataBoundConstructor
    public UploadStep(String serverId) {
        super(serverId);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return UploadStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Upload artifacts";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends GenericStep.Execution {
        @Inject
        public Execution(GenericStep step, StepContext context) throws IOException, InterruptedException {
            super(step, context);
        }

        @Override
        public String getUsageReportFeatureName() {
            return UploadStep.STEP_NAME;
        }

        @Override
        protected Void runStep() throws Exception {
            this.setGenericParameters(this.step, this.getContext());
            GenericUploadExecutor genericUploadExecutor = new GenericUploadExecutor(this.artifactoryServer, this.listener, (Run)this.build, this.ws, this.buildInfo, this.getContext(), this.spec, this.step.failNoOp, this.step.module);
            genericUploadExecutor.execute();
            BuildInfo buildInfo = genericUploadExecutor.getBuildInfo();
            buildInfo.captureVariables(this.env, (Run)this.build, this.listener);
            DeclarativePipelineUtils.saveBuildInfo(buildInfo, this.rootWs, this.build, new JenkinsBuildInfoLog(this.listener));
            return null;
        }
    }
}

