/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.go;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.executors.GoRunExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.GoBuild;
import org.jfrog.hudson.pipeline.common.types.resolvers.CommonResolver;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.PropertyUtils;
import org.jfrog.hudson.util.SerializationUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GoRunStep
extends AbstractStepImpl {
    static final String STEP_NAME = "rtGoRun";
    private final GoBuild goBuild = new GoBuild();
    private String customBuildNumber;
    private String customBuildName;
    private String project;
    private String resolverId;
    private String javaArgs;
    private String path;
    private String args;
    private String module;

    @DataBoundConstructor
    public GoRunStep() {
    }

    @DataBoundSetter
    public void setBuildNumber(String customBuildNumber) {
        this.customBuildNumber = customBuildNumber;
    }

    @DataBoundSetter
    public void setBuildName(String customBuildName) {
        this.customBuildName = customBuildName;
    }

    @DataBoundSetter
    public void setProject(String customProject) {
        this.project = customProject;
    }

    @DataBoundSetter
    public void setResolverId(String resolverId) {
        this.resolverId = resolverId;
    }

    @DataBoundSetter
    public void setJavaArgs(String javaArgs) {
        this.javaArgs = javaArgs;
    }

    @DataBoundSetter
    public void setPath(String path) {
        this.path = path;
    }

    @DataBoundSetter
    public void setArgs(String args) {
        this.args = args;
    }

    @DataBoundSetter
    public void setModule(String module) {
        this.module = module;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return GoRunStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "run Artifactory Go publish";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        protected static final long serialVersionUID = 1L;
        private final transient GoRunStep step;

        @Inject
        public Execution(GoRunStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            BuildInfo buildInfo = DeclarativePipelineUtils.getBuildInfo(this.rootWs, this.build, this.step.customBuildName, this.step.customBuildNumber, this.step.project);
            this.setResolver(BuildUniqueIdentifierHelper.getBuildNumber((Run)this.build));
            GoRunExecutor goRunExecutor = new GoRunExecutor(buildInfo, this.launcher, this.step.goBuild, this.step.javaArgs, this.step.args, this.ws, this.step.path, this.step.module, this.env, this.listener, (Run)this.build);
            goRunExecutor.execute();
            DeclarativePipelineUtils.saveBuildInfo(goRunExecutor.getBuildInfo(), this.rootWs, this.build, new JenkinsBuildInfoLog(this.listener));
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws IOException, InterruptedException {
            CommonResolver resolver = this.getResolver(BuildUniqueIdentifierHelper.getBuildNumber((Run)this.build));
            if (resolver != null) {
                return resolver.getArtifactoryServer();
            }
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return GoRunStep.STEP_NAME;
        }

        private CommonResolver getResolver(String buildNumber) throws IOException, InterruptedException {
            if (StringUtils.isBlank((CharSequence)this.step.resolverId)) {
                return null;
            }
            BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(this.rootWs, buildNumber, "rtGoResolver", this.step.resolverId);
            if (buildDataFile == null) {
                throw new IOException("Resolver " + this.step.resolverId + " doesn't exist!");
            }
            return (CommonResolver)SerializationUtils.createMapper().treeToValue((TreeNode)buildDataFile.get("rtGoResolver"), CommonResolver.class);
        }

        private void setResolver(String buildNumber) throws IOException, InterruptedException {
            BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(this.rootWs, buildNumber, "rtGoResolver", this.step.resolverId);
            CommonResolver resolver = this.getResolver(buildNumber);
            resolver.setServer(this.getArtifactoryServer(buildDataFile));
            this.step.goBuild.setResolver(resolver);
            this.addProperties(buildDataFile);
        }

        private void addProperties(BuildDataFile buildDataFile) {
            JsonNode propertiesNode = buildDataFile.get("properties");
            if (propertiesNode != null) {
                this.step.goBuild.getDeployer().getProperties().putAll(PropertyUtils.getDeploymentPropertiesMap(propertiesNode.asText(), this.env));
            }
        }

        private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getArtifactoryServer(BuildDataFile buildDataFile) throws IOException, InterruptedException {
            JsonNode serverId = buildDataFile.get("serverId");
            if (serverId.isNull()) {
                throw new IllegalArgumentException("server ID is missing");
            }
            return DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, serverId.asText(), true);
        }
    }
}

