/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.maven;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.pipeline.ArtifactorySynchronousNonBlockingStepExecution;
import org.jfrog.hudson.pipeline.common.executors.MavenExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.builds.MavenBuild;
import org.jfrog.hudson.pipeline.common.types.deployers.Deployer;
import org.jfrog.hudson.pipeline.common.types.deployers.MavenDeployer;
import org.jfrog.hudson.pipeline.common.types.resolvers.MavenResolver;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.PropertyUtils;
import org.jfrog.hudson.util.SerializationUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MavenStep
extends AbstractStepImpl {
    static final String STEP_NAME = "rtMavenRun";
    private final MavenBuild mavenBuild = new MavenBuild();
    private final String goals;
    private final String pom;
    private String customBuildNumber;
    private String customBuildName;
    private String project;
    private String deployerId;
    private String resolverId;

    @DataBoundConstructor
    public MavenStep(String pom, String goals) {
        this.goals = Objects.toString(goals, "");
        this.pom = Objects.toString(pom, "");
    }

    @DataBoundSetter
    public void setBuildNumber(String customBuildNumber) {
        this.customBuildNumber = customBuildNumber;
    }

    @DataBoundSetter
    public void setBuildName(String customBuildName) {
        this.customBuildName = customBuildName;
    }

    @DataBoundSetter
    public void setProject(String customProject) {
        this.project = customProject;
    }

    @DataBoundSetter
    public void setDeployerId(String deployerId) {
        this.deployerId = deployerId;
    }

    @DataBoundSetter
    public void setResolverId(String resolverId) {
        this.resolverId = resolverId;
    }

    @DataBoundSetter
    public void setTool(String tool) {
        this.mavenBuild.setTool(tool);
    }

    @DataBoundSetter
    public void setUseWrapper(boolean useWrapper) {
        this.mavenBuild.setUseWrapper(useWrapper);
    }

    @DataBoundSetter
    public void setOpts(String opts) {
        this.mavenBuild.setOpts(opts);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return MavenStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "run Artifactory maven";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends ArtifactorySynchronousNonBlockingStepExecution<Void> {
        protected static final long serialVersionUID = 1L;
        private final transient MavenStep step;

        @Inject
        public Execution(MavenStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected Void runStep() throws Exception {
            BuildInfo buildInfo = DeclarativePipelineUtils.getBuildInfo(this.rootWs, this.build, this.step.customBuildName, this.step.customBuildNumber, this.step.project);
            this.setMavenBuild();
            MavenExecutor mavenExecutor = new MavenExecutor(this.listener, this.launcher, (Run)this.build, this.ws, this.env, this.step.mavenBuild, this.step.pom, this.step.goals, buildInfo);
            mavenExecutor.execute();
            buildInfo = mavenExecutor.getBuildInfo();
            DeclarativePipelineUtils.saveBuildInfo(buildInfo, this.rootWs, this.build, new JenkinsBuildInfoLog(this.listener));
            return null;
        }

        @Override
        public ArtifactoryServer getUsageReportServer() throws IOException, InterruptedException {
            Deployer deployer = this.step.mavenBuild.getDeployer();
            if (deployer != null) {
                return deployer.getArtifactoryServer();
            }
            MavenResolver resolver = this.step.mavenBuild.getResolver();
            if (resolver != null) {
                return resolver.getArtifactoryServer();
            }
            return null;
        }

        @Override
        public String getUsageReportFeatureName() {
            return MavenStep.STEP_NAME;
        }

        private void setMavenBuild() throws IOException, InterruptedException {
            String buildNumber = BuildUniqueIdentifierHelper.getBuildNumber((Run)this.build);
            this.setDeployer(buildNumber);
            this.setResolver(buildNumber);
        }

        private void setDeployer(String buildNumber) throws IOException, InterruptedException {
            if (StringUtils.isBlank((CharSequence)this.step.deployerId)) {
                return;
            }
            BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(this.rootWs, buildNumber, "rtMavenDeployer", this.step.deployerId);
            if (buildDataFile == null) {
                throw new IOException("Deployer " + this.step.deployerId + " doesn't exist!");
            }
            MavenDeployer deployer = (MavenDeployer)SerializationUtils.createMapper().treeToValue((TreeNode)buildDataFile.get("rtMavenDeployer"), MavenDeployer.class);
            deployer.setServer(this.getArtifactoryServer(buildNumber, buildDataFile));
            this.step.mavenBuild.setDeployer(deployer);
            this.addProperties(buildDataFile);
        }

        private void addProperties(BuildDataFile buildDataFile) {
            JsonNode propertiesNode = buildDataFile.get("properties");
            if (propertiesNode != null) {
                this.step.mavenBuild.getDeployer().getProperties().putAll(PropertyUtils.getDeploymentPropertiesMap(propertiesNode.asText(), this.env));
            }
        }

        private void setResolver(String buildNumber) throws IOException, InterruptedException {
            if (StringUtils.isBlank((CharSequence)this.step.resolverId)) {
                return;
            }
            BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(this.rootWs, buildNumber, "rtMavenResolver", this.step.resolverId);
            if (buildDataFile == null) {
                throw new IOException("Resolver " + this.step.resolverId + " doesn't exist!");
            }
            MavenResolver resolver = (MavenResolver)SerializationUtils.createMapper().treeToValue((TreeNode)buildDataFile.get("rtMavenResolver"), MavenResolver.class);
            resolver.setServer(this.getArtifactoryServer(buildNumber, buildDataFile));
            this.step.mavenBuild.setResolver(resolver);
        }

        private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getArtifactoryServer(String buildNumber, BuildDataFile buildDataFile) throws IOException, InterruptedException {
            JsonNode serverId = buildDataFile.get("serverId");
            if (serverId.isNull()) {
                throw new IllegalArgumentException("server ID is missing");
            }
            return DeclarativePipelineUtils.getArtifactoryServer(this.build, this.rootWs, serverId.asText(), true);
        }
    }
}

