/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.utils;

import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import jenkins.MasterToSlaveFileCallable;
import org.jfrog.build.api.util.Log;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;

public class CreateBuildDataFileCallable
extends MasterToSlaveFileCallable<Void> {
    private BuildDataFile buildDataFile;
    private String buildNumber;
    private Log logger;

    CreateBuildDataFileCallable(String buildNumber, BuildDataFile buildDataFile, Log logger) {
        this.buildNumber = buildNumber;
        this.buildDataFile = buildDataFile;
        this.logger = logger;
    }

    public Void invoke(File tmpDir, VirtualChannel virtualChannel) throws IOException {
        Path artifactoryPipelineCacheDir = tmpDir.toPath().resolve("artifactory-pipeline-cache");
        DeclarativePipelineUtils.deleteOldBuildDataDirs(artifactoryPipelineCacheDir.toFile(), this.logger);
        Path buildDataDirPath = Files.createDirectories(artifactoryPipelineCacheDir.resolve(this.buildNumber), new FileAttribute[0]);
        File buildDataFile = buildDataDirPath.resolve(DeclarativePipelineUtils.getBuildDataFileName(this.buildDataFile.getStepName(), this.buildDataFile.getId())).toFile();
        if (buildDataFile.createNewFile()) {
            this.logger.debug(buildDataFile.getAbsolutePath() + " created");
            buildDataFile.deleteOnExit();
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(buildDataFile));){
            oos.writeObject(this.buildDataFile);
        }
        return null;
    }
}

